/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.json;

import java.io.BufferedReader;
import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.json.JSONArray;
import org.apache.commons.json.JSONArtifact;
import org.apache.commons.json.JSONException;
import org.apache.commons.json.JSONObject;
import org.apache.commons.json.OrderedJSONObject;

public class JSON {
    public static final Object NULL = null;

    public static JSONArtifact parse(Reader reader, boolean bl) throws JSONException, NullPointerException {
        return JSON.parse(reader, bl, false);
    }

    public static JSONArtifact parse(Reader reader, boolean bl, boolean bl2) throws JSONException, NullPointerException {
        try {
            if (reader != null) {
                Class<?> clazz;
                PushbackReader pushbackReader = null;
                boolean bl3 = false;
                if (!(StringReader.class.isAssignableFrom(clazz = reader.getClass()) || CharArrayReader.class.isAssignableFrom(clazz) || PushbackReader.class.isAssignableFrom(clazz) || BufferedReader.class.isAssignableFrom(clazz))) {
                    bl3 = true;
                }
                pushbackReader = PushbackReader.class.isAssignableFrom(clazz) ? (PushbackReader)reader : new PushbackReader(reader);
                Reader reader2 = pushbackReader;
                int n = pushbackReader.read();
                block7: while (n != -1) {
                    switch (n) {
                        case 123: {
                            pushbackReader.unread(n);
                            if (bl3) {
                                reader2 = new BufferedReader(pushbackReader);
                            }
                            if (bl) {
                                return new OrderedJSONObject(reader2, bl2);
                            }
                            return new JSONObject(reader2, bl2);
                        }
                        case 91: {
                            pushbackReader.unread(n);
                            if (bl3) {
                                reader2 = new BufferedReader(pushbackReader);
                            }
                            return new JSONArray(reader2, bl2);
                        }
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 13: 
                        case 32: {
                            n = pushbackReader.read();
                            continue block7;
                        }
                    }
                    throw new JSONException("Unexpected character: [" + (char)n + "] while scanning JSON String for JSON type.  Invalid JSON.");
                }
                throw new JSONException("Encountered end of stream before JSON data was read.  Invalid JSON");
            }
            throw new NullPointerException("reader cannot be null.");
        }
        catch (IOException iOException) {
            JSONException jSONException = new JSONException("Error occurred during input read.");
            jSONException.initCause(iOException);
            throw jSONException;
        }
    }

    public static JSONArtifact parse(Reader reader) throws JSONException, NullPointerException {
        return JSON.parse(reader, false, false);
    }

    public static JSONArtifact parse(InputStream inputStream, boolean bl) throws JSONException, NullPointerException {
        return JSON.parse(inputStream, bl, false);
    }

    public static JSONArtifact parse(InputStream inputStream, boolean bl, boolean bl2) throws JSONException, NullPointerException {
        if (inputStream != null) {
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
            }
            catch (Exception exception) {
                JSONException jSONException = new JSONException("Could not construct UTF-8 character reader for the InputStream");
                jSONException.initCause(exception);
                throw jSONException;
            }
            return JSON.parse(bufferedReader, bl);
        }
        throw new NullPointerException("is cannot be null");
    }

    public static JSONArtifact parse(InputStream inputStream) throws JSONException, NullPointerException {
        return JSON.parse(inputStream, false, false);
    }

    public static JSONArtifact parse(String string, boolean bl) throws JSONException, NullPointerException {
        return JSON.parse(string, bl, false);
    }

    public static JSONArtifact parse(String string, boolean bl, boolean bl2) throws JSONException, NullPointerException {
        if (string != null) {
            return JSON.parse(new StringReader(string), bl, bl2);
        }
        throw new NullPointerException("str cannot be null");
    }

    public static JSONArtifact parse(String string) throws JSONException, NullPointerException {
        return JSON.parse(string, false, false);
    }
}

