/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.jee;

import com.ibm.appscan.common.model.IScan;
import com.ibm.appscan.common.utils.SystemUtil;
import com.ibm.appscan.discovery.IStrategyFactory;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.Strategy;
import com.ibm.appscan.internal.discovery.java.stage.JavaStagerStrategy;
import com.ibm.appscan.internal.discovery.jee.EARStrategy;
import java.io.File;

public class EARStrategyFactory
implements IStrategyFactory {
    public Strategy createStrategy(File fileOrDirectory, IStrategyFactoryRegistry registry) {
        if (fileOrDirectory.getName().toLowerCase().endsWith(".ear")) {
            if (!SystemUtil.useStagerForJavaFiles()) {
                return new EARStrategy(fileOrDirectory, registry);
            }
            if (registry.useAlternativeStrategy()) {
                return new JavaStagerStrategy(fileOrDirectory, null);
            }
        }
        return null;
    }

    public boolean isBuildOutput() {
        return true;
    }

    public void loadUniqueTarget(IScan scan) {
    }
}

