/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.vs.targets;

import com.hcl.appscan.sdk.scanners.sast.targets.DotNetTarget;
import com.hcl.appscan.sdk.scanners.sast.targets.ISASTTarget;
import com.ibm.appscan.discovery.Strategy;
import com.ibm.appscan.discovery.vs.targets.IDotNetTargetAdapter;
import com.ibm.appscan.discovery.vs.utils.XamarinTargetUtil;
import com.ibm.appscan.internal.discovery.vs.AssemblyStrategy;
import com.ibm.appscan.internal.discovery.vs.DotNetPublishDirectoryStrategy;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class AspNetTargetAdapter
extends DotNetTarget
implements IDotNetTargetAdapter {
    private File m_directory;
    private Properties m_props;
    private Collection<File> m_filesToScan;

    public AspNetTargetAdapter(File directory, Properties props) {
        this.m_directory = directory;
        this.m_props = props;
        this.m_filesToScan = new HashSet<File>();
        this.initializeTarget();
    }

    public String getReferences() {
        return this.m_props.getProperty("references");
    }

    public String getFrameworkVersion() {
        return this.m_props.getProperty("framework_version");
    }

    public File getTargetFile() {
        return this.m_directory;
    }

    @Override
    public Collection<ISASTTarget> toTargets() {
        ArrayList<ISASTTarget> targets = new ArrayList<ISASTTarget>();
        targets.add((ISASTTarget)this);
        targets.addAll(XamarinTargetUtil.getXamarinTargets(this.m_props));
        return targets;
    }

    @Override
    public Map<Strategy, Properties> toStrategies() {
        HashMap<Strategy, Properties> strategies = new HashMap<Strategy, Properties>();
        for (File assembly : this.m_filesToScan) {
            strategies.put(new AssemblyStrategy(assembly, this.m_props), this.m_props);
        }
        strategies.put((Strategy)new DotNetPublishDirectoryStrategy(this.m_directory.getParentFile()), this.m_props);
        strategies.putAll(XamarinTargetUtil.getXamarinStrategies(this.m_props));
        return strategies;
    }

    private Collection<File> getDependencies() {
        File root = this.m_directory.getParentFile().getParentFile();
        File pubBin = new File(root, "pub" + File.separator + "bin");
        return pubBin.isDirectory() ? this.getAssembliesFromDir(pubBin) : this.getManualFilters();
    }

    private Collection<String> getDependencyFileNames() {
        HashSet<String> dependencyNames = new HashSet<String>();
        for (File assembly : this.getDependencies()) {
            dependencyNames.add(assembly.getName());
        }
        return dependencyNames;
    }

    private Collection<File> initializeTarget() {
        Collection<String> dependencies = this.getDependencyFileNames();
        for (File assembly : this.getAssembliesFromDir(this.m_directory)) {
            String name = assembly.getName();
            if (!dependencies.contains(name) || name.equalsIgnoreCase(this.getOutputAssembly().getName())) {
                this.m_filesToScan.add(assembly);
                continue;
            }
            this.getExclusionPatterns().add(name);
        }
        return this.m_filesToScan;
    }

    private Collection<File> getAssembliesFromDir(File directory) {
        HashSet<File> assemblies = new HashSet<File>();
        String name = directory.getName();
        if (directory.isFile() && (name.endsWith(".dll") || name.endsWith(".exe"))) {
            assemblies.add(directory);
        } else if (directory.isDirectory()) {
            for (File file : directory.listFiles()) {
                assemblies.addAll(this.getAssembliesFromDir(file));
            }
        }
        return assemblies;
    }

    private Collection<File> getManualFilters() {
        HashSet<File> referenceAssemblies = new HashSet<File>();
        String refs = this.m_props.getProperty("references", "");
        List<String> references = Arrays.asList(refs.split(";"));
        for (String ref : references) {
            referenceAssemblies.add(new File(ref));
        }
        for (File file : this.getAssembliesFromDir(this.m_directory)) {
            String name = file.getName();
            if (!name.startsWith("System.") && !name.startsWith("Microsoft.")) continue;
            referenceAssemblies.add(file);
        }
        return referenceAssemblies;
    }

    private File getOutputAssembly() {
        return new File(this.m_props.getProperty("output_assembly", ""));
    }
}

