/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.vs.utils;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.ProcessRunner;
import com.ibm.appscan.common.utils.SystemUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class IpvaGenerator {
    private static final String IPVA_GEN_EXE = "IpvaGenerator";
    private File m_targetDirectory;
    private File m_outputDirectory;

    public IpvaGenerator(File targetDirectory, File outputDirectory) {
        this.m_targetDirectory = targetDirectory;
        this.m_outputDirectory = outputDirectory;
    }

    public int run(final IProgress progress) throws IOException {
        ProcessRunner.StreamHandler outputHandler = new ProcessRunner.StreamHandler(){

            protected void handle(String line) {
                progress.setStatus(new Message(1, line));
            }
        };
        ProcessRunner.StreamHandler errorHandler = new ProcessRunner.StreamHandler(){

            protected void handle(String line) {
                progress.setStatus(new Message(4, line));
            }
        };
        return this.getProcessRunner().run(outputHandler, errorHandler);
    }

    private ProcessRunner getProcessRunner() {
        return new ProcessRunner(this.getArgs());
    }

    private String[] getArgs() {
        ArrayList<String> args = new ArrayList<String>();
        args.add(CommonCore.getDirectoryLocator().getBin() + IPVA_GEN_EXE);
        args.add(this.m_targetDirectory.getAbsolutePath());
        if (!SystemUtil.isWindows()) {
            args.add("--");
        }
        args.add("--outputDirectory");
        args.add(this.m_outputDirectory.getAbsolutePath());
        if (SystemUtil.isDebug()) {
            args.add("--logLevel");
            args.add("Debug");
        }
        return args.toArray(new String[0]);
    }
}

