/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.vs;

import com.ibm.appscan.common.IProgress;
import com.ibm.appscan.common.model.IScanTargetMinProxy;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.discovery.IStrategyFactoryRegistry;
import com.ibm.appscan.discovery.dir.CrawlingStrategy;
import com.ibm.appscan.discovery.vs.Messages;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;

public class DotNetSourceStrategy
extends CrawlingStrategy {
    private File m_crawlRoot;
    private List<String> m_sourceFiles;
    private List<String> m_headerFiles;
    private File m_project;
    private String m_languageType;

    public DotNetSourceStrategy() {
    }

    public DotNetSourceStrategy(File project, Properties props) {
        this.m_sourceFiles = new ArrayList<String>();
        this.m_headerFiles = new ArrayList<String>();
        this.addProperties(props);
        this.m_languageType = project.getName().toLowerCase().endsWith(".vcxproj") ? "cpp" : "DotNet";
        this.init(project, null);
    }

    public void init(File file, IStrategyFactoryRegistry registry) {
        this.m_project = file;
    }

    public String getName() {
        return this.m_project.getName();
    }

    public String getType() {
        return "DotNet";
    }

    public String getLanguageType() {
        return this.m_languageType;
    }

    public String getPath() {
        return this.m_project.getPath();
    }

    public String getStrategyClass() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void addProperties(Properties props) {
        String headers;
        String sources = (String)props.remove("sources");
        if (sources != null && !sources.trim().isEmpty()) {
            this.m_sourceFiles.addAll(Arrays.asList(sources.split(";")));
        }
        if ((headers = (String)props.remove("headers")) != null && !headers.trim().isEmpty()) {
            this.m_headerFiles.addAll(Arrays.asList(headers.split(";")));
        }
    }

    protected boolean stageScanTarget(IScanTargetMinProxy proxy, IProgress progress) {
        if (this.m_project.isFile()) {
            this.m_crawlRoot = this.getStagingDirectory(true, "staging");
            this.stageFiles(this.m_sourceFiles, proxy);
            this.stageFiles(this.m_headerFiles, proxy);
        } else {
            this.m_crawlRoot = this.m_project;
        }
        return true;
    }

    protected File getCrawlRoot(IScanTargetMinProxy proxy) {
        return this.m_crawlRoot;
    }

    private void stageFiles(List<String> files, IScanTargetMinProxy proxy) {
        try {
            for (String file : files) {
                File sourceScanFile = new File(file).isAbsolute() ? new File(file) : new File(this.m_project.getParentFile(), file);
                File parentDir = sourceScanFile.getParentFile();
                String grandparentDirName = parentDir.getParentFile().getName();
                String sourceFileWithParentDirs = grandparentDirName + File.separator + parentDir.getName() + File.separator + sourceScanFile.getName();
                File destFile = new File(this.m_crawlRoot, sourceFileWithParentDirs);
                if (!destFile.getParentFile().isDirectory() && !destFile.getParentFile().mkdirs()) {
                    throw new IOException(Messages.getMessage("failed.create.staging.dir", new Object[0]));
                }
                try {
                    IOUtil.copy((File)sourceScanFile, (File)destFile);
                }
                catch (IOException e) {
                    proxy.getErrorManager().reportError(Messages.getMessage("err.staging.file", file));
                }
            }
        }
        catch (IOException e) {
            proxy.getErrorManager().reportError(Messages.getMessage("err.staging", new Object[0]), (Throwable)e);
        }
    }
}

