/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.internal.discovery.was.compilers;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.build.BuilderDefinition;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.common.utils.PathUtil;
import com.ibm.appscan.internal.discovery.was.compilers.WebSphereJSPCompiler;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Map;

public class WebSphereJSPCompilerDefinition
extends BuilderDefinition {
    private File m_websphere;
    private String m_version;
    private String[] m_classpathEntries;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean initClasspathEntries(String classpathFile) {
        InputStream stream = ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(classpathFile);
        if (stream == null) {
            return false;
        }
        ArrayList<String> entries = new ArrayList<String>();
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        try {
            String suffix;
            while ((suffix = reader.readLine()) != null) {
                entries.add(PathUtil.getSanitizedFile((String)this.m_websphere.getPath(), (String)suffix).getPath());
            }
        }
        catch (IOException e) {
            CommonCore.getLogManager().log(new Message(2, e.getMessage()));
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtil.close((Closeable)reader);
        }
        this.m_classpathEntries = entries.toArray(new String[entries.size()]);
        return true;
    }

    protected boolean init(Map<String, String> properties) {
        this.m_version = properties.get(VERSION);
        String was = properties.get("path");
        if (was == null || !(this.m_websphere = new File(was)).exists()) {
            return false;
        }
        if ("7.0".equals(this.m_version)) {
            return this.initClasspathEntries("resources/was70.classpath");
        }
        if ("8.0".equals(this.m_version)) {
            return this.initClasspathEntries("resources/was80.classpath");
        }
        if ("8.5".equals(this.m_version)) {
            return this.initClasspathEntries("resources/was85.classpath");
        }
        if ("9.0".equals(this.m_version)) {
            return this.initClasspathEntries("resources/was90.classpath");
        }
        return false;
    }

    public String getVersion() {
        return this.m_version;
    }

    public Object newBuilder() {
        return new WebSphereJSPCompiler(this.m_websphere, this.m_classpathEntries);
    }
}

