/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.cast.java.translator;

import com.ibm.wala.cast.java.loader.JavaSourceLoaderImpl;
import com.ibm.wala.cast.java.translator.JavaCAst2IRTranslator;
import com.ibm.wala.cast.tree.CAst;
import com.ibm.wala.cast.tree.CAstEntity;
import com.ibm.wala.cast.tree.impl.CAstImpl;
import com.ibm.wala.cast.tree.rewrite.CAstRewriter;
import com.ibm.wala.cast.tree.rewrite.CAstRewriterFactory;
import com.ibm.wala.cast.util.CAstPrinter;
import com.ibm.wala.classLoader.ModuleEntry;
import java.io.PrintWriter;
import java.io.Writer;

public class Java2IRTranslator {
    private final boolean DEBUG;
    protected final JavaSourceLoaderImpl fLoader;
    CAstRewriterFactory castRewriterFactory = null;

    public Java2IRTranslator(JavaSourceLoaderImpl srcLoader) {
        this(srcLoader, false);
    }

    public Java2IRTranslator(JavaSourceLoaderImpl srcLoader, boolean debug) {
        this(srcLoader, null, debug);
    }

    public Java2IRTranslator(JavaSourceLoaderImpl srcLoader, CAstRewriterFactory castRewriterFactory) {
        this(srcLoader, castRewriterFactory, false);
    }

    public Java2IRTranslator(JavaSourceLoaderImpl srcLoader, CAstRewriterFactory castRewriterFactory, boolean debug) {
        this.DEBUG = debug;
        this.fLoader = srcLoader;
        this.castRewriterFactory = castRewriterFactory;
    }

    public void translate(ModuleEntry module, CAstEntity ce) {
        if (this.DEBUG) {
            PrintWriter printWriter = new PrintWriter(System.out);
            CAstPrinter.printTo((CAstEntity)ce, (Writer)printWriter);
            printWriter.flush();
        }
        if (this.castRewriterFactory != null) {
            CAstImpl cast = new CAstImpl();
            CAstRewriter rw = this.castRewriterFactory.createCAstRewriter((CAst)cast);
            ce = rw.rewrite(ce);
            if (this.DEBUG) {
                PrintWriter printWriter = new PrintWriter(System.out);
                CAstPrinter.printTo((CAstEntity)ce, (Writer)printWriter);
                printWriter.flush();
            }
        }
        new JavaCAst2IRTranslator(module, ce, this.fLoader).translate();
    }
}

