/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.javaee;

import com.ibm.appscan.frameworks.analyzers.generic.LangIndependentWalaUtil;
import com.ibm.appscan.frameworks.analyzers.generic.StringConstantFlow;
import com.ibm.appscan.frameworks.analyzers.javaee.BeanUtil;
import com.ibm.appscan.frameworks.specinfo.BeanAccessInfo;
import com.ibm.appscan.frameworks.specinfo.BeanSetMultipleInfo;
import com.ibm.appscan.frameworks.specinfo.BeanSetMultipleInfoImpl;
import com.ibm.appscan.frameworks.specinfo.BeanSetSingleInfo;
import com.ibm.appscan.frameworks.specinfo.BeanSetSingleInfoImpl;
import com.ibm.appscan.frameworks.specinfo.IFrameworkInfo;
import com.ibm.appscan.frameworks.specinfo.Property;
import com.ibm.appscan.frameworks.util.MethodAndCallSiteReference;
import com.ibm.appscan.frameworks.util.WalaUtil;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.strings.StringStuff;
import java.util.Collection;
import java.util.HashMap;

@Deprecated
public class BeanInfoAnalyzer {
    private final AnalysisCache cache;
    private final IClassHierarchy cha;
    private final Collection<MethodReference> singlePropertySetterMethods = HashSetFactory.make();
    private final Collection<MethodReference> multiplePropertySetterMethods = HashSetFactory.make();
    private final MethodReference jspRuntimeLibraryHandleSetProperty;
    private final MethodReference jspRuntimeLibraryIntrospect;
    private final boolean usesJSPs;

    public BeanInfoAnalyzer(AnalysisCache cache, IClassHierarchy cha) {
        this.cache = cache;
        this.cha = cha;
        MethodReference ref = WalaUtil.getUnresolvedMethodRef("org.apache.jasper.runtime.JspRuntimeLibrary", "handleSetProperty(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)V");
        IMethod method = cha.resolveMethod(ref);
        if (method == null) {
            this.usesJSPs = false;
            this.jspRuntimeLibraryHandleSetProperty = null;
            this.jspRuntimeLibraryIntrospect = null;
        } else {
            this.usesJSPs = true;
            this.jspRuntimeLibraryHandleSetProperty = method.getReference();
            this.singlePropertySetterMethods.add(this.jspRuntimeLibraryHandleSetProperty);
            this.jspRuntimeLibraryIntrospect = WalaUtil.getResolvedMethodReference("org.apache.jasper.runtime.JspRuntimeLibrary", "introspect(Ljava/lang/Object;Ljavax/servlet/ServletRequest;)V", cha);
            this.multiplePropertySetterMethods.add(this.jspRuntimeLibraryIntrospect);
        }
    }

    public boolean usesJSPs() {
        return this.usesJSPs;
    }

    public IFrameworkInfo getBeanPopInfo(IClass klass) {
        BeanAccessInfo info;
        MethodReference resolvedTarget;
        assert (this.usesJSPs) : "trying to get info for project that doesn't use beans";
        BeanCallInfo callInfo = this.getBeanCallInfo(klass);
        HashMap accessInfoForCalls = HashMapFactory.make();
        for (MethodAndCallSiteReference setSingleCall : callInfo.beanSetSingleCalls) {
            resolvedTarget = WalaUtil.getResolvedTarget(setSingleCall.getSite(), this.cha);
            if (resolvedTarget.equals((Object)this.jspRuntimeLibraryHandleSetProperty)) {
                info = this.handleJSPRuntimeLibrarySetProperty(setSingleCall);
                accessInfoForCalls.put(setSingleCall, info);
                continue;
            }
            assert (false) : "unknown setter method " + resolvedTarget;
        }
        for (MethodAndCallSiteReference setMultipleCall : callInfo.beanSetMultipleCalls) {
            resolvedTarget = WalaUtil.getResolvedTarget(setMultipleCall.getSite(), this.cha);
            if (resolvedTarget.equals((Object)this.jspRuntimeLibraryIntrospect)) {
                info = this.handleJSPRuntimeLibraryIntrospect(setMultipleCall);
                accessInfoForCalls.put(setMultipleCall, info);
                continue;
            }
            assert (false) : "unknown setter method " + resolvedTarget;
        }
        return null;
    }

    private BeanSetMultipleInfo handleJSPRuntimeLibraryIntrospect(MethodAndCallSiteReference setMultipleCall) {
        IMethod method = setMultipleCall.getMethod();
        IR ir = LangIndependentWalaUtil.getIR((IMethod)method, (AnalysisCache)this.cache);
        DefUse du = LangIndependentWalaUtil.getDU((IR)ir, (AnalysisCache)this.cache);
        SSAAbstractInvokeInstruction callInstr = WalaUtil.getSingleInstructionForCallSite(setMultipleCall.getSite(), ir);
        assert (callInstr.getNumberOfUses() == 2);
        String beanId = this.getBeanId(callInstr, 0, ir, du);
        String beanClassName = this.getBeanClassName(beanId, ir);
        Collection<Property> properties = BeanUtil.getBeanProperties(beanClassName, this.cha);
        return new BeanSetMultipleInfoImpl(beanId, beanClassName, properties);
    }

    private BeanSetSingleInfo handleJSPRuntimeLibrarySetProperty(MethodAndCallSiteReference setSingleCall) {
        IMethod method = setSingleCall.getMethod();
        IR ir = LangIndependentWalaUtil.getIR((IMethod)method, (AnalysisCache)this.cache);
        DefUse du = LangIndependentWalaUtil.getDU((IR)ir, (AnalysisCache)this.cache);
        SSAAbstractInvokeInstruction callInstr = WalaUtil.getSingleInstructionForCallSite(setSingleCall.getSite(), ir);
        assert (callInstr.getNumberOfUses() == 3);
        String beanId = this.getBeanId(callInstr, 0, ir, du);
        String beanPropertyName = this.getBeanPropertyName(callInstr, ir, du);
        String beanClassName = this.getBeanClassName(beanId, ir);
        return new BeanSetSingleInfoImpl(2, beanPropertyName, beanClassName, beanId);
    }

    private String getBeanClassName(String beanId, IR ir) {
        SSAInstruction[] instructions = ir.getInstructions();
        SymbolTable symbolTable = ir.getSymbolTable();
        for (int i = 1; i <= symbolTable.getMaxValueNumber(); ++i) {
            for (int j = 0; j < instructions.length; ++j) {
                String[] localNames = ir.getLocalNames(j, i);
                if (localNames == null) continue;
                for (String localName : localNames) {
                    TypeReference typeReference;
                    TypeInference ti;
                    TypeAbstraction type;
                    if (localName == null || !localName.equals(beanId) || (type = (ti = TypeInference.make((IR)ir, (boolean)false)).getType(i)) == null || (typeReference = type.getTypeReference()) == null) continue;
                    return StringStuff.jvmToReadableType((String)typeReference.getName().toString());
                }
            }
        }
        assert (false) : "couldn't find type for local with name " + beanId;
        return null;
    }

    private String getBeanPropertyName(SSAAbstractInvokeInstruction callInstr, IR ir, DefUse du) {
        int secondArgValNum = callInstr.getUse(1);
        StringConstantFlow constantFlow = StringConstantFlow.makeIntraproc((IR)ir, (DefUse)du);
        Collection stringsPassed = constantFlow.findIntraprocStringsFlowingToVar(secondArgValNum);
        assert (stringsPassed.size() == 1);
        return (String)stringsPassed.iterator().next();
    }

    private String getBeanId(SSAAbstractInvokeInstruction callInstr, int argPosOfFindAttributeCall, IR ir, DefUse du) {
        int argValNum = callInstr.getUse(argPosOfFindAttributeCall);
        SSAInstruction def = du.getDef(argValNum);
        assert (def instanceof SSAAbstractInvokeInstruction);
        SSAAbstractInvokeInstruction findAttributeCall = (SSAAbstractInvokeInstruction)def;
        assert (findAttributeCall.getDeclaredTarget().getName().toString().equals("findAttribute"));
        int valNumPassedToFindAttribute = findAttributeCall.getUse(1);
        StringConstantFlow constantFlow = StringConstantFlow.makeIntraproc((IR)ir, (DefUse)du);
        Collection stringsPassed = constantFlow.findIntraprocStringsFlowingToVar(valNumPassedToFindAttribute);
        assert (stringsPassed.size() == 1);
        return (String)stringsPassed.iterator().next();
    }

    private BeanCallInfo getBeanCallInfo(IClass klass) {
        Collection<MethodAndCallSiteReference> setSingleCalls = WalaUtil.getMatchingCallSites(klass, this.singlePropertySetterMethods, this.cache, this.cha);
        Collection<MethodAndCallSiteReference> setMultipleCalls = WalaUtil.getMatchingCallSites(klass, this.multiplePropertySetterMethods, this.cache, this.cha);
        return new BeanCallInfo(setSingleCalls, setMultipleCalls);
    }

    private static class BeanCallInfo {
        final Collection<MethodAndCallSiteReference> beanSetSingleCalls;
        final Collection<MethodAndCallSiteReference> beanSetMultipleCalls;

        public BeanCallInfo(Collection<MethodAndCallSiteReference> beanSetSingleCalls, Collection<MethodAndCallSiteReference> beanSetMultipleCalls) {
            this.beanSetSingleCalls = beanSetSingleCalls;
            this.beanSetMultipleCalls = beanSetMultipleCalls;
        }
    }
}

