/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.javaee;

import com.ibm.appscan.frameworks.specinfo.AssignableSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.AssignmentExpr;
import com.ibm.appscan.frameworks.specinfo.InvokeExpr;
import com.ibm.appscan.frameworks.specinfo.LocalRefExpr;
import com.ibm.appscan.frameworks.specinfo.NonVoidSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.ObjectRefExpr;
import com.ibm.appscan.frameworks.specinfo.Property;
import com.ibm.appscan.frameworks.specinfo.SyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.TaintExpr;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.frameworks.util.PropertyUtil;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.functions.Function;
import com.ibm.wala.util.strings.StringStuff;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class BeanUtil {
    private static final Logger logger = TaintLogger.i().getLogger();
    public static final Map<String, Function<TaintExpr, NonVoidSyntheticExpr>> standardTypeNameToTaintConverter;

    public static Collection<Property> getBeanProperties(String beanClassName, IClassHierarchy cha) {
        IClass beanClass = cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Application, (String)StringStuff.deployment2CanonicalTypeString((String)beanClassName)));
        if (beanClass == null) {
            TaintLogger.i().getLogger().info((Object)("could not resolve bean class " + beanClass));
            return Collections.emptySet();
        }
        HashSet result = HashSetFactory.make();
        for (IMethod m : beanClass.getAllMethods()) {
            String propName;
            String name;
            if (m.isStatic() || !(name = m.getName().toString()).startsWith("set") || m.getNumberOfParameters() != 2 || !Character.isUpperCase((propName = name.substring(3)).charAt(0))) continue;
            TypeReference propertyType = m.getParameterType(1);
            String propertyName = Character.toLowerCase(propName.charAt(0)) + propName.substring(1);
            Property property = null;
            if (propertyType.isPrimitiveType()) {
                property = PropertyUtil.propertyFromTypeRef(propertyName, propertyType);
            } else {
                IClass propType = cha.lookupClass(propertyType);
                if (propType == null) continue;
                property = PropertyUtil.propertyFromTypeRef(propertyName, propType.getReference());
            }
            if (PropertyUtil.isFiltered(property)) continue;
            result.add(property);
        }
        return result;
    }

    private static NonVoidSyntheticExpr convertTaintToDesiredType(TaintExpr taintExpr, String desiredTypeName) {
        if (desiredTypeName.equals("Ljava/lang/String")) {
            return taintExpr;
        }
        if (standardTypeNameToTaintConverter.containsKey(desiredTypeName)) {
            return (NonVoidSyntheticExpr)standardTypeNameToTaintConverter.get(desiredTypeName).apply((Object)taintExpr);
        }
        return null;
    }

    public static List<SyntheticExpr> taintBeanProperties(String beanClassName, boolean isDynamicBean, String beanLocalName, FilePositionInfo filePosInfo, Collection<Property> beanProperties) {
        ArrayList<SyntheticExpr> statements = new ArrayList<SyntheticExpr>();
        for (Property beanProp : beanProperties) {
            String beanPropName = beanProp.getName();
            String jvmType = StringStuff.deployment2CanonicalTypeString((String)beanProp.getType());
            NonVoidSyntheticExpr converted = BeanUtil.convertTaintToDesiredType(TaintExpr.makeForParameter((String)beanPropName), jvmType);
            if (converted == null) {
                TaintLogger.i().getLogger().info((Object)("don't know how to convert taint to type " + jvmType));
                continue;
            }
            if (isDynamicBean) {
                ObjectRefExpr localRef = ObjectRefExpr.make((NonVoidSyntheticExpr)LocalRefExpr.make((String)beanLocalName), (String)beanPropName);
                AssignmentExpr assignment = AssignmentExpr.make((FilePositionInfo)filePosInfo, (AssignableSyntheticExpr)localRef, (NonVoidSyntheticExpr)converted);
                logger.info((Object)Messages.getString("framework.taint.found", ""));
                logger.info((Object)Messages.getString("framework.generate.write", beanLocalName + "." + beanPropName));
                statements.add((SyntheticExpr)assignment);
                continue;
            }
            String calleeSignature = beanClassName + ".set" + BeanUtil.upperCaseFirstChar(beanPropName) + "(" + jvmType + (PropertyUtil.isPrimitive(beanProp) ? "" : ";") + ")V";
            HashMap actualParameterPos2Value = HashMapFactory.make();
            actualParameterPos2Value.put(0, ObjectRefExpr.make((NonVoidSyntheticExpr)LocalRefExpr.make((String)beanLocalName), (String)""));
            actualParameterPos2Value.put(1, converted);
            logger.info((Object)Messages.getString("framework.taint.param.found", "parameter1", "1"));
            logger.info((Object)Messages.getString("framework.generate.call", calleeSignature));
            InvokeExpr invoke = VDBJavaUtil.invokeFromJVMSig(filePosInfo, calleeSignature, actualParameterPos2Value);
            statements.add((SyntheticExpr)invoke);
        }
        return statements;
    }

    public static List<SyntheticExpr> taintBeanPropertiesIncludingInner(String beanClassName, String beanLocalName, FilePositionInfo filePosInfo, IClassHierarchy cha) {
        ArrayList<SyntheticExpr> statements = new ArrayList<SyntheticExpr>();
        InnerBeanPropertyTainter t = new InnerBeanPropertyTainter(cha, filePosInfo);
        t.run(statements, beanClassName, (NonVoidSyntheticExpr)LocalRefExpr.make((String)beanLocalName), HashSetFactory.make(), "");
        return statements;
    }

    private static String upperCaseFirstChar(String st) {
        char firstChar = st.charAt(0);
        firstChar = Character.toUpperCase(firstChar);
        return firstChar + st.substring(1);
    }

    static {
        HashMap tmp = HashMapFactory.make();
        Function<TaintExpr, NonVoidSyntheticExpr> javaLangBooleanConverter = new Function<TaintExpr, NonVoidSyntheticExpr>(){

            public NonVoidSyntheticExpr apply(TaintExpr t) {
                return VDBJavaUtil.invokeFromJVMSig(null, "java.lang.Boolean.valueOf(Ljava/lang/String;)Ljava/lang/Boolean;", Collections.singletonMap(0, t));
            }
        };
        tmp.put("Ljava/lang/Boolean", javaLangBooleanConverter);
        tmp.put("Z", new Function<TaintExpr, NonVoidSyntheticExpr>((Function)javaLangBooleanConverter){
            final /* synthetic */ Function val$javaLangBooleanConverter;
            {
                this.val$javaLangBooleanConverter = function;
            }

            public NonVoidSyntheticExpr apply(TaintExpr t) {
                return VDBJavaUtil.invokeFromJVMSig(null, "java.lang.Boolean.booleanValue()Z", Collections.singletonMap(0, this.val$javaLangBooleanConverter.apply((Object)t)));
            }
        });
        Function<TaintExpr, NonVoidSyntheticExpr> intConverter = new Function<TaintExpr, NonVoidSyntheticExpr>(){

            public NonVoidSyntheticExpr apply(TaintExpr t) {
                return VDBJavaUtil.invokeFromJVMSig(null, "java.lang.Integer.parseInt(Ljava/lang/String;)I", Collections.singletonMap(0, t));
            }
        };
        tmp.put("I", intConverter);
        tmp.put("Ljava/lang/Integer", new Function<TaintExpr, NonVoidSyntheticExpr>(){

            public NonVoidSyntheticExpr apply(TaintExpr t) {
                return VDBJavaUtil.invokeFromJVMSig(null, "java.lang.Integer.valueOf(Ljava/lang/String;)Ljava/lang/Integer;", Collections.singletonMap(0, t));
            }
        });
        standardTypeNameToTaintConverter = Collections.unmodifiableMap(tmp);
    }

    private static class InnerBeanPropertyTainter {
        private final IClassHierarchy cha;
        private final FilePositionInfo filePosInfo;

        public InnerBeanPropertyTainter(IClassHierarchy cha2, FilePositionInfo filePosInfo2) {
            this.cha = cha2;
            this.filePosInfo = filePosInfo2;
        }

        void run(List<SyntheticExpr> statements, String beanClassName, NonVoidSyntheticExpr beanExpr, Set<String> handledBeanClasses, String requestParameterPrefix) {
            Collection<Property> beanProperties = BeanUtil.getBeanProperties(beanClassName, this.cha);
            ObjectRefExpr refToBeanExpr = ObjectRefExpr.make((NonVoidSyntheticExpr)beanExpr, (String)"");
            for (Property beanProp : beanProperties) {
                String beanPropName = beanProp.getName();
                String jvmType = StringStuff.deployment2CanonicalTypeString((String)beanProp.getType());
                NonVoidSyntheticExpr converted = BeanUtil.convertTaintToDesiredType(TaintExpr.makeForParameter((String)(requestParameterPrefix + beanPropName)), jvmType);
                if (converted == null) {
                    TaintLogger.i().getLogger().info((Object)("don't know how to convert taint to type " + jvmType));
                    continue;
                }
                String calleeSignature = beanClassName + ".set" + BeanUtil.upperCaseFirstChar(beanPropName) + "(" + jvmType + (PropertyUtil.isPrimitive(beanProp) ? "" : ";") + ")V";
                HashMap actualParameterPos2Value = HashMapFactory.make();
                actualParameterPos2Value.put(0, refToBeanExpr);
                actualParameterPos2Value.put(1, converted);
                InvokeExpr invoke = VDBJavaUtil.invokeFromJVMSig(this.filePosInfo, calleeSignature, actualParameterPos2Value);
                statements.add((SyntheticExpr)invoke);
            }
            IClass beanClass = this.cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Application, (String)StringStuff.deployment2CanonicalTypeString((String)beanClassName)));
            if (beanClass == null) {
                TaintLogger.i().getLogger().info((Object)("could not resolve bean class " + beanClass));
                return;
            }
            for (IMethod m : beanClass.getDeclaredMethods()) {
                IClass returnKlass;
                TypeReference returnType;
                String name;
                if (m.isStatic() || !(name = m.getName().toString()).startsWith("get") || m.getNumberOfParameters() != 1 || (returnType = m.getReturnType()).equals((Object)TypeReference.Void) || returnType.isPrimitiveType() || !this.validBeanType(returnKlass = this.cha.lookupClass(returnType))) continue;
                String propName = name.substring(3);
                assert (Character.isUpperCase(propName.charAt(0)));
                String propertyName = Character.toLowerCase(propName.charAt(0)) + propName.substring(1);
                String innerBeanClassName = StringStuff.jvmToReadableType((String)returnKlass.getName().toString());
                if (!handledBeanClasses.add(innerBeanClassName)) continue;
                InvokeExpr innerBeanAccessExpr = VDBJavaUtil.invokeFromJVMSig(this.filePosInfo, m.getSignature(), Collections.singletonMap(0, refToBeanExpr));
                String innerBeanPrefix = requestParameterPrefix + propertyName + ".";
                this.run(statements, innerBeanClassName, (NonVoidSyntheticExpr)innerBeanAccessExpr, handledBeanClasses, innerBeanPrefix);
            }
        }

        private boolean validBeanType(IClass returnKlass) {
            if (returnKlass.getReference().equals((Object)TypeReference.JavaLangString)) {
                return false;
            }
            if (returnKlass.isArrayClass()) {
                return false;
            }
            IClass collection = this.cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Primordial, (String)StringStuff.deployment2CanonicalTypeString((String)"java.util.Collection")));
            assert (collection != null);
            IClass map = this.cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Primordial, (String)StringStuff.deployment2CanonicalTypeString((String)"java.util.Map")));
            assert (map != null);
            if (this.cha.implementsInterface(returnKlass, collection) || this.cha.implementsInterface(returnKlass, map)) {
                return false;
            }
            for (IMethod m : returnKlass.getDeclaredMethods()) {
                if (!m.getName().toString().equals("<init>") || m.getNumberOfParameters() != 1) continue;
                return true;
            }
            return false;
        }
    }
}

