/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.javaee;

import com.ibm.appscan.frameworks.analyzers.javaee.URLPatternType;
import com.ibm.appscan.frameworks.parsers.deploymentDescriptorParser.IJavaEEDeploymentDescriptorInfo;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JavaEEURLFinder {
    private static final String CONSTANT_INPUT = "SomeInput";

    public static String findURLMappingToServlet(String servletName, IJavaEEDeploymentDescriptorInfo ddInfo) {
        if (servletName == null) {
            throw new IllegalArgumentException();
        }
        Map<String, List<String>> allServletMappings = ddInfo.getServletMappings();
        Pair<List<String>, List<String>> servletMappingAndOtherPatterns = JavaEEURLFinder.splitServletMappings(servletName, allServletMappings);
        List otherPatterns = (List)servletMappingAndOtherPatterns.snd;
        List<Pair<String, URLPatternType>> sortedPatternsForServlet = JavaEEURLFinder.sortServletPatterns((List)servletMappingAndOtherPatterns.fst);
        for (Pair<String, URLPatternType> p : sortedPatternsForServlet) {
            String result = null;
            String pattern = (String)p.fst;
            switch ((URLPatternType)((Object)p.snd)) {
                case EXACT_MATCH: {
                    result = pattern;
                    break;
                }
                case ENDS_IN_STAR: {
                    result = JavaEEURLFinder.handleEndsInStarPattern(pattern, otherPatterns);
                    break;
                }
                case STAR_DOT: {
                    result = JavaEEURLFinder.handleStarDotPattern(pattern, otherPatterns);
                    break;
                }
                case DEFAULT: {
                    result = "/";
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private static Pair<List<String>, List<String>> splitServletMappings(String servletName, Map<String, List<String>> allServletMappings) {
        ArrayList servletNamePatterns = new ArrayList();
        ArrayList otherURLPatterns = new ArrayList();
        for (String name : allServletMappings.keySet()) {
            if (!name.equals(servletName)) {
                otherURLPatterns.addAll(allServletMappings.get(name));
                continue;
            }
            servletNamePatterns.addAll(allServletMappings.get(name));
        }
        return Pair.make(servletNamePatterns, otherURLPatterns);
    }

    private static String handleStarDotPattern(String pattern, List<String> otherPatterns) {
        String dotSuffix = pattern.substring(2);
        ArrayList<String> possibleConflicts = new ArrayList<String>();
        Pattern rootConflictPattern = Pattern.compile("^/([^\\*])*\\." + dotSuffix + "$");
        for (String string : otherPatterns) {
            Matcher matcher = rootConflictPattern.matcher(string);
            if (matcher.find()) {
                possibleConflicts.add(string);
                continue;
            }
            if (!string.equals("/*")) continue;
            return null;
        }
        if (possibleConflicts.isEmpty()) {
            return "/SomeInput." + dotSuffix;
        }
        HashSet stringsToAvoid = HashSetFactory.make();
        for (String string : possibleConflicts) {
            String substr = string.substring(1);
            substr = substr.substring(0, substr.indexOf(46));
            stringsToAvoid.add(substr);
        }
        String string = JavaEEURLFinder.genStringNotInSet(stringsToAvoid);
        if (string == null) {
            return null;
        }
        return "/" + string + "." + dotSuffix;
    }

    private static String handleEndsInStarPattern(String pattern, List<String> otherPatterns) {
        String withoutStar = pattern.substring(0, pattern.length() - 1);
        ArrayList<String> possibleLongerMatchPatterns = new ArrayList<String>();
        for (String string : otherPatterns) {
            if (!string.startsWith(withoutStar)) continue;
            possibleLongerMatchPatterns.add(string);
        }
        if (possibleLongerMatchPatterns.isEmpty()) {
            return withoutStar + CONSTANT_INPUT;
        }
        HashSet stringsToAvoid = HashSetFactory.make();
        for (String string : possibleLongerMatchPatterns) {
            String substr = string.substring(withoutStar.length());
            if (substr.contains("/")) {
                substr = substr.substring(0, substr.indexOf(47));
            }
            stringsToAvoid.add(substr);
        }
        String string = JavaEEURLFinder.genStringNotInSet(stringsToAvoid);
        if (string == null) {
            return null;
        }
        return withoutStar + string;
    }

    private static String genStringNotInSet(Set<String> stringsToAvoid) {
        HashSet candidates = Collections.singleton("");
        int maxLength = 4;
        for (int i = 1; i <= maxLength; ++i) {
            HashSet newCandidates = HashSetFactory.make();
            String result = JavaEEURLFinder.tryToExtendCandidates(candidates, stringsToAvoid, newCandidates);
            if (result != null) {
                return result;
            }
            candidates = newCandidates;
        }
        return null;
    }

    private static String tryToExtendCandidates(Set<String> candidates, Set<String> stringsToAvoid, Set<String> newCandidates) {
        for (String candidate : candidates) {
            StringBuilder tmp = new StringBuilder(candidate);
            for (char c = 'a'; c <= 'z'; c = (char)(c + '\u0001')) {
                tmp.append(c);
                String str = tmp.toString();
                if (!stringsToAvoid.contains(str)) {
                    return str;
                }
                newCandidates.add(str);
                tmp.setLength(candidate.length());
            }
        }
        return null;
    }

    private static List<Pair<String, URLPatternType>> sortServletPatterns(List<String> patterns) {
        ArrayList<Pair<String, URLPatternType>> withPatternTypes = new ArrayList<Pair<String, URLPatternType>>();
        for (String pat : patterns) {
            if (pat.equals("/")) {
                withPatternTypes.add((Pair<String, URLPatternType>)Pair.make((Object)pat, (Object)((Object)URLPatternType.DEFAULT)));
                continue;
            }
            if (pat.startsWith("*.")) {
                withPatternTypes.add((Pair<String, URLPatternType>)Pair.make((Object)pat, (Object)((Object)URLPatternType.STAR_DOT)));
                continue;
            }
            if (pat.endsWith("/*")) {
                withPatternTypes.add((Pair<String, URLPatternType>)Pair.make((Object)pat, (Object)((Object)URLPatternType.ENDS_IN_STAR)));
                continue;
            }
            assert (!pat.contains("*"));
            withPatternTypes.add((Pair<String, URLPatternType>)Pair.make((Object)pat, (Object)((Object)URLPatternType.EXACT_MATCH)));
        }
        Collections.sort(withPatternTypes, new Comparator<Pair<String, URLPatternType>>(){

            @Override
            public int compare(Pair<String, URLPatternType> o1, Pair<String, URLPatternType> o2) {
                return ((URLPatternType)((Object)o1.snd)).compareTo((Enum)o2.snd);
            }
        });
        return withPatternTypes;
    }
}

