/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.spring;

import com.ibm.appscan.frameworks.analyzers.generic.LangIndependentWalaUtil;
import com.ibm.appscan.frameworks.analyzers.generic.StringConstantFlow;
import com.ibm.appscan.frameworks.analyzers.javaee.BeanUtil;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.IJSPPrecompilerInfo;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.JspEntrypointResolver;
import com.ibm.appscan.frameworks.analyzers.spring.ISpringControllerInfo;
import com.ibm.appscan.frameworks.analyzers.spring.ModelAndViewUtil;
import com.ibm.appscan.frameworks.analyzers.spring.SpringAppConfigInfo;
import com.ibm.appscan.frameworks.analyzers.spring.SpringBeanUtil;
import com.ibm.appscan.frameworks.analyzers.spring.SpringConfigFileInfo;
import com.ibm.appscan.frameworks.analyzers.spring.SpringEntrypointHandler;
import com.ibm.appscan.frameworks.analyzers.spring.SpringEntrypointInvokeInfo;
import com.ibm.appscan.frameworks.specinfo.AssignableSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.AssignmentExpr;
import com.ibm.appscan.frameworks.specinfo.BeanDecl;
import com.ibm.appscan.frameworks.specinfo.FormalParameterExpr;
import com.ibm.appscan.frameworks.specinfo.GlobalRefExpr;
import com.ibm.appscan.frameworks.specinfo.ISyntheticMethod;
import com.ibm.appscan.frameworks.specinfo.InvokeExpr;
import com.ibm.appscan.frameworks.specinfo.LocalRefExpr;
import com.ibm.appscan.frameworks.specinfo.NonVoidSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.ObjectRefExpr;
import com.ibm.appscan.frameworks.specinfo.SyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.SyntheticMethodImpl;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.frameworks.util.WalaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSALoadMetadataInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.strings.StringStuff;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class ExtendsAbstractFormControllerInfo
implements ISpringControllerInfo {
    private static final TypeReference SPRING_ABSTRACT_FORM_CONTROLLER = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Application, (String)StringStuff.deployment2CanonicalTypeString((String)"org.springframework.web.servlet.mvc.AbstractFormController"));
    private static final Selector PROCESS_FORM_SUBMISSION = Selector.make((String)"processFormSubmission(Ljavax/servlet/http/HttpServletRequest;Ljavax/servlet/http/HttpServletResponse;Ljava/lang/Object;Lorg/springframework/validation/BindException;)Lorg/springframework/web/servlet/ModelAndView;");
    private static final Logger logger = TaintLogger.i().getLogger();
    private static final Selector ON_BIND_SELECTOR_FULL = Selector.make((String)"onBind(Ljavax/servlet/http/HttpServletRequest;Ljava/lang/Object;Lorg/springframework/validation/BindException;)V");
    private static final Selector ON_BIND_SELECTOR_SHORT = Selector.make((String)"onBind(Ljavax/servlet/http/HttpServletRequest;Ljava/lang/Object;)V");
    private static final TypeReference BASE_COMMAND_CONTROLLER_REF = TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Application, (String)StringStuff.deployment2CanonicalTypeString((String)"org.springframework.web.servlet.mvc.BaseCommandController"));
    protected static final Selector ON_BIND_AND_VALIDATE_SELECTOR_FULL = Selector.make((String)"onBindAndValidate(Ljavax/servlet/http/HttpServletRequest;Ljava/lang/Object;Lorg/springframework/validation/BindException;)V");

    @Override
    public boolean isApplicable(IClass klass, IClassHierarchy cha) {
        logger.info((Object)Messages.getString("framework.handler.searching", "org.springframework.web.servlet.mvc.AbstractFormController", ""));
        IClass abstractFormControllerKlass = cha.lookupClass(SPRING_ABSTRACT_FORM_CONTROLLER);
        if (abstractFormControllerKlass == null) {
            logger.info((Object)Messages.getString("framework.missing", "org.springframework.web.servlet.mvc.AbstractFormController"));
            return false;
        }
        boolean result = cha.isAssignableFrom(abstractFormControllerKlass, klass);
        if (!result) {
            logger.info((Object)Messages.getString("framework.missing", "org.springframework.web.servlet.mvc.AbstractFormController"));
        }
        return result;
    }

    @Override
    public Collection<SpringEntrypointInvokeInfo> getSyntheticEntrypointMethods(IClass klass, SpringConfigFileInfo.SpringBeanInfo beanInfo, String idForSignature, IJSPPrecompilerInfo precompilerInfo, String webContentDir, SpringAppConfigInfo configInfo) {
        IClassHierarchy cha = klass.getClassHierarchy();
        ArrayList<BeanDecl> localBeanDeclarations = new ArrayList<BeanDecl>();
        ArrayList<SyntheticExpr> statements = new ArrayList<SyntheticExpr>();
        HashSet globalBeanDeclarations = HashSetFactory.make();
        logger.info((Object)Messages.getString("framework.begin.syntheticmethod", SpringEntrypointHandler.createEntrypointVDBSignature(idForSignature)));
        String formObjectLocalName = "theBean";
        BeanDecl localBeanDecl = this.createFormObject(localBeanDeclarations, formObjectLocalName, statements, beanInfo, klass);
        if (localBeanDecl != null) {
            String commandName;
            String localBeanType = localBeanDecl.getType();
            if (!localBeanType.equals("java.lang.Object")) {
                statements.addAll(this.bindRequestParameters(localBeanType, localBeanDecl, cha, beanInfo.getFilePosInfo()));
            }
            if ((commandName = this.getCommandName(beanInfo, klass)) != null) {
                String heapName = "request." + commandName;
                ObjectRefExpr beanRef = ObjectRefExpr.make((NonVoidSyntheticExpr)GlobalRefExpr.make((String)heapName), (String)"");
                ObjectRefExpr l = ObjectRefExpr.make((NonVoidSyntheticExpr)LocalRefExpr.make((String)formObjectLocalName), (String)"");
                logger.info((Object)Messages.getString("framework.generate.write", heapName));
                statements.add((SyntheticExpr)AssignmentExpr.make((FilePositionInfo)beanInfo.getFilePosInfo(), (AssignableSyntheticExpr)beanRef, (NonVoidSyntheticExpr)l));
                BeanDecl globalBean = BeanDecl.makeWithConcreteType((String)heapName, (String)localBeanDecl.getType(), (BeanDecl.BeanLifespan)BeanDecl.BeanLifespan.ENTRYPOINT);
                globalBeanDeclarations.add(globalBean);
            }
        }
        this.handleOverriddenOnBind(klass, cha, statements, beanInfo, localBeanDecl, formObjectLocalName);
        this.handleRegisteredValidators(klass, cha, statements, beanInfo, localBeanDecl, formObjectLocalName, configInfo);
        this.handleOverriddenOnBindAndValidate(klass, cha, statements, beanInfo, localBeanDecl, formObjectLocalName);
        IMethod controllerEntry = this.doControllerEntryInvoke(klass, beanInfo, cha, statements, formObjectLocalName, localBeanDecl);
        if (controllerEntry != null) {
            statements.addAll(ModelAndViewUtil.getStatementsInvokingEntryOfView(controllerEntry, new AnalysisCache(), configInfo, JspEntrypointResolver.make(precompilerInfo, webContentDir), beanInfo.getFilePosInfo(), webContentDir, beanInfo));
        }
        logger.info((Object)Messages.getString("framework.generate.syntheticmethod", SpringEntrypointHandler.createEntrypointVDBSignature(idForSignature)));
        SyntheticMethodImpl synthMethod = new SyntheticMethodImpl(SpringEntrypointHandler.createEntrypointVDBSignature(idForSignature), localBeanDeclarations, statements);
        return Collections.singleton(SpringEntrypointInvokeInfo.make(controllerEntry, (ISyntheticMethod)synthMethod, globalBeanDeclarations));
    }

    protected void handleRegisteredValidators(IClass klass, IClassHierarchy cha, Collection<SyntheticExpr> statements, SpringConfigFileInfo.SpringBeanInfo beanInfo, BeanDecl localBeanDecl, String formObjectLocalName, SpringAppConfigInfo configInfo) {
        AnalysisCache cache = new AnalysisCache();
        String validateOnBindingProp = SpringBeanUtil.getPropValFromInfoOrConstructor("validateOnBinding", TypeReference.Boolean, beanInfo, klass, new SpringBeanUtil.DefToPropValFun(){

            @Override
            public String apply(IR ir, DefUse du, int valNum) {
                SymbolTable symbolTable = ir.getSymbolTable();
                if (symbolTable.isBooleanOrZeroOneConstant(valNum)) {
                    Object constantValue = symbolTable.getConstantValue(valNum);
                    if (constantValue instanceof Boolean) {
                        return constantValue.toString();
                    }
                    int i = (Integer)constantValue;
                    return i == 0 ? "false" : "true";
                }
                return null;
            }
        }, cache);
        if (validateOnBindingProp != null && validateOnBindingProp.equals("false")) {
            return;
        }
        Set<Object> validatorClassNames = Collections.emptySet();
        Object validatorProp = beanInfo.getProperties().get("validator");
        if (validatorProp != null) {
            String refdBeanClass;
            SpringConfigFileInfo.SpringBeanInfo refdBeanInfo = null;
            if (validatorProp instanceof SpringConfigFileInfo.BeanRef) {
                String beanName = ((SpringConfigFileInfo.BeanRef)validatorProp).getBeanName();
                refdBeanInfo = configInfo.getBeanInfo(beanName);
            } else if (validatorProp instanceof SpringConfigFileInfo.SpringBeanInfo) {
                refdBeanInfo = (SpringConfigFileInfo.SpringBeanInfo)validatorProp;
            }
            if (refdBeanInfo != null && (refdBeanClass = refdBeanInfo.getClassAttr()) != null) {
                validatorClassNames = Collections.singleton(refdBeanClass);
            }
        }
        for (String validatorClassName : validatorClassNames) {
            IMethod validateMethod = cha.resolveMethod(MethodReference.findOrCreate((TypeReference)WalaUtil.createTypeRefForJavaClassName(validatorClassName), (Selector)Selector.make((String)"validate(Ljava/lang/Object;Lorg/springframework/validation/Errors;)V")));
            if (validateMethod == null) continue;
            HashMap actualParameterPos2Value = HashMapFactory.make();
            if (localBeanDecl != null) {
                actualParameterPos2Value.put(1, ObjectRefExpr.make((NonVoidSyntheticExpr)LocalRefExpr.make((String)formObjectLocalName), (String)""));
            }
            logger.info((Object)Messages.getString("framework.generate.call", validateMethod.getSignature()));
            statements.add((SyntheticExpr)VDBJavaUtil.invokeFromJVMSig(beanInfo.getFilePosInfo(), validateMethod.getSignature(), actualParameterPos2Value));
        }
    }

    protected void handleOverriddenOnBind(IClass klass, IClassHierarchy cha, Collection<SyntheticExpr> statements, SpringConfigFileInfo.SpringBeanInfo beanInfo, BeanDecl localBeanDecl, String formObjectLocalName) {
        IMethod onBindShort;
        IClass baseCommandControllerKlass = cha.lookupClass(BASE_COMMAND_CONTROLLER_REF);
        if (baseCommandControllerKlass == null) {
            return;
        }
        IMethod onBindImplToInvoke = null;
        IMethod onBindFull = cha.resolveMethod(klass, ON_BIND_SELECTOR_FULL);
        if (!onBindFull.getDeclaringClass().equals(baseCommandControllerKlass)) {
            onBindImplToInvoke = onBindFull;
        }
        if (!(onBindShort = cha.resolveMethod(klass, ON_BIND_SELECTOR_SHORT)).getDeclaringClass().equals(baseCommandControllerKlass) && onBindImplToInvoke == null) {
            onBindImplToInvoke = onBindShort;
        }
        this.invokeOnBindMethod(statements, beanInfo, localBeanDecl, formObjectLocalName, onBindImplToInvoke);
    }

    protected void handleOverriddenOnBindAndValidate(IClass klass, IClassHierarchy cha, Collection<SyntheticExpr> statements, SpringConfigFileInfo.SpringBeanInfo beanInfo, BeanDecl localBeanDecl, String formObjectLocalName) {
        IClass baseCommandControllerKlass = cha.lookupClass(BASE_COMMAND_CONTROLLER_REF);
        if (baseCommandControllerKlass == null) {
            return;
        }
        IMethod onBindAndValidateImplToInvoke = null;
        IMethod onBindAndValidateFull = cha.resolveMethod(klass, ON_BIND_AND_VALIDATE_SELECTOR_FULL);
        if (!onBindAndValidateFull.getDeclaringClass().equals(baseCommandControllerKlass)) {
            onBindAndValidateImplToInvoke = onBindAndValidateFull;
        }
        this.invokeOnBindMethod(statements, beanInfo, localBeanDecl, formObjectLocalName, onBindAndValidateImplToInvoke);
    }

    protected void invokeOnBindMethod(Collection<SyntheticExpr> statements, SpringConfigFileInfo.SpringBeanInfo beanInfo, BeanDecl localBeanDecl, String formObjectLocalName, IMethod onBindMethod) {
        if (onBindMethod != null) {
            HashMap actualParameterPos2Value = HashMapFactory.make();
            actualParameterPos2Value.put(1, ObjectRefExpr.make((NonVoidSyntheticExpr)FormalParameterExpr.make((int)0), (String)""));
            if (localBeanDecl != null) {
                actualParameterPos2Value.put(2, ObjectRefExpr.make((NonVoidSyntheticExpr)LocalRefExpr.make((String)formObjectLocalName), (String)""));
            }
            logger.info((Object)Messages.getString("framework.generate.call", onBindMethod.getSignature()));
            statements.add((SyntheticExpr)VDBJavaUtil.invokeFromJVMSig(beanInfo.getFilePosInfo(), onBindMethod.getSignature(), actualParameterPos2Value));
        }
    }

    private String getCommandName(SpringConfigFileInfo.SpringBeanInfo beanInfo, IClass klass) {
        return SpringBeanUtil.getPropValFromInfoOrConstructor("commandName", TypeReference.JavaLangString, beanInfo, klass, new SpringBeanUtil.DefToPropValFun(){

            @Override
            public String apply(IR ir, DefUse du, int valNum) {
                StringConstantFlow flow = StringConstantFlow.makeIntraproc((IR)ir, (DefUse)du);
                Collection stringsFlowingToVar = flow.findIntraprocStringsFlowingToVar(valNum);
                if (stringsFlowingToVar.size() == 1) {
                    return (String)stringsFlowingToVar.iterator().next();
                }
                return null;
            }
        }, new AnalysisCache());
    }

    protected IMethod doControllerEntryInvoke(IClass klass, SpringConfigFileInfo.SpringBeanInfo beanInfo, IClassHierarchy cha, Collection<SyntheticExpr> statements, String formObjectLocalName, BeanDecl localBeanDecl) {
        MethodReference processFormSubmissionRef = MethodReference.findOrCreate((TypeReference)klass.getReference(), (Selector)PROCESS_FORM_SUBMISSION);
        IMethod method = cha.resolveMethod(processFormSubmissionRef);
        if (method != null) {
            HashMap actualParameterPos2Value = HashMapFactory.make();
            actualParameterPos2Value.put(1, ObjectRefExpr.make((NonVoidSyntheticExpr)FormalParameterExpr.make((int)0), (String)""));
            actualParameterPos2Value.put(2, ObjectRefExpr.make((NonVoidSyntheticExpr)FormalParameterExpr.make((int)1), (String)""));
            if (localBeanDecl != null) {
                actualParameterPos2Value.put(3, ObjectRefExpr.make((NonVoidSyntheticExpr)LocalRefExpr.make((String)formObjectLocalName), (String)""));
            }
            logger.info((Object)Messages.getString("framework.generate.call", method.getSignature()));
            statements.add((SyntheticExpr)VDBJavaUtil.invokeFromJVMSig(beanInfo.getFilePosInfo(), method.getSignature(), actualParameterPos2Value));
            return method;
        }
        return null;
    }

    private List<SyntheticExpr> bindRequestParameters(String localBeanType, BeanDecl localBeanDecl, IClassHierarchy cha, FilePositionInfo filePosInfo) {
        logger.info((Object)Messages.getString("framework.taint.found", localBeanType));
        return BeanUtil.taintBeanPropertiesIncludingInner(localBeanType, localBeanDecl.getId(), filePosInfo, cha);
    }

    private BeanDecl createFormObject(Collection<BeanDecl> localBeanDeclarations, String formObjectLocalName, Collection<SyntheticExpr> statements, SpringConfigFileInfo.SpringBeanInfo beanInfo, IClass klass) {
        BeanDecl result = null;
        String commandClassVal = this.getCommandClass(beanInfo, klass);
        IMethod formBackingObjectMethod = this.findFormBackingObjectMethod(klass);
        if (formBackingObjectMethod != null) {
            String typeName = null;
            typeName = commandClassVal != null ? commandClassVal : this.inferReturnedTypeOfFormBackingObject(formBackingObjectMethod);
            result = BeanDecl.makeWithConcreteType((String)formObjectLocalName, (String)typeName, (BeanDecl.BeanLifespan)BeanDecl.BeanLifespan.LOCAL);
            localBeanDeclarations.add(result);
            ObjectRefExpr lval = ObjectRefExpr.make((NonVoidSyntheticExpr)LocalRefExpr.make((String)formObjectLocalName), (String)"");
            HashMap actualParameterPos2Value = HashMapFactory.make();
            actualParameterPos2Value.put(1, FormalParameterExpr.make((int)0));
            logger.info((Object)Messages.getString("framework.generate.call", formBackingObjectMethod.getSignature()));
            InvokeExpr rval = VDBJavaUtil.invokeFromJVMSig(beanInfo.getFilePosInfo(), formBackingObjectMethod.getSignature(), actualParameterPos2Value);
            statements.add((SyntheticExpr)AssignmentExpr.make((FilePositionInfo)beanInfo.getFilePosInfo(), (AssignableSyntheticExpr)lval, (NonVoidSyntheticExpr)rval));
        } else if (commandClassVal != null) {
            result = BeanDecl.makeWithConcreteType((String)formObjectLocalName, (String)commandClassVal, (BeanDecl.BeanLifespan)BeanDecl.BeanLifespan.LOCAL);
            localBeanDeclarations.add(result);
        }
        return result;
    }

    private IMethod findFormBackingObjectMethod(IClass klass) {
        Selector formBackingObjectSelector = Selector.make((String)"formBackingObject(Ljavax/servlet/http/HttpServletRequest;)Ljava/lang/Object;");
        for (IMethod m : klass.getDeclaredMethods()) {
            if (!m.getSelector().equals((Object)formBackingObjectSelector)) continue;
            return m;
        }
        return null;
    }

    private String getCommandClass(SpringConfigFileInfo.SpringBeanInfo beanInfo, IClass klass) {
        return SpringBeanUtil.getPropValFromInfoOrConstructor("commandClass", TypeReference.JavaLangClass, beanInfo, klass, new SpringBeanUtil.DefToPropValFun(){

            @Override
            public String apply(IR ir, DefUse du, int valNum) {
                SSAInstruction def = du.getDef(valNum);
                if (def instanceof SSALoadMetadataInstruction) {
                    SSALoadMetadataInstruction loadMetadata = (SSALoadMetadataInstruction)def;
                    TypeReference type = (TypeReference)loadMetadata.getToken();
                    return StringStuff.jvmToReadableType((String)type.getName().toString());
                }
                return null;
            }
        }, new AnalysisCache());
    }

    private String inferReturnedTypeOfFormBackingObject(IMethod formBackingObjectMethod) {
        IR ir = LangIndependentWalaUtil.getIR((IMethod)formBackingObjectMethod, (AnalysisCache)new AnalysisCache());
        TypeInference ti = TypeInference.make((IR)ir, (boolean)false);
        TypeReference returnedType = null;
        for (SSAInstruction instr : Iterator2Iterable.make((Iterator)ir.iterateNormalInstructions())) {
            int returnedVal;
            TypeReference inferredType;
            if (!(instr instanceof SSAReturnInstruction) || (inferredType = ti.getType(returnedVal = instr.getUse(0)).getTypeReference()) == null) continue;
            if (returnedType == null) {
                returnedType = inferredType;
                continue;
            }
            if (returnedType.equals((Object)inferredType)) continue;
            return "java.lang.Object";
        }
        return returnedType == null ? "java.lang.Object" : StringStuff.jvmToReadableType((String)returnedType.getName().toString());
    }
}

