/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.spring;

import com.ibm.appscan.frameworks.analyzers.generic.DispatchResolver;
import com.ibm.appscan.frameworks.analyzers.generic.LangIndependentWalaUtil;
import com.ibm.appscan.frameworks.analyzers.generic.StringConstantFlow;
import com.ibm.appscan.frameworks.analyzers.javaee.jsp.JspEntrypointResolver;
import com.ibm.appscan.frameworks.analyzers.spring.ISpringViewResolver;
import com.ibm.appscan.frameworks.analyzers.spring.SpringAppConfigInfo;
import com.ibm.appscan.frameworks.analyzers.spring.SpringConfigFileInfo;
import com.ibm.appscan.frameworks.analyzers.spring.TilesViewResolver;
import com.ibm.appscan.frameworks.specinfo.ArgToOrigCallExpr;
import com.ibm.appscan.frameworks.specinfo.AssignableSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.AssignmentExpr;
import com.ibm.appscan.frameworks.specinfo.BeanDecl;
import com.ibm.appscan.frameworks.specinfo.CallSiteReplacement;
import com.ibm.appscan.frameworks.specinfo.GlobalRefExpr;
import com.ibm.appscan.frameworks.specinfo.InvokeExpr;
import com.ibm.appscan.frameworks.specinfo.NonVoidSyntheticExpr;
import com.ibm.appscan.frameworks.specinfo.ObjectRefExpr;
import com.ibm.appscan.frameworks.specinfo.SyntheticExpr;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.frameworks.util.WalaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.analysis.typeInference.TypeAbstraction;
import com.ibm.wala.analysis.typeInference.TypeInference;
import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.SSAAbstractInvokeInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSANewInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.types.ClassLoaderReference;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.types.Selector;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Iterable;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ModelAndViewUtil {
    private static final String MODEL_AND_VIEW_NAME = "Lorg/springframework/web/servlet/ModelAndView";
    private static final String MVC_SIMPLE_FORM_CONTROLLER = "org/springframework/web/servlet/mvc/SimpleFormController";
    private static final Logger logger = TaintLogger.i().getLogger();
    private static final int MAX_MODELANDVIEW_CALL_DEPTH = 1;

    public static Set<String> getPossibleViewNames(IMethod controllerMethod, AnalysisCache cache, SpringConfigFileInfo.SpringBeanInfo beanInfo) {
        HashSet result;
        block4: {
            TypeReference returnType;
            block3: {
                result = HashSetFactory.make();
                returnType = controllerMethod.getReturnType();
                if (!returnType.getName().toString().equals(MODEL_AND_VIEW_NAME)) break block3;
                IR ir = LangIndependentWalaUtil.getIR((IMethod)controllerMethod, (AnalysisCache)cache);
                DefUse du = LangIndependentWalaUtil.getDU((IR)ir, (AnalysisCache)cache);
                DispatchResolver dispatchResolver = DispatchResolver.make((IClassHierarchy)controllerMethod.getClassHierarchy());
                for (SSAInstruction instr : Iterator2Iterable.make((Iterator)ir.iterateNormalInstructions())) {
                    if (!(instr instanceof SSAReturnInstruction)) continue;
                    int returnedVal = instr.getUse(0);
                    Collection<Pair<IMethod, Integer>> valsAssignedFreshModelAndView = ModelAndViewUtil.getModelAndViewVals(controllerMethod, ir, du, returnedVal, cache, dispatchResolver, 0);
                    for (Pair<IMethod, Integer> p : valsAssignedFreshModelAndView) {
                        IMethod m = (IMethod)p.fst;
                        IR tmpIR = LangIndependentWalaUtil.getIR((IMethod)m, (AnalysisCache)cache);
                        DefUse tmpDU = LangIndependentWalaUtil.getDU((IR)tmpIR, (AnalysisCache)cache);
                        ModelAndViewUtil.handlesViewNamesForVal(result, tmpIR, tmpDU, (Integer)p.snd, beanInfo);
                    }
                }
                break block4;
            }
            if (!returnType.getName().toString().equals("Ljava/lang/String")) break block4;
            IR ir = LangIndependentWalaUtil.getIR((IMethod)controllerMethod, (AnalysisCache)cache);
            DefUse du = LangIndependentWalaUtil.getDU((IR)ir, (AnalysisCache)cache);
            for (SSAInstruction instr : Iterator2Iterable.make((Iterator)ir.iterateNormalInstructions())) {
                if (!(instr instanceof SSAReturnInstruction)) continue;
                int returnedVal = instr.getUse(0);
                result.addAll(StringConstantFlow.makeIntraproc((IR)ir, (DefUse)du).findIntraprocStringsFlowingToVar(returnedVal));
            }
        }
        return result;
    }

    private static Collection<Pair<IMethod, Integer>> getModelAndViewVals(IMethod m, IR ir, DefUse du, int val, AnalysisCache cache, DispatchResolver dispatchResolver, int curDepth) {
        HashSet result = HashSetFactory.make();
        SSAInstruction def = du.getDef(val);
        if (def instanceof SSANewInstruction) {
            result.add(Pair.make((Object)m, (Object)val));
        } else if (def instanceof SSAAbstractInvokeInstruction && curDepth < 1) {
            SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)def;
            TypeAbstraction receiverType = null;
            if (invoke.isDispatch()) {
                TypeInference ti = TypeInference.make((IR)ir, (boolean)false);
                receiverType = ti.getType(invoke.getReceiver());
            }
            Set possibleTargets = dispatchResolver.computePossibleTargets(invoke.getCallSite(), receiverType);
            for (IMethod target : possibleTargets) {
                IR targetIR = LangIndependentWalaUtil.getIR((IMethod)target, (AnalysisCache)cache);
                if (targetIR == null) continue;
                for (SSAInstruction targetInstr : Iterator2Iterable.make((Iterator)targetIR.iterateNormalInstructions())) {
                    if (!(targetInstr instanceof SSAReturnInstruction)) continue;
                    result.addAll(ModelAndViewUtil.getModelAndViewVals(target, targetIR, LangIndependentWalaUtil.getDU((IR)targetIR, (AnalysisCache)cache), targetInstr.getUse(0), cache, dispatchResolver, curDepth + 1));
                }
            }
        }
        return result;
    }

    private static void handlesViewNamesForVal(Collection<String> result, IR ir, DefUse du, int modelAndViewVal, SpringConfigFileInfo.SpringBeanInfo beanInfo) {
        for (SSAInstruction use : Iterator2Iterable.make((Iterator)du.getUses(modelAndViewVal))) {
            if (!(use instanceof SSAAbstractInvokeInstruction)) continue;
            SSAAbstractInvokeInstruction invoke = (SSAAbstractInvokeInstruction)use;
            MethodReference targetRef = invoke.getDeclaredTarget();
            ModelAndViewUtil.getViewNameFromCall(result, ir, du, invoke, targetRef, beanInfo, "<init>");
            ModelAndViewUtil.getViewNameFromCall(result, ir, du, invoke, targetRef, beanInfo, "setViewName");
        }
    }

    private static void getViewNameFromCall(Collection<String> result, IR ir, DefUse du, SSAAbstractInvokeInstruction invoke, MethodReference targetRef, SpringConfigFileInfo.SpringBeanInfo beanInfo, String functionCall) {
        TypeReference parameterType;
        if (targetRef.getName().toString().equals(functionCall) && targetRef.getDeclaringClass().getName().toString().equals(MODEL_AND_VIEW_NAME) && targetRef.getNumberOfParameters() > 0 && (parameterType = targetRef.getParameterType(0)).getName().toString().equals("Ljava/lang/String")) {
            int viewParam = invoke.getUse(1);
            SSAInstruction def = du.getDef(viewParam);
            if (def instanceof SSAAbstractInvokeInstruction) {
                IClass theSimpleFormController;
                IClass theClass;
                SSAAbstractInvokeInstruction i = (SSAAbstractInvokeInstruction)def;
                TypeReference tr = i.getDeclaredTarget().getDeclaringClass();
                IClassHierarchy cha = ir.getMethod().getClassHierarchy();
                if (cha.isSubclassOf(theClass = cha.lookupClass(tr), theSimpleFormController = cha.lookupClass(TypeReference.findOrCreate((ClassLoaderReference)ClassLoaderReference.Application, (String)VDBJavaUtil.vdbToJVMType(MVC_SIMPLE_FORM_CONTROLLER))))) {
                    Selector theSelector = i.getDeclaredTarget().getSelector();
                    if (theSelector.toString().equals("getSuccessView()Ljava/lang/String;")) {
                        Map<String, Object> m = beanInfo.getProperties();
                        String s = m.get("successView").toString();
                        result.add(s);
                    } else if (theSelector.toString().equals("getFormView()Ljava/lang/String;")) {
                        Map<String, Object> m = beanInfo.getProperties();
                        String s = m.get("formView").toString();
                        result.add(s);
                    }
                }
            }
            StringConstantFlow flow = StringConstantFlow.makeIntraproc((IR)ir, (DefUse)du);
            result.addAll(flow.findIntraprocStringsFlowingToVar(viewParam));
        }
    }

    public static ISpringViewResolver getViewResolver(SpringAppConfigInfo configInfo, String webContentDir) {
        for (SpringConfigFileInfo.SpringBeanInfo beanInfo : configInfo.getAllBeanInfo()) {
            String classAttr = beanInfo.getClassAttr();
            if (classAttr != null && classAttr.equals("org.springframework.web.servlet.view.InternalResourceViewResolver")) {
                return ModelAndViewUtil.handleInternalResourceViewResolver(beanInfo, configInfo, webContentDir);
            }
            if (classAttr == null || !classAttr.equals("org.springframework.web.servlet.view.UrlBasedViewResolver")) continue;
            return ModelAndViewUtil.handleUrlBasedViewResolver(beanInfo, configInfo, webContentDir);
        }
        return null;
    }

    private static ISpringViewResolver handleInternalResourceViewResolver(SpringConfigFileInfo.SpringBeanInfo beanInfo, SpringAppConfigInfo configInfo, String webContentDir) {
        String viewClass;
        Map<String, Object> properties = beanInfo.getProperties();
        String prefixProp = (String)properties.get("prefix");
        final String prefix = prefixProp != null ? prefixProp : "";
        String suffixProp = (String)properties.get("suffix");
        final String suffix = suffixProp != null ? suffixProp : "";
        String viewClassProp = (String)properties.get("viewClass");
        String defaultViewClass = "org.springframework.web.servlet.view.InternalResourceView";
        String string = viewClass = viewClassProp != null ? viewClassProp : defaultViewClass;
        if (viewClass.equals("org.springframework.web.servlet.view.tiles.TilesJstlView")) {
            return TilesViewResolver.make(configInfo, webContentDir, prefix, suffix);
        }
        if (viewClass.equals(defaultViewClass) || viewClass.equals("org.springframework.web.servlet.view.JstlView")) {
            return new ISpringViewResolver(){

                @Override
                public Collection<String> resolveView(String viewName) {
                    return Collections.singleton(prefix + viewName + suffix);
                }
            };
        }
        return null;
    }

    private static ISpringViewResolver handleUrlBasedViewResolver(SpringConfigFileInfo.SpringBeanInfo beanInfo, SpringAppConfigInfo configInfo, String webContentDir) {
        String viewClass;
        Map<String, Object> properties = beanInfo.getProperties();
        String prefixProp = (String)properties.get("prefix");
        final String prefix = prefixProp != null ? prefixProp : "";
        String suffixProp = (String)properties.get("suffix");
        final String suffix = suffixProp != null ? suffixProp : "";
        String viewClassProp = (String)properties.get("viewClass");
        String defaultViewClass = "org.springframework.web.servlet.view.InternalResourceView";
        String string = viewClass = viewClassProp != null ? viewClassProp : defaultViewClass;
        if (viewClass.equals("org.springframework.web.servlet.view.tiles.TilesJstlView")) {
            return TilesViewResolver.make(configInfo, webContentDir, prefix, suffix);
        }
        if (viewClass.equals(defaultViewClass) || viewClass.equals("org.springframework.web.servlet.view.JstlView")) {
            return new ISpringViewResolver(){

                @Override
                public Collection<String> resolveView(String viewName) {
                    return Collections.singleton(prefix + viewName + suffix);
                }
            };
        }
        return null;
    }

    public static List<InvokeExpr> getStatementsInvokingEntryOfView(IMethod controllerMethod, AnalysisCache cache, SpringAppConfigInfo configInfo, JspEntrypointResolver resolver, FilePositionInfo filePosInfo, String webContentDir, SpringConfigFileInfo.SpringBeanInfo beanInfo) {
        ISpringViewResolver viewResolver = ModelAndViewUtil.getViewResolver(configInfo, webContentDir);
        if (viewResolver == null) {
            return Collections.emptyList();
        }
        ArrayList<InvokeExpr> result = new ArrayList<InvokeExpr>();
        Set<String> possibleViewNames = ModelAndViewUtil.getPossibleViewNames(controllerMethod, cache, beanInfo);
        HashSet paths = HashSetFactory.make();
        for (String viewName : possibleViewNames) {
            paths.addAll(viewResolver.resolveView(viewName));
        }
        for (String path : paths) {
            InvokeExpr invokeExpr = resolver.getInvokeForEntryOfPathTarget(path, filePosInfo, 0, 1);
            if (invokeExpr == null) continue;
            logger.info((Object)Messages.getString("framework.generate.call", invokeExpr.getCalleeVDBSignature()));
            result.add(invokeExpr);
        }
        return result;
    }

    public static Set<String> getPathsToViewEntrypoints(IMethod controllerMethod, AnalysisCache cache, SpringAppConfigInfo configInfo, String webContentDir) {
        ISpringViewResolver viewResolver = ModelAndViewUtil.getViewResolver(configInfo, webContentDir);
        if (viewResolver == null) {
            return Collections.emptySet();
        }
        Set<String> possibleViewNames = ModelAndViewUtil.getPossibleViewNames(controllerMethod, cache, null);
        HashSet paths = HashSetFactory.make();
        for (String viewName : possibleViewNames) {
            paths.addAll(viewResolver.resolveView(viewName));
        }
        return paths;
    }

    public static Pair<Map<String, Set<CallSiteReplacement>>, Set<BeanDecl>> getReplacementsForModelUpdate(IMethod controllerMethod, AnalysisCache cache, FilePositionInfo filePosInfo) {
        HashMap callReplacements = HashMapFactory.make();
        HashSet globalBeans = HashSetFactory.make();
        IR ir = LangIndependentWalaUtil.getIR((IMethod)controllerMethod, (AnalysisCache)cache);
        DefUse du = LangIndependentWalaUtil.getDU((IR)ir, (AnalysisCache)cache);
        TypeInference ti = null;
        HashSet handledSites = HashSetFactory.make();
        for (SSAInstruction instr : Iterator2Iterable.make((Iterator)ir.iterateNormalInstructions())) {
            SSAAbstractInvokeInstruction call;
            CallSiteReference callSiteRef;
            MethodReference targetRef;
            if (instr instanceof SSAAbstractInvokeInstruction && (targetRef = (callSiteRef = (call = (SSAAbstractInvokeInstruction)instr).getCallSite()).getDeclaredTarget()).getName().toString().equals("addObject") && targetRef.getDeclaringClass().getName().toString().equals(MODEL_AND_VIEW_NAME)) {
                if (targetRef.getNumberOfParameters() != 2) continue;
                if (targetRef.getParameterType(0).getName().toString().equals("Ljava/lang/String") && targetRef.getParameterType(1).getName().toString().equals("Ljava/lang/Object")) {
                    int modelNameParam1 = call.getUse(1);
                    StringConstantFlow flow = StringConstantFlow.makeIntraproc((IR)ir, (DefUse)du);
                    Collection modelNames1 = flow.findIntraprocStringsFlowingToVar(modelNameParam1);
                    if (modelNames1.size() == 1) {
                        TypeReference storedObjType;
                        String modelName = (String)modelNames1.iterator().next();
                        String globalId = "request." + modelName;
                        ObjectRefExpr lval = ObjectRefExpr.make((NonVoidSyntheticExpr)GlobalRefExpr.make((String)globalId), (String)"");
                        ArgToOrigCallExpr rval = ArgToOrigCallExpr.make((int)2);
                        AssignmentExpr statement = AssignmentExpr.make((FilePositionInfo)filePosInfo, (AssignableSyntheticExpr)lval, (NonVoidSyntheticExpr)rval);
                        IClassHierarchy cha = controllerMethod.getClassHierarchy();
                        IMethod invokedMethod = cha.resolveMethod(targetRef);
                        assert (invokedMethod != null);
                        MapUtil.findOrCreateSet((Map)callReplacements, (Object)WalaUtil.method2ResolvedVDBSignature(controllerMethod)).add(CallSiteReplacement.make((String)WalaUtil.method2ResolvedVDBSignature(invokedMethod), (int)callSiteRef.getProgramCounter(), (int)WalaUtil.getSourceLine(controllerMethod, callSiteRef), (SyntheticExpr)statement));
                        if (ti == null) {
                            ti = TypeInference.make((IR)ir, (boolean)true);
                        }
                        String typeName = (storedObjType = ti.getType(call.getUse(2)).getTypeReference()) != null ? VDBJavaUtil.jvmToVDBType(storedObjType.getName().toString()) : "java.lang.Object";
                        globalBeans.add(BeanDecl.makeWithConcreteType((String)globalId, (String)typeName, (BeanDecl.BeanLifespan)BeanDecl.BeanLifespan.ENTRYPOINT));
                    }
                }
            }
            if (!(instr instanceof SSAReturnInstruction)) continue;
            int returnedVal = instr.getUse(0);
            for (SSAInstruction use : Iterator2Iterable.make((Iterator)du.getUses(returnedVal))) {
                TypeReference storedObjType;
                TypeReference parameterType;
                MethodReference targetRef2;
                SSAAbstractInvokeInstruction invoke;
                CallSiteReference callSite;
                if (!(use instanceof SSAAbstractInvokeInstruction) || !handledSites.add(callSite = (invoke = (SSAAbstractInvokeInstruction)use).getCallSite()) || !(targetRef2 = invoke.getDeclaredTarget()).getName().toString().equals("<init>") || !targetRef2.getDeclaringClass().getName().toString().equals(MODEL_AND_VIEW_NAME) || targetRef2.getNumberOfParameters() <= 1 || !(parameterType = targetRef2.getParameterType(1)).getName().toString().equals("Ljava/lang/String")) continue;
                int modelNameParam = invoke.getUse(2);
                StringConstantFlow flow = StringConstantFlow.makeIntraproc((IR)ir, (DefUse)du);
                Collection modelNames = flow.findIntraprocStringsFlowingToVar(modelNameParam);
                if (modelNames.size() != 1) continue;
                String modelName = (String)modelNames.iterator().next();
                String globalId = "request." + modelName;
                ObjectRefExpr lval = ObjectRefExpr.make((NonVoidSyntheticExpr)GlobalRefExpr.make((String)globalId), (String)"");
                ArgToOrigCallExpr rval = ArgToOrigCallExpr.make((int)3);
                AssignmentExpr statement = AssignmentExpr.make((FilePositionInfo)filePosInfo, (AssignableSyntheticExpr)lval, (NonVoidSyntheticExpr)rval);
                IClassHierarchy cha = controllerMethod.getClassHierarchy();
                IMethod invokedMethod = cha.resolveMethod(callSite.getDeclaredTarget());
                assert (invokedMethod != null);
                MapUtil.findOrCreateSet((Map)callReplacements, (Object)WalaUtil.method2ResolvedVDBSignature(controllerMethod)).add(CallSiteReplacement.make((String)WalaUtil.method2ResolvedVDBSignature(invokedMethod), (int)callSite.getProgramCounter(), (int)WalaUtil.getSourceLine(controllerMethod, callSite), (SyntheticExpr)statement));
                if (ti == null) {
                    ti = TypeInference.make((IR)ir, (boolean)true);
                }
                String typeName = (storedObjType = ti.getType(invoke.getUse(3)).getTypeReference()) != null ? VDBJavaUtil.jvmToVDBType(storedObjType.getName().toString()) : "java.lang.Object";
                globalBeans.add(BeanDecl.makeWithConcreteType((String)globalId, (String)typeName, (BeanDecl.BeanLifespan)BeanDecl.BeanLifespan.ENTRYPOINT));
            }
        }
        return Pair.make((Object)callReplacements, (Object)globalBeans);
    }
}

