/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.spring;

import com.ibm.appscan.frameworks.analyzers.spring.SpringAppConfigInfo;
import com.ibm.appscan.frameworks.analyzers.spring.SpringCallReplacements;
import com.ibm.appscan.frameworks.analyzers.spring.SpringConfigFileInfo;
import com.ibm.appscan.frameworks.analyzers.spring.SpringEntrypointHandler;
import com.ibm.appscan.frameworks.analyzers.spring.SpringURLHandler;
import com.ibm.appscan.frameworks.analyzers.spring.SpringURLInfo;
import com.ibm.appscan.frameworks.java.IJavaEEFrameworkHandler;
import com.ibm.appscan.frameworks.parsers.deploymentDescriptorParser.IJavaEEDeploymentDescriptorInfo;
import com.ibm.appscan.frameworks.specinfo.FrameworkInfoImpl;
import com.ibm.appscan.frameworks.specinfo.IFrameworkInfo;
import com.ibm.appscan.frameworks.util.JavaFrameworkInfoUtil;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.collections.Pair;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.NameFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class SpringFrameworkHandler
implements IJavaEEFrameworkHandler {
    public static final String SPRING_DISPATCH_SERVLET_CLASS = "org.springframework.web.servlet.DispatcherServlet";
    private static final Logger logger = TaintLogger.i().getLogger();

    @Override
    public IFrameworkInfo getFrameworkInfo(IJavaEEDeploymentDescriptorInfo ddInfo, String webContentDir, IClassHierarchy cha, Properties options) {
        logger.info((Object)Messages.getString("framework.handler.running", "SPRING", "SpringFrameworkHandler::getFrameworkInfo()"));
        IFrameworkInfo result = null;
        if (this.isSpringApp(ddInfo)) {
            List<SpringConfigFileInfo> contextConfigFileInfo = this.getContextConfigFileInfo(ddInfo, webContentDir);
            ArrayList<IFrameworkInfo> allInfo = new ArrayList<IFrameworkInfo>();
            for (String servletName : ddInfo.getServletNamesForServletClass(SPRING_DISPATCH_SERVLET_CLASS)) {
                SpringConfigFileInfo configInfo;
                block6: {
                    logger.info((Object)Messages.getString("framework.examine", "servlet: " + servletName));
                    configInfo = null;
                    try {
                        configInfo = this.parseConfigForServlet(servletName, webContentDir);
                        if (configInfo == null) {
                        }
                        break block6;
                    }
                    catch (Exception e) {
                        logger.warn((Object)Messages.getString("framework.handler.exception", e.toString() + Messages.getTraceFromException(e)));
                    }
                    continue;
                }
                ArrayList<SpringConfigFileInfo> allConfigInfo = new ArrayList<SpringConfigFileInfo>(contextConfigFileInfo.size() + 1);
                allConfigInfo.addAll(contextConfigFileInfo);
                allConfigInfo.add(configInfo);
                IFrameworkInfo infoForConfig = this.getFrameworkInfoForSpringConfig(new SpringAppConfigInfo(allConfigInfo), cha, options, webContentDir);
                if (infoForConfig == null) continue;
                allInfo.add(infoForConfig);
            }
            result = JavaFrameworkInfoUtil.mergeJavaFrameworkInfo(allInfo, cha);
        } else {
            result = FrameworkInfoImpl.makeEmpty();
        }
        logger.info((Object)Messages.getString("framework.handler.exit", "SPRING"));
        return result;
    }

    public List<SpringConfigFileInfo> getContextConfigFileInfo(IJavaEEDeploymentDescriptorInfo ddInfo, String webContentDir) {
        String contextClass = ddInfo.getContextParamValue("contextClass");
        if (contextClass != null && !contextClass.equals("XmlWebApplicationContext")) {
            TaintLogger.i().getLogger().info((Object)("unhandled Spring context class " + contextClass));
            return Collections.emptyList();
        }
        String contextConfigLocation = ddInfo.getContextParamValue("contextConfigLocation");
        if (contextConfigLocation == null) {
            contextConfigLocation = "/WEB-INF/applicationContext.xml";
        }
        String[] configFilePaths = contextConfigLocation.split("(,| )+");
        ArrayList<SpringConfigFileInfo> result = new ArrayList<SpringConfigFileInfo>(configFilePaths.length);
        for (String path : configFilePaths) {
            String fullPath = path.startsWith("classpath:") ? this.resolveFilePathWithClasspath(path, webContentDir) : webContentDir + path;
            try {
                File theFile = new File(fullPath);
                if (!theFile.exists()) continue;
                SpringConfigFileInfo fileInfo = SpringConfigFileInfo.make(fullPath);
                result.add(fileInfo);
            }
            catch (IOException e) {
                logger.warn((Object)Messages.getString("framework.failure.parsing", fullPath));
                logger.warn((Object)Messages.getString("framework.handler.exception", e.toString() + Messages.getTraceFromException(e)));
            }
            catch (SAXException e) {
                logger.warn((Object)Messages.getString("framework.failure.parsing", fullPath));
                logger.warn((Object)Messages.getString("framework.handler.exception", e.toString() + Messages.getTraceFromException(e)));
            }
        }
        return result;
    }

    private String resolveFilePathWithClasspath(String filePath, String webContentDir) {
        if (!filePath.startsWith("classpath:")) {
            return filePath;
        }
        String resultFilePath = filePath;
        if (webContentDir.endsWith("_staging")) {
            File webContentFolder = new File(webContentDir);
            File appRoot = webContentFolder.getParentFile();
            int index = filePath.lastIndexOf("\\");
            if (index < 0) {
                index = filePath.lastIndexOf("/");
            }
            index = index < 0 ? 0 : ++index;
            String fileNameWithoutPath = filePath.substring(index);
            Iterator iter = FileUtils.iterateFiles((File)appRoot, (IOFileFilter)new NameFileFilter(fileNameWithoutPath), (IOFileFilter)TrueFileFilter.INSTANCE);
            if (!iter.hasNext()) {
                logger.info((Object)Messages.getString("framework.missing.file", filePath));
                return resultFilePath;
            }
            while (iter.hasNext()) {
                try {
                    resultFilePath = ((File)iter.next()).getCanonicalPath();
                    if (!resultFilePath.endsWith(filePath.substring("classpath:".length()))) continue;
                    break;
                }
                catch (IOException e) {
                    logger.info((Object)Messages.getString("framework.missing.file", filePath));
                    logger.warn((Object)Messages.getString("framework.handler.exception", e.toString() + Messages.getTraceFromException(e)));
                }
            }
        }
        return resultFilePath;
    }

    private IFrameworkInfo getFrameworkInfoForSpringConfig(SpringAppConfigInfo configInfo, IClassHierarchy cha, Properties options, String webContentDir) {
        SpringURLInfo urlInfo = SpringURLHandler.getURLInfo(configInfo);
        Pair<IFrameworkInfo, Map<IMethod, SpringConfigFileInfo.SpringBeanInfo>> entrypointInfo = SpringEntrypointHandler.getEntrypointInfo(configInfo, cha, urlInfo, options, webContentDir);
        Map entrypoints = (Map)entrypointInfo.snd;
        IFrameworkInfo callReplacements = SpringCallReplacements.getCallReplacements(entrypoints);
        return JavaFrameworkInfoUtil.mergeJavaFrameworkInfo(Arrays.asList((IFrameworkInfo)entrypointInfo.fst, callReplacements), cha);
    }

    private SpringConfigFileInfo parseConfigForServlet(String servletName, String webContentDir) throws IOException, SAXException {
        String contextConfigFileName = webContentDir + File.separatorChar + "WEB-INF" + File.separatorChar + servletName + "-servlet.xml";
        logger.info((Object)Messages.getString("framework.examine", contextConfigFileName));
        File contextConfigFile = new File(contextConfigFileName);
        if (contextConfigFile.exists()) {
            return SpringConfigFileInfo.make(contextConfigFileName);
        }
        logger.info((Object)Messages.getString("framework.missing.file", contextConfigFileName));
        return null;
    }

    private boolean isSpringApp(IJavaEEDeploymentDescriptorInfo ddInfo) {
        boolean result;
        boolean bl = result = ddInfo.getServletNamesForServletClass(SPRING_DISPATCH_SERVLET_CLASS).size() > 0;
        if (result) {
            logger.info((Object)Messages.getString("framework.class.found", SPRING_DISPATCH_SERVLET_CLASS));
            logger.info((Object)Messages.getString("framework.returns", "isSpringApp()", "true"));
        } else {
            logger.info((Object)Messages.getString("framework.missing", SPRING_DISPATCH_SERVLET_CLASS));
            logger.info((Object)Messages.getString("framework.returns", "isSpringApp()", "false"));
        }
        return result;
    }

    @Override
    public Collection<String> getServletsToIgnore(IClassHierarchy cha, IJavaEEDeploymentDescriptorInfo ddInfo) {
        return Arrays.asList(SPRING_DISPATCH_SERVLET_CLASS);
    }
}

