/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.spring;

import com.ibm.appscan.frameworks.analyzers.spring.SpringAppConfigInfo;
import com.ibm.appscan.frameworks.analyzers.spring.SpringConfigFileInfo;
import com.ibm.appscan.frameworks.analyzers.spring.SpringURLInfo;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class SpringURLHandler {
    private static final String BEAN_NAME_URL_HANDLER_MAPPING = "org.springframework.web.servlet.handler.BeanNameUrlHandlerMapping";
    private static final String SIMPLE_URL_HANDLER_MAPPING = "org.springframework.web.servlet.handler.SimpleUrlHandlerMapping";
    private static final Set<String> KNOWN_HANDLER_MAPPINGS = HashSetFactory.make();

    public static SpringURLInfo getURLInfo(SpringAppConfigInfo configInfo) {
        HashSet handlerMappingBeans = HashSetFactory.make();
        for (SpringConfigFileInfo.SpringBeanInfo beanInfo : configInfo) {
            String classAttr = beanInfo.getClassAttr();
            if (!KNOWN_HANDLER_MAPPINGS.contains(classAttr)) continue;
            handlerMappingBeans.add(beanInfo);
        }
        HashMap beanId2URLs = HashMapFactory.make();
        HashMap beanId2Method2URLs = HashMapFactory.make();
        if (handlerMappingBeans.isEmpty()) {
            SpringURLHandler.genURLsForBeanNameHandler(configInfo, beanId2URLs);
        } else {
            for (SpringConfigFileInfo.SpringBeanInfo beanInfo : handlerMappingBeans) {
                String handlerMappingClass = beanInfo.getClassAttr();
                if (handlerMappingClass.equals(BEAN_NAME_URL_HANDLER_MAPPING)) {
                    SpringURLHandler.genURLsForBeanNameHandler(configInfo, beanId2URLs);
                    continue;
                }
                if (!handlerMappingClass.equals(SIMPLE_URL_HANDLER_MAPPING)) continue;
                SpringURLHandler.genURLsForSimpleURLHandlerMapping(beanInfo, beanId2URLs);
            }
        }
        return SpringURLInfo.make(beanId2URLs, beanId2Method2URLs);
    }

    private static void genURLsForSimpleURLHandlerMapping(SpringConfigFileInfo.SpringBeanInfo beanInfo, Map<String, Set<String>> result) {
        Object urlMapProp;
        Map<String, Object> properties = beanInfo.getProperties();
        Object mappings = properties.get("mappings");
        if (mappings != null) {
            Properties mappingsProps = new Properties();
            if (mappings instanceof String) {
                try {
                    mappingsProps.load(new StringReader(((String)mappings).replaceAll(" ", "\n")));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else if (mappings instanceof Properties) {
                mappingsProps = (Properties)mappings;
            }
            for (Object urlObj : mappingsProps.keySet()) {
                String url = (String)urlObj;
                String beanId = mappingsProps.getProperty(url);
                MapUtil.findOrCreateSet(result, (Object)beanId).add(url);
            }
        }
        if ((urlMapProp = properties.get("urlMap")) != null) {
            Map urlMap = (Map)urlMapProp;
            for (Object key : urlMap.keySet()) {
                Object value = urlMap.get(key);
                if (!(key instanceof String) || !(value instanceof SpringConfigFileInfo.BeanRef)) continue;
                MapUtil.findOrCreateSet(result, (Object)((SpringConfigFileInfo.BeanRef)value).getBeanName()).add((String)key);
            }
        }
    }

    private static void genURLsForBeanNameHandler(SpringAppConfigInfo configInfo, Map<String, Set<String>> result) {
        Set<SpringConfigFileInfo.SpringBeanInfo> allBeanInfo = configInfo.getAllBeanInfo();
        for (SpringConfigFileInfo.SpringBeanInfo beanInfo : allBeanInfo) {
            Collection<String> names = beanInfo.getNames();
            if (names.size() != 1) continue;
            String name = names.iterator().next();
            result.put(name, Collections.singleton(name));
        }
    }

    static {
        KNOWN_HANDLER_MAPPINGS.add(BEAN_NAME_URL_HANDLER_MAPPING);
        KNOWN_HANDLER_MAPPINGS.add(SIMPLE_URL_HANDLER_MAPPING);
    }
}

