/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.spring;

import com.ibm.appscan.frameworks.analyzers.spring.ISpringViewResolver;
import com.ibm.appscan.frameworks.analyzers.spring.SpringAppConfigInfo;
import com.ibm.appscan.frameworks.analyzers.spring.SpringConfigFileInfo;
import com.ibm.appscan.frameworks.analyzers.tiles.TilesAnalyzer;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import java.util.Collection;
import java.util.Collections;

public class TilesViewResolver
implements ISpringViewResolver {
    private static final String CONFIGURER_CLASS = "org.springframework.web.servlet.view.tiles.TilesConfigurer";
    private final String urlPrefix;
    private final String urlSuffix;
    private final TilesAnalyzer tilesAnalyzer;

    public static TilesViewResolver make(SpringAppConfigInfo configInfo, String webContentDir, String prefix, String suffix) {
        return new TilesViewResolver(configInfo, webContentDir, prefix, suffix);
    }

    public TilesViewResolver(SpringAppConfigInfo configInfo, String webContentDir, String prefix, String suffix) {
        this.urlPrefix = prefix;
        this.urlSuffix = suffix;
        this.tilesAnalyzer = this.buildTilesAnalyzer(configInfo, webContentDir);
    }

    private TilesAnalyzer buildTilesAnalyzer(SpringAppConfigInfo configInfo, String webContentDir) {
        for (SpringConfigFileInfo.SpringBeanInfo beanInfo : configInfo.getAllBeanInfo()) {
            String classAttr = beanInfo.getClassAttr();
            if (classAttr == null || !classAttr.equals(CONFIGURER_CLASS)) continue;
            String configFiles = (String)beanInfo.getProperties().get("definitions");
            return configInfo.getTilesAnalyzer(webContentDir, configFiles);
        }
        TaintLogger.i().getLogger().info((Object)"could not find Tiles configuration bean");
        return null;
    }

    @Override
    public Collection<String> resolveView(String viewName) {
        if (this.tilesAnalyzer == null) {
            return Collections.emptySet();
        }
        String tileName = this.urlPrefix + viewName + this.urlSuffix;
        Collection<String> result = this.tilesAnalyzer.getAllRelevantPaths(tileName);
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }
}

