/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.struts1;

import com.ibm.appscan.frameworks.analyzers.javaee.jsp.IJSPPrecompilerInfo;
import com.ibm.appscan.frameworks.analyzers.struts1.AnalyzedBean;
import com.ibm.appscan.frameworks.analyzers.struts1.AnalyzedExceptionHandler;
import com.ibm.appscan.frameworks.analyzers.struts1.AnalyzedStrutsAction;
import com.ibm.appscan.frameworks.analyzers.struts1.DeploymentDescriptorAnalyzer;
import com.ibm.appscan.frameworks.analyzers.struts1.StrutsCodeAnalyzer;
import com.ibm.appscan.frameworks.analyzers.struts1.StrutsConfiguration;
import com.ibm.appscan.frameworks.analyzers.struts1.StrutsForwardAnalyzer;
import com.ibm.appscan.frameworks.analyzers.struts1.StrutsPluginInfo;
import com.ibm.appscan.frameworks.analyzers.struts1.StrutsRequestProcessorInfo;
import com.ibm.appscan.frameworks.analyzers.tiles.TilesAnalyzer;
import com.ibm.appscan.frameworks.parsers.strutsParser.DOMBasedStrutsInfo;
import com.ibm.appscan.frameworks.parsers.strutsParser.IAction;
import com.ibm.appscan.frameworks.parsers.strutsParser.IFormBean;
import com.ibm.appscan.frameworks.parsers.strutsParser.IForward;
import com.ibm.appscan.frameworks.parsers.strutsParser.IStrutsInfo;
import com.ibm.appscan.frameworks.parsers.strutsParser.ParsedExceptionHandler;
import com.ibm.appscan.frameworks.parsers.strutsValidatorParser.DOMBasedStrutsValidatorInfo;
import com.ibm.appscan.frameworks.parsers.strutsValidatorParser.IFormSet;
import com.ibm.appscan.frameworks.parsers.strutsValidatorParser.IStrutsValidatorInfo;
import com.ibm.appscan.frameworks.parsers.strutsValidatorParser.IValidationForm;
import com.ibm.appscan.frameworks.parsers.strutsValidatorParser.IValidator;
import com.ibm.appscan.frameworks.specinfo.BeanDecl;
import com.ibm.appscan.frameworks.specinfo.CallSiteReplacement;
import com.ibm.appscan.frameworks.specinfo.FrameworkInfoImpl;
import com.ibm.appscan.frameworks.specinfo.IFrameworkInfo;
import com.ibm.appscan.frameworks.specinfo.ISyntheticMethod;
import com.ibm.appscan.frameworks.util.Files;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.appscan.frameworks.util.WalaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.ipa.callgraph.AnalysisCache;
import com.ibm.wala.ipa.callgraph.AnalysisScope;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.MapUtil;
import com.ibm.wala.util.collections.Pair;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class StrutsAnalyzer {
    private static final Logger logger = TaintLogger.i().getLogger();
    public static final boolean verbose = false;
    private final Map<String, AnalyzedBean> beans = HashMapFactory.make();
    private final Map<String, AnalyzedStrutsAction> analyzedActions = HashMapFactory.make();
    private final Collection<AnalyzedExceptionHandler> analyzedExceptionHandlers;
    private final List<IStrutsInfo> parsers;
    private final String strutsURLPattern;
    private final StrutsCodeAnalyzer codeAnalyzer;
    private final IClassHierarchy cha;

    public StrutsAnalyzer(List<IStrutsInfo> parsers, String strutsURLPattern, IClassHierarchy cha, AnalysisCache cache, IJSPPrecompilerInfo jspInfo, String webContentDir) {
        this.parsers = parsers;
        this.strutsURLPattern = strutsURLPattern;
        this.cha = cha;
        this.extractBeans();
        HashMap actions = HashMapFactory.make();
        HashSet actionClassNames = HashSetFactory.make();
        HashSet actionClassesWithDynaBeans = HashSetFactory.make();
        this.extractActionClassesWithoutWildCards(actions, actionClassNames, actionClassesWithDynaBeans);
        this.extractWildCardActions(WalaUtil.getApplicationClassesNames(cha), actions, actionClassNames, actionClassesWithDynaBeans);
        Pair<Map<String, String>, Map<String, AnalyzedBean>> p = this.getBeanNamesForActionsWithDynaBeans(actionClassesWithDynaBeans);
        Map<String, ParsedExceptionHandler> exceptionHandlerInfo = this.extractExceptionHandlerClassNames();
        this.codeAnalyzer = new StrutsCodeAnalyzer(cha, cache, actionClassNames, actionClassesWithDynaBeans, exceptionHandlerInfo.keySet(), (Map)p.fst, (Map)p.snd);
        Map<String, IForward> globalForwards = this.extractForwards();
        this.analyzeActions(jspInfo, webContentDir, globalForwards, actions);
        this.analyzedExceptionHandlers = this.analyzeExceptionHandlers(exceptionHandlerInfo, globalForwards, jspInfo, webContentDir);
        this.analyzeValidators(this.getValidatorParser(webContentDir, cha.getScope()));
    }

    private Collection<AnalyzedExceptionHandler> analyzeExceptionHandlers(Map<String, ParsedExceptionHandler> excHandlerInfo, Map<String, IForward> globalForwards, IJSPPrecompilerInfo jspInfo, String webContentDir) {
        HashSet result = HashSetFactory.make();
        for (String excHandler : excHandlerInfo.keySet()) {
            Collection<StrutsForwardAnalyzer.ForwardInfo> allPossibleForwards = this.codeAnalyzer.getPossibleForwards(excHandler);
            ArrayList<String> urls = new ArrayList<String>(1);
            for (StrutsForwardAnalyzer.ForwardInfo possibleForwards : allPossibleForwards) {
                for (String forwardName : possibleForwards.getForwardNames()) {
                    IForward forward = null;
                    if (!globalForwards.containsKey(forwardName)) {
                        logger.warn((Object)("Can't find forward in configuration file " + forwardName));
                        continue;
                    }
                    forward = globalForwards.get(forwardName);
                    String redirect = forward.getRedirect();
                    if (redirect != null && Boolean.parseBoolean(redirect)) continue;
                    urls.add(forward.getPath());
                }
                for (String url : possibleForwards.getUrls()) {
                    urls.add(url);
                }
            }
            result.add(new AnalyzedExceptionHandler(excHandler, urls, excHandlerInfo.get(excHandler), jspInfo, webContentDir));
        }
        return result;
    }

    private Map<String, ParsedExceptionHandler> extractExceptionHandlerClassNames() {
        HashMap result = HashMapFactory.make();
        for (IStrutsInfo parser : this.parsers) {
            for (ParsedExceptionHandler handler : parser.getExceptionHandlers()) {
                result.put(handler.getHandlerClass(), handler);
            }
        }
        return result;
    }

    private IStrutsValidatorInfo getValidatorParser(String webContentDir, AnalysisScope analysisScope) {
        HashMap validationConfigurations = HashMapFactory.make();
        for (IStrutsInfo parser : this.parsers) {
            for (String location : parser.getValidationConfigurationPath()) {
                String resolvedLocation = webContentDir + location;
                InputStream resource = null;
                try {
                    if (Files.exist(resolvedLocation)) {
                        resource = new FileInputStream(resolvedLocation);
                    } else {
                        if (analysisScope == null) {
                            logger.warn((Object)("could not find configuration file " + resolvedLocation));
                            continue;
                        }
                        resolvedLocation = location;
                        resource = WalaUtil.getResource(analysisScope, resolvedLocation);
                        if (resource == null) {
                            logger.warn((Object)("could not find configuration file " + resolvedLocation));
                            continue;
                        }
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException("Should not happen");
                }
                validationConfigurations.put(resolvedLocation, resource);
            }
        }
        if (validationConfigurations.isEmpty()) {
            return null;
        }
        try {
            return DOMBasedStrutsValidatorInfo.getStrutsValidatorParser(validationConfigurations);
        }
        catch (IOException e) {
            logger.warn((Object)("IOException trying to read Struts config file " + validationConfigurations), (Throwable)e);
        }
        catch (SAXException e) {
            logger.warn((Object)("SAXException trying to parse Struts config file " + validationConfigurations), (Throwable)e);
        }
        return null;
    }

    private void analyzeValidators(IStrutsValidatorInfo validationParser) {
        if (validationParser == null) {
            return;
        }
        validationParser.removeUnresolvedValidators(this.cha);
        Map<String, IValidator> validators = this.extractValidators(validationParser);
        for (IFormSet formSet : validationParser.getFormSets()) {
            for (IValidationForm form : formSet.getForms()) {
                AnalyzedBean bean = this.beans.get(form.getName());
                if (bean != null) {
                    bean.validateProperties(form.getField(), validators);
                    continue;
                }
                TaintLogger.i().getLogger().info((Object)("no bean for validator form name " + form.getName() + ", might be an action path"));
            }
        }
    }

    private void analyzeActions(IJSPPrecompilerInfo jspInfo, String webContentDir, Map<String, IForward> globalForwards, Map<IAction, IStrutsInfo> actions) {
        HashMap tilesCache = HashMapFactory.make();
        for (IAction action : actions.keySet()) {
            if (action.getPath() == null) {
                logger.warn((Object)"Skipping action with no path");
                continue;
            }
            AnalyzedStrutsAction analyzedAction = new AnalyzedStrutsAction(action, this.beans, globalForwards, this.codeAnalyzer, jspInfo, webContentDir);
            analyzedAction.updateForwardWithTiles(this.getTilesConfigurations(webContentDir, actions.get(action).getTilesConfigurationPath(), tilesCache));
            if (!analyzedAction.isValid()) continue;
            if (this.analyzedActions.keySet().contains(action.getPath())) {
                logger.info((Object)("Ignoring an action with a duplicate path: " + action.getPath()));
                continue;
            }
            this.analyzedActions.put(action.getPath(), analyzedAction);
        }
    }

    private Map<String, IValidator> extractValidators(IStrutsValidatorInfo validationParser) {
        HashMap validators = HashMapFactory.make();
        if (validationParser != null) {
            for (IValidator validator : validationParser.getValidators()) {
                validators.put(validator.getName(), validator);
            }
        }
        return validators;
    }

    private Pair<Map<String, String>, Map<String, AnalyzedBean>> getBeanNamesForActionsWithDynaBeans(Set<String> actionClassesWithDynaBeans) {
        HashMap result1 = HashMapFactory.make();
        HashMap result2 = HashMapFactory.make();
        for (IStrutsInfo parser : this.parsers) {
            for (IAction action : parser.getActions()) {
                String actionClass = action.getType();
                if (!actionClassesWithDynaBeans.contains(actionClass)) continue;
                String scope = action.getScope();
                result1.put(actionClass, AnalyzedStrutsAction.getGlobalBeanNameForAction(scope == null ? "session" : scope, action.getName()));
                result2.put(actionClass, this.getAnalyzedBeans().get(action.getName()));
            }
        }
        return Pair.make((Object)result1, (Object)result2);
    }

    private TilesAnalyzer getTilesConfigurations(String webDir, String tilesConfigurationsPath, Map<String, TilesAnalyzer> tilesCache) {
        if (tilesConfigurationsPath == null) {
            return null;
        }
        if (tilesCache.containsKey(tilesConfigurationsPath)) {
            return tilesCache.get(tilesConfigurationsPath);
        }
        TilesAnalyzer strutsTilesAnalyzer = TilesAnalyzer.createTilesAnalyzerFromConfigs(webDir, tilesConfigurationsPath);
        tilesCache.put(tilesConfigurationsPath, strutsTilesAnalyzer);
        return strutsTilesAnalyzer;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.analyzedActions == null ? 0 : this.analyzedActions.hashCode());
        result = 31 * result + (this.beans == null ? 0 : this.beans.hashCode());
        result = 31 * result + (this.strutsURLPattern == null ? 0 : this.strutsURLPattern.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StrutsAnalyzer other = (StrutsAnalyzer)obj;
        if (this.analyzedActions == null ? other.analyzedActions != null : !this.analyzedActions.equals(other.analyzedActions)) {
            return false;
        }
        if (this.beans == null ? other.beans != null : !this.beans.equals(other.beans)) {
            return false;
        }
        return !(this.strutsURLPattern == null ? other.strutsURLPattern != null : !this.strutsURLPattern.equals(other.strutsURLPattern));
    }

    private void extractWildCardActions(Set<String> applicationClasses, Map<IAction, IStrutsInfo> actions, Set<String> actionClassNames, Set<String> actionClassesWithDynaBeans) {
        for (IStrutsInfo parser : this.parsers) {
            for (IAction action : parser.getActions()) {
                if (!action.hasWildCard()) continue;
                for (IAction newAction : this.resolveWildCard(action, applicationClasses, actionClassNames)) {
                    this.addAction(newAction, parser, actions, actionClassNames, actionClassesWithDynaBeans);
                }
            }
        }
    }

    private Collection<IAction> resolveWildCard(IAction action, Set<String> applicationClasses, Set<String> actionClassNames) {
        String type;
        HashSet result = HashSetFactory.make();
        if (action != null && (type = action.getType()) != null) {
            for (String match : this.matchWildCard(type, applicationClasses)) {
                IAction newAction = action.replaceWildCard(match);
                if (actionClassNames.contains(newAction.getType())) continue;
                result.add(newAction);
            }
        }
        return result;
    }

    private Collection<String> matchWildCard(String type, Set<String> applicationClasses) {
        TreeSet<String> result = new TreeSet<String>();
        int iWildCard = type.indexOf("{1}");
        if (iWildCard >= 0) {
            String beforeWildCard = type.substring(0, iWildCard);
            String afterWildCard = type.substring(iWildCard + 3);
            for (String appClass : applicationClasses) {
                if (!appClass.startsWith(beforeWildCard) || !appClass.endsWith(afterWildCard)) continue;
                result.add(appClass.substring(appClass.indexOf(beforeWildCard) + beforeWildCard.length(), appClass.indexOf(afterWildCard)));
            }
        }
        return result;
    }

    private void extractActionClassesWithoutWildCards(Map<IAction, IStrutsInfo> actions, Set<String> actionClassNames, Set<String> actionClassesWithDynaBeans) {
        for (IStrutsInfo parser : this.parsers) {
            for (IAction action : parser.getActions()) {
                this.addAction(action, parser, actions, actionClassNames, actionClassesWithDynaBeans);
            }
        }
    }

    private void addAction(IAction action, IStrutsInfo parser, Map<IAction, IStrutsInfo> actions, Set<String> actionClassNames, Set<String> actionClassesWithDynaBeans) {
        AnalyzedBean bean;
        if (action.hasWildCard()) {
            return;
        }
        String type = action.getType();
        String name = action.getName();
        if (type != null) {
            actionClassNames.add(type);
        }
        if (name != null && (bean = this.beans.get(name)) != null && bean.isDynaBean() && type != null) {
            actionClassesWithDynaBeans.add(type);
        }
        actions.put(action, parser);
    }

    private Map<String, IForward> extractForwards() {
        HashMap globalForwards = HashMapFactory.make();
        for (IStrutsInfo parser : this.parsers) {
            for (IForward forward : parser.getGlobalForwards()) {
                globalForwards.put(forward.getName(), forward);
            }
        }
        return globalForwards;
    }

    private void extractBeans() {
        for (IStrutsInfo parser : this.parsers) {
            for (IFormBean bean : parser.getFormBeans()) {
                AnalyzedBean analyzedBean = new AnalyzedBean(bean, this.cha);
                this.beans.put(bean.getName(), analyzedBean);
            }
        }
    }

    public Map<String, AnalyzedStrutsAction> getAnalyzedActions() {
        return this.analyzedActions;
    }

    public static StrutsAnalyzer createStrutsAnalyzer(IClassHierarchy cha, DeploymentDescriptorAnalyzer deploymentDescriptorAnalyzer, String webContentDir, IJSPPrecompilerInfo jspInfo) {
        Set<StrutsConfiguration> relativeStrutsConfigs = deploymentDescriptorAnalyzer.getStrutsConfigPaths();
        ArrayList<IStrutsInfo> strutsParsers = new ArrayList<IStrutsInfo>();
        for (StrutsConfiguration relativeStrutsConfigPaths : relativeStrutsConfigs) {
            for (String relativeStrutsConfigPath : relativeStrutsConfigPaths.getPaths()) {
                String strutsConfigPath = webContentDir + relativeStrutsConfigPath;
                try {
                    logger.info((Object)Messages.getString("framework.examine", strutsConfigPath));
                    strutsParsers.add(DOMBasedStrutsInfo.getStrutsParser(strutsConfigPath));
                }
                catch (IOException e) {
                    logger.warn((Object)Messages.getString("framework.failure.parsing", strutsConfigPath));
                    logger.warn((Object)Messages.getString("framework.handler.exception", e.toString() + Messages.getTraceFromException(e)));
                }
                catch (SAXException e) {
                    logger.warn((Object)Messages.getString("framework.failure.parsing", strutsConfigPath));
                    logger.warn((Object)Messages.getString("framework.handler.exception", e.toString() + Messages.getTraceFromException(e)));
                }
            }
        }
        return new StrutsAnalyzer(strutsParsers, deploymentDescriptorAnalyzer.getStrutsURLPattern(), cha, new AnalysisCache(), jspInfo, webContentDir);
    }

    public IFrameworkInfo getFrameworkInfo() {
        HashSet syntheticMethods = HashSetFactory.make();
        HashMap entrypointSignatureToURL = HashMapFactory.make();
        HashSet globalBeanDecls = HashSetFactory.make();
        this.handleAnalyzedActions(syntheticMethods, entrypointSignatureToURL, globalBeanDecls);
        this.handleExceptionHandlers(syntheticMethods, entrypointSignatureToURL);
        this.addRequestProcessorEntrypoints(entrypointSignatureToURL);
        this.addPluginEntrypoints(entrypointSignatureToURL);
        HashMap allReplacements = HashMapFactory.make();
        Map<String, Set<CallSiteReplacement>> replacementsForDynaBeanAccesses = this.codeAnalyzer.getReplacementsForDynaBeanAccesses();
        for (String vdbMethodSig : replacementsForDynaBeanAccesses.keySet()) {
            MapUtil.findOrCreateSet((Map)allReplacements, (Object)vdbMethodSig).addAll((Collection)replacementsForDynaBeanAccesses.get(vdbMethodSig));
        }
        FrameworkInfoImpl info = new FrameworkInfoImpl((Set)syntheticMethods, (Set)globalBeanDecls, (Map)entrypointSignatureToURL, (Map)allReplacements);
        return info;
    }

    private void handleExceptionHandlers(Set<ISyntheticMethod> syntheticMethods, Map<String, Set<String>> entrypointSignatureToURL) {
        for (AnalyzedExceptionHandler analyzedHandler : this.analyzedExceptionHandlers) {
            ISyntheticMethod synthMethod = analyzedHandler.createSyntheticMethod(this.cha, this.analyzedActions.values());
            syntheticMethods.add(synthMethod);
            String signature = synthMethod.getSignature();
            logger.info((Object)Messages.getString("framework.method.url", signature, ""));
            entrypointSignatureToURL.put(signature, Collections.emptySet());
        }
    }

    private void handleAnalyzedActions(Set<ISyntheticMethod> syntheticMethods, Map<String, Set<String>> entrypointSignatureToURL, Set<BeanDecl> globalBeanDecls) {
        for (String id : this.analyzedActions.keySet()) {
            Pair<ISyntheticMethod, BeanDecl> p;
            AnalyzedStrutsAction analyzedStrutsAction = this.analyzedActions.get(id);
            if (analyzedStrutsAction.getActionClass() == null || (p = analyzedStrutsAction.createSyntheticMethod(this.analyzedActions.values(), this.cha)) == null) continue;
            ISyntheticMethod sm = (ISyntheticMethod)p.fst;
            if (p.snd != null) {
                globalBeanDecls.add((BeanDecl)p.snd);
            }
            syntheticMethods.add(sm);
            String signature = sm.getSignature();
            String path = analyzedStrutsAction.getPath();
            String url = this.getURLForAction(path);
            if (url != null) {
                logger.info((Object)Messages.getString("framework.method.url", signature, url));
                entrypointSignatureToURL.put(signature, Collections.singleton(url));
                continue;
            }
            logger.info((Object)Messages.getString("framework.method.url", signature, ""));
            entrypointSignatureToURL.put(signature, Collections.emptySet());
        }
    }

    private void addPluginEntrypoints(Map<String, Set<String>> entrypointSignatureToURL) {
        Set<String> pluginEntrypoints = StrutsPluginInfo.getPluginEntrypoints(this.parsers, this.cha);
        for (String pluginSig : pluginEntrypoints) {
            logger.info((Object)Messages.getString("framework.method.url", VDBJavaUtil.jvmToVDBSignature(pluginSig), ""));
            entrypointSignatureToURL.put(VDBJavaUtil.jvmToVDBSignature(pluginSig), Collections.emptySet());
        }
    }

    private void addRequestProcessorEntrypoints(Map<String, Set<String>> entrypointSignatureToURL) {
        Set<String> requestProcessorEntrypoints = StrutsRequestProcessorInfo.getRequestProcessorEntrypoints(this.parsers, this.cha);
        for (String reqProcEntrysig : requestProcessorEntrypoints) {
            logger.info((Object)Messages.getString("framework.method.url", VDBJavaUtil.jvmToVDBSignature(reqProcEntrysig), ""));
            entrypointSignatureToURL.put(VDBJavaUtil.jvmToVDBSignature(reqProcEntrysig), Collections.emptySet());
        }
    }

    private String getURLForAction(String path) {
        if (this.strutsURLPattern == null) {
            return null;
        }
        if (this.strutsURLPattern.startsWith("*")) {
            return this.strutsURLPattern.replaceAll("\\*", path);
        }
        if (this.strutsURLPattern.endsWith("/*")) {
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            return this.strutsURLPattern.replaceAll("\\*", path);
        }
        logger.warn((Object)("unhandled Struts URL pattern " + this.strutsURLPattern));
        return null;
    }

    public Map<String, AnalyzedBean> getAnalyzedBeans() {
        return this.beans;
    }

    public Collection<AnalyzedExceptionHandler> getAnalyzedExceptionHandlers() {
        return this.analyzedExceptionHandlers;
    }
}

