/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.struts1;

import com.ibm.appscan.frameworks.analyzers.javaee.JavaEEOptions;
import com.ibm.appscan.frameworks.analyzers.struts1.DeploymentDescriptorAnalyzer;
import com.ibm.appscan.frameworks.analyzers.struts1.StrutsAnalyzer;
import com.ibm.appscan.frameworks.java.IJavaEEFrameworkHandler;
import com.ibm.appscan.frameworks.parsers.deploymentDescriptorParser.IJavaEEDeploymentDescriptorInfo;
import com.ibm.appscan.frameworks.specinfo.FrameworkInfoImpl;
import com.ibm.appscan.frameworks.specinfo.IFrameworkInfo;
import com.ibm.appscan.frameworks.util.Messages;
import com.ibm.appscan.frameworks.util.WalaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.util.collections.HashSetFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Properties;
import org.apache.log4j.Logger;

public class StrutsV1FrameworkHandler
implements IJavaEEFrameworkHandler {
    public static final String STRUTS_SERVLET_CLASS = "org.apache.struts.action.ActionServlet";
    private static final Logger logger = TaintLogger.i().getLogger();

    @Override
    public IFrameworkInfo getFrameworkInfo(IJavaEEDeploymentDescriptorInfo ddInfo, String webContentDir, IClassHierarchy cha, Properties options) {
        logger.info((Object)Messages.getString("framework.handler.running", "STRUTSV1", "StrutsV1FrameworkHandler::getFrameworkInfo()"));
        IFrameworkInfo result = null;
        if (this.isStrutsApp(ddInfo, cha)) {
            StrutsAnalyzer analyzer = StrutsAnalyzer.createStrutsAnalyzer(cha, new DeploymentDescriptorAnalyzer(ddInfo, cha), webContentDir, JavaEEOptions.getPrecompilerInfo(options));
            result = analyzer.getFrameworkInfo();
        } else {
            result = FrameworkInfoImpl.makeEmpty();
        }
        logger.info((Object)Messages.getString("framework.handler.exit", "STRUTSV1"));
        return result;
    }

    private boolean isStrutsApp(IJavaEEDeploymentDescriptorInfo ddInfo, IClassHierarchy cha) {
        return StrutsV1FrameworkHandler.getStrutsServletNames(ddInfo, cha).size() > 0;
    }

    @Override
    public Collection<String> getServletsToIgnore(IClassHierarchy cha, IJavaEEDeploymentDescriptorInfo ddInfo) {
        return Collections.singleton(STRUTS_SERVLET_CLASS);
    }

    public static Collection<String> getStrutsServletNames(IJavaEEDeploymentDescriptorInfo ddInfo, IClassHierarchy cha) {
        HashSet result = HashSetFactory.make((int)1);
        IClass actionServlet = cha.lookupClass(WalaUtil.createTypeRefForJavaClassName(STRUTS_SERVLET_CLASS));
        for (String servletClassName : ddInfo.getAllServletClassNames()) {
            logger.info((Object)Messages.getString("framework.examine", "servlet: " + servletClassName));
            if (servletClassName.equals(STRUTS_SERVLET_CLASS)) {
                logger.info((Object)Messages.getString("framework.class.found", STRUTS_SERVLET_CLASS));
                result.add(servletClassName);
                continue;
            }
            IClass servletKlass = cha.lookupClass(WalaUtil.createTypeRefForJavaClassName(servletClassName));
            if (actionServlet == null || servletKlass == null || !cha.isAssignableFrom(actionServlet, servletKlass)) continue;
            logger.info((Object)Messages.getString("framework.class.found", servletClassName));
            result.add(servletClassName);
        }
        return result;
    }
}

