/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.analyzers.tiles;

import com.ibm.appscan.frameworks.parsers.strutsTilesParser.DOMBasedStrutsTilesInfo;
import com.ibm.appscan.frameworks.parsers.strutsTilesParser.IDefinition;
import com.ibm.appscan.frameworks.parsers.strutsTilesParser.IPut;
import com.ibm.appscan.frameworks.parsers.strutsTilesParser.IStrutsTilesInfo;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.HashSetFactory;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public class TilesAnalyzer {
    Map<String, IDefinition> definitionMap = HashMapFactory.make();
    Map<String, String> tileName2Path = HashMapFactory.make();

    public TilesAnalyzer(List<IStrutsTilesInfo> tiles) {
        for (IStrutsTilesInfo tilesDef : tiles) {
            for (IDefinition def : tilesDef.getDefinitions()) {
                this.definitionMap.put(def.getName(), def);
            }
        }
        for (IStrutsTilesInfo tilesDef : tiles) {
            for (IDefinition def : tilesDef.getDefinitions()) {
                String path = this.getRecDefinitionPath(def.getName());
                if (path == null) continue;
                this.tileName2Path.put(def.getName(), path);
            }
        }
    }

    private String getRecDefinitionPath(String name) {
        IDefinition def = this.definitionMap.get(name);
        if (def == null) {
            return null;
        }
        String result = def.getPath();
        if (result != null) {
            return result;
        }
        if (def.getExtendsProp() == null) {
            return null;
        }
        return this.getRecDefinitionPath(def.getExtendsProp());
    }

    public String getDefinitionPath(String name) {
        return this.tileName2Path.get(name);
    }

    public Collection<String> getAllRelevantPaths(String tileName) {
        if (!this.definitionMap.containsKey(tileName)) {
            return null;
        }
        HashSet result = HashSetFactory.make();
        String mainPath = this.getDefinitionPath(tileName);
        if (mainPath != null) {
            result.add(mainPath);
        }
        result.addAll(this.collectPathAttributes(tileName));
        return result;
    }

    private Collection<String> collectPathAttributes(String tileName) {
        IDefinition curDef;
        HashSet result = HashSetFactory.make();
        HashSet observedAttrs = HashSetFactory.make();
        String curTileName = tileName;
        while (curTileName != null && (curDef = this.definitionMap.get(curTileName)) != null) {
            List<IPut> putAttributes = curDef.getPutAttributes();
            for (IPut put : putAttributes) {
                String attrValue;
                String attrName = put.getName();
                if (!observedAttrs.add(attrName) || !(attrValue = put.getValue()).endsWith(".jsp")) continue;
                result.add(attrValue);
            }
            curTileName = curDef.getExtendsProp();
        }
        return result;
    }

    public static TilesAnalyzer createTilesAnalyzerFromConfigs(String webDir, String tilesConfigurationPaths) {
        ArrayList<IStrutsTilesInfo> tilesConfigurations = new ArrayList<IStrutsTilesInfo>();
        for (String tilesConfigurationPath : tilesConfigurationPaths.split(",")) {
            try {
                tilesConfigurations.add(DOMBasedStrutsTilesInfo.getStrutsParser(webDir + File.separatorChar + tilesConfigurationPath.trim()));
            }
            catch (IOException e) {
                TaintLogger.i().getLogger().warn((Object)("IOException trying to read Struts tiles config file " + tilesConfigurationPath), (Throwable)e);
            }
            catch (SAXException e) {
                TaintLogger.i().getLogger().warn((Object)("SAXException trying to parse Struts tiles config file " + tilesConfigurationPath), (Throwable)e);
            }
            catch (Exception e) {
                TaintLogger.i().getLogger().warn((Object)("Exception trying to parse Struts tiles config file " + tilesConfigurationPath), (Throwable)e);
            }
        }
        TilesAnalyzer tilesAnalyzer = new TilesAnalyzer(tilesConfigurations);
        return tilesAnalyzer;
    }
}

