/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.parsers.strutsValidatorParser;

import com.ibm.appscan.frameworks.parsers.strutsValidatorParser.IValidator;
import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.WalaUtil;
import com.ibm.appscan.taint.util.logging.TaintLogger;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.cha.IClassHierarchy;
import com.ibm.wala.types.MethodReference;
import com.ibm.wala.util.strings.StringStuff;
import org.apache.log4j.Logger;

public class ValidatorImpl
implements IValidator {
    private static final Logger logger = TaintLogger.i().getLogger();
    private final String className;
    private final String method;
    private final String[] methodParams;
    private final String name;
    private final FilePositionInfo filePositionInfo;
    private MethodReference resolvedMethodReference = null;
    private boolean resolvedTried = false;

    public ValidatorImpl(String name, String className, String method, String methodParamsStr, FilePositionInfo filePositionInfo) {
        this.className = className;
        this.method = method;
        this.methodParams = methodParamsStr.split(",");
        for (int i = 0; i < this.methodParams.length; ++i) {
            this.methodParams[i] = this.methodParams[i].trim();
        }
        this.name = name;
        this.filePositionInfo = filePositionInfo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.method == null ? 0 : this.method.hashCode());
        result = 31 * result + (this.methodParams == null ? 0 : this.methodParams.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValidatorImpl other = (ValidatorImpl)obj;
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.method == null ? other.method != null : !this.method.equals(other.method)) {
            return false;
        }
        if (this.methodParams == null ? other.methodParams != null : !this.methodParams.equals(other.methodParams)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public String toString() {
        return "ValidatorImpl [className=" + this.className + ", method=" + this.method + ", methodParams=" + this.methodParams + ", name=" + this.name + "]";
    }

    private String paramsAsJVM() {
        StringBuilder result = new StringBuilder();
        for (String param : this.methodParams) {
            result.append(StringStuff.deployment2CanonicalDescriptorTypeString((String)param));
        }
        return result.toString();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public FilePositionInfo getFilePositionInfo() {
        return this.filePositionInfo;
    }

    private String getSelectorString1() {
        return this.method + "(" + this.paramsAsJVM() + ")Z";
    }

    private String getSelectorString2() {
        return this.method + "(" + this.paramsAsJVM() + ")Ljava/lang/Object;";
    }

    @Override
    public MethodReference getResolvedMethodReference(IClassHierarchy cha) {
        if (!this.resolvedTried) {
            this.resolvedTried = true;
            IMethod resolvedMethod = cha.resolveMethod(WalaUtil.getUnresolvedMethodRef(this.className, this.getSelectorString1()));
            if (resolvedMethod == null && (resolvedMethod = cha.resolveMethod(WalaUtil.getUnresolvedMethodRef(this.className, this.getSelectorString2()))) == null) {
                logger.warn((Object)("Can't resolve validator method " + this));
                return null;
            }
            this.resolvedMethodReference = resolvedMethod.getReference();
        }
        return this.resolvedMethodReference;
    }

    @Override
    public int getRequestParamPosition() {
        if (!this.resolvedTried) {
            throw new IllegalStateException("This method should only be called after method has been resolved");
        }
        for (int i = 0; i < this.resolvedMethodReference.getNumberOfParameters(); ++i) {
            if (!this.resolvedMethodReference.getParameterType(i).toString().contains("HttpServletRequest")) continue;
            return i;
        }
        throw new IllegalStateException("Request parameter not found in validator");
    }
}

