/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.frameworks.util;

import com.ibm.appscan.frameworks.util.FilePositionInfo;
import com.ibm.appscan.frameworks.util.VDBJavaUtil;
import com.ibm.wala.classLoader.ClassLoaderImpl;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.classLoader.ShrikeClass;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class JavaUtils {
    private static final String[] javaKeywordsString = new String[]{"abstract", "assert", "boolean", "break", "byte", "case", "catch", "char", "class", "const", "continue", "default", "do", "double", "else", "enum", "extends", "final", "finally", "float", "for", "goto", "if", "implements", "import", "instanceof", "int", "interface", "long", "native", "new", "package", "private", "protected", "public", "return", "short", "static", "strictfp", "super", "switch", "synchronized", "this", "throws", "transient", "try", "void", "volatile", "while"};
    private static final Set<String> javaKeywords = new LinkedHashSet<String>(Arrays.asList(javaKeywordsString));

    public static boolean isJavaKeyword(String key) {
        return javaKeywords.contains(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<String> retrieveSourceDirectoryList(String scopeFileName) {
        ArrayList<String> sourceDirectoryList = new ArrayList<String>();
        BufferedReader r = null;
        try {
            String line;
            File scopeFile = new File(scopeFileName);
            if (scopeFile.exists()) {
                r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(scopeFile), "UTF-8"));
            } else {
                ArrayList<String> arrayList = sourceDirectoryList;
                return arrayList;
            }
            while ((line = r.readLine()) != null) {
                StringTokenizer toks = new StringTokenizer(line, "\n,");
                if (!toks.hasMoreTokens()) continue;
                String scope = toks.nextToken();
                String language = toks.nextToken();
                String entryType = toks.nextToken();
                String entryPathname = toks.nextToken();
                if (!"sourceDir".equals(entryType)) continue;
                sourceDirectoryList.add(entryPathname);
            }
        }
        catch (Exception e) {
            ArrayList<String> arrayList = sourceDirectoryList;
            return arrayList;
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return sourceDirectoryList;
    }

    public static String getSourceFileNameFullPath(String baseSourceFileName, List<String> sourceDirectoryList) {
        if (sourceDirectoryList == null || sourceDirectoryList.isEmpty()) {
            return baseSourceFileName;
        }
        for (String sourceDirPath : sourceDirectoryList) {
            String sourceFileFullPath = JavaUtils.searchSourceFileFullPathInSourceDirs(sourceDirPath, "", baseSourceFileName);
            if (sourceFileFullPath == null || sourceFileFullPath.trim().length() <= 0) continue;
            return sourceFileFullPath;
        }
        return baseSourceFileName;
    }

    private static String searchSourceFileFullPathInSourceDirs(String directory, String curSubDir, String baseSourceFileName) {
        String thisBaseFileName;
        File dirFile = new File(directory + File.separatorChar + curSubDir);
        String[] sourceFilesInDir = dirFile.list(new FilenameFilter(thisBaseFileName = baseSourceFileName){
            final /* synthetic */ String val$thisBaseFileName;
            {
                this.val$thisBaseFileName = string;
            }

            @Override
            public boolean accept(File dir, String name) {
                return name.trim().equals(this.val$thisBaseFileName);
            }
        });
        if (sourceFilesInDir.length > 0) {
            return directory + File.separatorChar + curSubDir + File.separatorChar + baseSourceFileName;
        }
        for (File f : dirFile.listFiles()) {
            String fullPath;
            if (!f.isDirectory() || (fullPath = JavaUtils.searchSourceFileFullPathInSourceDirs(dirFile.getAbsolutePath(), f.getName(), baseSourceFileName)) == null || fullPath.trim().length() <= 0) continue;
            return fullPath;
        }
        return null;
    }

    public static FilePositionInfo getMethodPosition(IMethod method, List<String> sourceDirectoryList) {
        ShrikeClass sc;
        IClassLoader classLoader;
        FilePositionInfo posInfo = null;
        if (method.getDeclaringClass() instanceof ShrikeClass && (classLoader = (sc = (ShrikeClass)method.getDeclaringClass()).getClassLoader()) instanceof ClassLoaderImpl) {
            String sourceFileNameFullPath;
            String sourceFileName = ((ClassLoaderImpl)classLoader).getSourceFileName((IClass)sc);
            if (sourceFileName == null) {
                sourceFileName = JavaUtils.getMethodSourceFileName(method);
            }
            if ((sourceFileNameFullPath = JavaUtils.getSourceFileNameFullPath(sourceFileName, sourceDirectoryList)) != null) {
                posInfo = FilePositionInfo.make((String)sourceFileNameFullPath, (int)method.getLineNumber(0), (int)0);
            }
        }
        if (posInfo.getLineNumber() == -1) {
            posInfo = FilePositionInfo.make((String)posInfo.getFilename(), (int)0, (int)posInfo.getColumnNumber());
        }
        return posInfo;
    }

    public static String getMethodSourceFileName(IMethod method) {
        String classFullName = method.getDeclaringClass().getName().toString();
        classFullName = VDBJavaUtil.jvmToVDBType(classFullName);
        String sourceFileName = classFullName.replaceAll("\\.", "/") + ".java";
        return sourceFileName;
    }
}

