/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.demandpa.alg;

import com.ibm.wala.demandpa.alg.statemachine.StateMachine;

public abstract class WithState<T> {
    private final T wrapped;
    private final StateMachine.State state;
    private final int hc;

    public WithState(T wrapped, StateMachine.State state) {
        if (wrapped == null) {
            throw new IllegalArgumentException("null wrapped");
        }
        if (state == null) {
            throw new IllegalArgumentException("null state");
        }
        this.wrapped = wrapped;
        this.state = state;
        this.hc = 31 * state.hashCode() + wrapped.hashCode();
    }

    public StateMachine.State getState() {
        return this.state;
    }

    public T getWrapped() {
        return this.wrapped;
    }

    public String toString() {
        return this.wrapped + ", STATE " + this.state;
    }

    public int hashCode() {
        return this.hc;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WithState other = (WithState)obj;
        if (this.state == null ? other.state != null : !this.state.equals(other.state)) {
            return false;
        }
        return !(this.wrapped == null ? other.wrapped != null : !this.wrapped.equals(other.wrapped));
    }
}

