/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.escape;

import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSACFG;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAReturnInstruction;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.HashSetFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.Iterator2Set;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import com.ibm.wala.util.graph.traverse.DFS;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;

public class LocalLiveRangeAnalysis {
    public static boolean isLive(int v, int instructionIndex, IR ir, DefUse du) {
        if (du == null) {
            throw new IllegalArgumentException("du is null");
        }
        if (du.getNumberOfUses(v) == 0) {
            return false;
        }
        if (instructionIndex < 0) {
            Assertions.UNREACHABLE();
        }
        ISSABasicBlock queryBlock = LocalLiveRangeAnalysis.findBlock(ir, instructionIndex);
        SSAInstruction def = du.getDef(v);
        final SSACFG.BasicBlock defBlock = def == null ? null : LocalLiveRangeAnalysis.findBlock(ir, def);
        Collection<SSACFG.BasicBlock> uses = LocalLiveRangeAnalysis.findBlocks(ir, du.getUses(v));
        Predicate notDef = new Predicate(){

            public boolean test(Object o) {
                return defBlock == null || !defBlock.equals(o);
            }
        };
        if (defBlock != null && defBlock.equals(queryBlock)) {
            return true;
        }
        Collection reached = DFS.getReachableNodes((Graph)ir.getControlFlowGraph(), Collections.singleton(queryBlock), (Predicate)notDef);
        uses.retainAll(reached);
        if (uses.isEmpty()) {
            return false;
        }
        if (uses.size() == 1 && uses.iterator().next().equals(queryBlock)) {
            if (instructionIndex == queryBlock.getLastInstructionIndex()) {
                return ir.getInstructions()[instructionIndex] instanceof SSAReturnInstruction;
            }
            return true;
        }
        return true;
    }

    private static Collection<SSACFG.BasicBlock> findBlocks(IR ir, Iterator<SSAInstruction> statements) {
        Iterator2Set s = Iterator2Collection.toSet(statements);
        HashSet result = HashSetFactory.make();
        Iterator<ISSABasicBlock> it = ir.getControlFlowGraph().iterator();
        block0: while (it.hasNext()) {
            SSACFG.BasicBlock b = (SSACFG.BasicBlock)it.next();
            for (SSAInstruction x : b) {
                if (!s.contains(x)) continue;
                result.add(b);
                continue block0;
            }
        }
        if (result.isEmpty()) {
            Assertions.UNREACHABLE();
        }
        return result;
    }

    private static SSACFG.BasicBlock findBlock(IR ir, SSAInstruction s) {
        if (s == null) {
            Assertions.UNREACHABLE();
        }
        Iterator<ISSABasicBlock> it = ir.getControlFlowGraph().iterator();
        while (it.hasNext()) {
            SSACFG.BasicBlock b = (SSACFG.BasicBlock)it.next();
            for (SSAInstruction x : b) {
                if (!s.equals(x)) continue;
                return b;
            }
        }
        Assertions.UNREACHABLE((String)("no block for " + s + " in IR " + ir));
        return null;
    }

    private static ISSABasicBlock findBlock(IR ir, int i) {
        Iterator<ISSABasicBlock> it = ir.getControlFlowGraph().iterator();
        while (it.hasNext()) {
            SSACFG.BasicBlock b = (SSACFG.BasicBlock)it.next();
            if (i < b.getFirstInstructionIndex() || i > b.getLastInstructionIndex()) continue;
            return b;
        }
        Assertions.UNREACHABLE((String)("no block for " + i + " in IR " + ir));
        return null;
    }
}

