/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation;

import com.ibm.wala.ipa.callgraph.propagation.FilteredPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKey;
import com.ibm.wala.ipa.callgraph.propagation.LocalPointerKeyWithFilter;
import com.ibm.wala.ipa.callgraph.propagation.PointerKey;
import com.ibm.wala.ipa.callgraph.propagation.PointsToSetVariable;
import com.ibm.wala.ipa.callgraph.propagation.ReturnValueKey;
import com.ibm.wala.ipa.callgraph.propagation.ReturnValueKeyWithFilter;
import com.ibm.wala.util.Predicate;
import com.ibm.wala.util.collections.FilterIterator;
import com.ibm.wala.util.collections.IVector;
import com.ibm.wala.util.collections.SimpleVector;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.intset.IntegerUnionFind;
import com.ibm.wala.util.intset.MutableMapping;
import java.util.Iterator;

public class PointsToMap {
    private final MutableMapping<PointerKey> pointerKeys = MutableMapping.make();
    private final IVector<Object> pointsToSets = new SimpleVector();
    private final IntegerUnionFind uf = new IntegerUnionFind();
    static final Object IMPLICIT = new Object(){

        public String toString() {
            return "IMPLICIT points-to set";
        }
    };
    static final Object UNIFIED = new Object(){

        public String toString() {
            return "UNIFIED points-to set";
        }
    };
    private final BitVector transitiveRoots = new BitVector();

    public Iterator<PointerKey> iterateKeys() {
        return this.pointerKeys.iterator();
    }

    public PointsToSetVariable getPointsToSet(PointerKey p) {
        if (p == null) {
            throw new IllegalArgumentException("null p");
        }
        if (this.isImplicit(p)) {
            throw new IllegalArgumentException("unexpected: shouldn't ask a PointsToMap for an implicit points-to-set: " + p);
        }
        int i = this.pointerKeys.getMappedIndex((Object)p);
        if (i == -1) {
            return null;
        }
        int repI = this.uf.find(i);
        PointsToSetVariable result = (PointsToSetVariable)((Object)this.pointsToSets.get(repI));
        if (result != null && p instanceof FilteredPointerKey && !(result.getPointerKey() instanceof FilteredPointerKey)) {
            this.upgradeToFilter(result, ((FilteredPointerKey)p).getTypeFilter());
        }
        return result;
    }

    public PointsToSetVariable getPointsToSet(int id) {
        int repI = this.uf.find(id);
        return (PointsToSetVariable)((Object)this.pointsToSets.get(repI));
    }

    public void recordImplicit(PointerKey key) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        int i = this.findOrCreateIndex(key);
        this.pointsToSets.set(i, IMPLICIT);
    }

    public void put(PointerKey key, PointsToSetVariable v) {
        int i = this.findOrCreateIndex(key);
        this.pointsToSets.set(i, (Object)v);
    }

    private int findOrCreateIndex(PointerKey key) {
        int result = this.pointerKeys.getMappedIndex((Object)key);
        if (result == -1) {
            result = this.pointerKeys.add((Object)key);
        }
        return result;
    }

    public void recordUnified(PointerKey key) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        int i = this.findOrCreateIndex(key);
        this.pointsToSets.set(i, UNIFIED);
    }

    public void recordTransitiveRoot(PointerKey key) {
        if (key == null) {
            throw new IllegalArgumentException("null key");
        }
        int i = this.findOrCreateIndex(key);
        this.transitiveRoots.set(i);
    }

    boolean isTransitiveRoot(PointerKey key) {
        int i = this.findOrCreateIndex(key);
        return this.transitiveRoots.get(i);
    }

    public boolean isUnified(PointerKey p) {
        if (p == null) {
            throw new IllegalArgumentException("null p");
        }
        int i = this.findOrCreateIndex(p);
        return this.pointsToSets.get(i) == UNIFIED;
    }

    public boolean isImplicit(PointerKey p) {
        int i = this.getIndex(p);
        return i != -1 && this.pointsToSets.get(i) == IMPLICIT;
    }

    protected int getNumberOfPointerKeys() {
        return this.pointerKeys.getSize();
    }

    public void revertToPreTransitive() {
        Iterator<PointerKey> it = this.iterateKeys();
        while (it.hasNext()) {
            PointerKey key = it.next();
            if (this.isTransitiveRoot(key) || this.isImplicit(key) || this.isUnified(key)) continue;
            PointsToSetVariable v = this.getPointsToSet(key);
            v.removeAll();
        }
    }

    public Iterator<PointerKey> getTransitiveRoots() {
        return new FilterIterator(this.iterateKeys(), new Predicate(){

            public boolean test(Object o) {
                return PointsToMap.this.isTransitiveRoot((PointerKey)o);
            }
        });
    }

    public void unify(IntSet s) throws IllegalArgumentException {
        if (s == null) {
            throw new IllegalArgumentException("s is null");
        }
        if (s.size() <= 1) {
            throw new IllegalArgumentException("Can't unify set of size " + s.size());
        }
        IntIterator it = s.intIterator();
        int i = it.next();
        while (it.hasNext()) {
            this.unify(i, it.next());
        }
    }

    public void unify(int i, int j) {
        int repJ;
        int repI = this.uf.find(i);
        if (repI != (repJ = this.uf.find(j))) {
            PointsToSetVariable pi = (PointsToSetVariable)((Object)this.pointsToSets.get(repI));
            PointsToSetVariable pj = (PointsToSetVariable)((Object)this.pointsToSets.get(repJ));
            if (pi == null) {
                throw new IllegalArgumentException("No PointsToSetVariable for i: " + i);
            }
            if (pj == null) {
                throw new IllegalArgumentException("No PointsToSetVariable for j: " + j);
            }
            this.uf.union(repI, repJ);
            int rep = this.uf.find(repI);
            PointsToSetVariable p = (PointsToSetVariable)((Object)this.pointsToSets.get(rep));
            if (pi.getValue() != null) {
                p.addAll((IntSet)pi.getValue());
            }
            if (pj.getValue() != null) {
                p.addAll((IntSet)pj.getValue());
            }
            if (p != pi) {
                this.recordUnified(pi.getPointerKey());
                this.upgradeTypeFilter(pi, p);
            }
            if (p != pj) {
                this.recordUnified(pj.getPointerKey());
                this.upgradeTypeFilter(pj, p);
            }
            if (this.isTransitiveRoot(pi.getPointerKey()) || this.isTransitiveRoot(pj.getPointerKey())) {
                this.recordTransitiveRoot(p.getPointerKey());
            }
        }
    }

    private void upgradeTypeFilter(PointsToSetVariable src, PointsToSetVariable dest) {
        if (src.getPointerKey() instanceof FilteredPointerKey) {
            FilteredPointerKey fpk = (FilteredPointerKey)src.getPointerKey();
            if (dest.getPointerKey() instanceof FilteredPointerKey) {
                FilteredPointerKey fp = (FilteredPointerKey)dest.getPointerKey();
                if (!fp.getTypeFilter().equals(fpk.getTypeFilter())) {
                    Assertions.UNREACHABLE((String)("src " + fpk.getTypeFilter() + " dest " + fp.getTypeFilter()));
                }
            } else {
                this.upgradeToFilter(dest, fpk.getTypeFilter());
            }
        }
    }

    private void upgradeToFilter(PointsToSetVariable p, FilteredPointerKey.TypeFilter typeFilter) {
        if (p.getPointerKey() instanceof LocalPointerKey) {
            LocalPointerKey lpk = (LocalPointerKey)p.getPointerKey();
            LocalPointerKeyWithFilter f = new LocalPointerKeyWithFilter(lpk.getNode(), lpk.getValueNumber(), typeFilter);
            p.setPointerKey(f);
            this.pointerKeys.replace((Object)lpk, (Object)f);
        } else if (p.getPointerKey() instanceof ReturnValueKey) {
            ReturnValueKey r = (ReturnValueKey)p.getPointerKey();
            ReturnValueKeyWithFilter f = new ReturnValueKeyWithFilter(r.getNode(), typeFilter);
            p.setPointerKey(f);
            this.pointerKeys.replace((Object)r, (Object)f);
        } else {
            Assertions.UNREACHABLE((String)p.getPointerKey().getClass().toString());
        }
    }

    public int getIndex(PointerKey p) {
        return this.pointerKeys.getMappedIndex((Object)p);
    }

    public int getRepresentative(int i) {
        return this.uf.find(i);
    }
}

