/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ipa.callgraph.propagation.cfa;

import com.ibm.wala.classLoader.CallSiteReference;
import com.ibm.wala.ipa.callgraph.CGNode;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.ContextItem;
import com.ibm.wala.ipa.callgraph.ContextKey;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallerContextPair;
import com.ibm.wala.ipa.callgraph.propagation.cfa.CallerSiteContext;

public class CallerSiteContextPair
extends CallerSiteContext {
    private final Context baseContext;

    public CallerSiteContextPair(CGNode caller, CallSiteReference callSite, Context baseContext) {
        super(caller, callSite);
        if (caller == null) {
            throw new IllegalArgumentException("null caller");
        }
        this.baseContext = baseContext;
        assert (!(baseContext instanceof CallerContextPair));
    }

    @Override
    public ContextItem get(ContextKey name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (name.equals(ContextKey.CALLER) || name.equals(ContextKey.CALLSITE)) {
            return super.get(name);
        }
        return this.baseContext.get(name);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass().equals(obj.getClass())) {
            CallerSiteContextPair other = (CallerSiteContextPair)obj;
            return this.getCaller().equals(other.getCaller()) && this.getCallSite().equals(other.getCallSite()) && this.baseContext.equals(other.baseContext);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.baseContext.hashCode();
    }

    @Override
    public String toString() {
        return super.toString() + ",Base:" + this.baseContext;
    }
}

