/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAArrayReferenceInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;

public abstract class SSAArrayLoadInstruction
extends SSAArrayReferenceInstruction {
    private final int result;

    protected SSAArrayLoadInstruction(int iindex, int result, int arrayref, int index, TypeReference elementType) {
        super(iindex, arrayref, index, elementType);
        this.result = result;
    }

    @Override
    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) throws IllegalArgumentException {
        if (defs != null && defs.length == 0) {
            throw new IllegalArgumentException("defs.length == 0");
        }
        if (uses != null && uses.length < 2) {
            throw new IllegalArgumentException("uses.length < 2");
        }
        return insts.ArrayLoadInstruction(this.iindex, defs == null ? this.result : defs[0], uses == null ? this.getArrayRef() : uses[0], uses == null ? this.getIndex() : uses[1], this.getElementType());
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        return this.getValueString(symbolTable, this.result) + " = arrayload " + this.getValueString(symbolTable, this.getArrayRef()) + "[" + this.getValueString(symbolTable, this.getIndex()) + "]";
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) {
        if (v == null) {
            throw new IllegalArgumentException("v is null");
        }
        v.visitArrayLoad(this);
    }

    @Override
    public boolean hasDef() {
        return true;
    }

    @Override
    public int getDef() {
        return this.result;
    }

    @Override
    public int getDef(int i) {
        if (i != 0) {
            throw new IllegalArgumentException("illegal i: " + i);
        }
        return this.result;
    }

    @Override
    public int getNumberOfDefs() {
        return 1;
    }

    @Override
    public int hashCode() {
        return 6311 * this.result ^ 2371 * this.getArrayRef() + this.getIndex();
    }
}

