/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.shrikeBT.IBinaryOpInstruction;
import com.ibm.wala.ssa.SSAAbstractBinaryInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SymbolTable;

public abstract class SSABinaryOpInstruction
extends SSAAbstractBinaryInstruction {
    private final IBinaryOpInstruction.IOperator operator;
    private final boolean mayBeInteger;

    protected SSABinaryOpInstruction(int iindex, IBinaryOpInstruction.IOperator operator, int result, int val1, int val2, boolean mayBeInteger) {
        super(iindex, result, val1, val2);
        this.operator = operator;
        this.mayBeInteger = mayBeInteger;
        if (val1 <= 0) {
            throw new IllegalArgumentException("illegal val1: " + val1);
        }
        if (val2 <= 0) {
            throw new IllegalArgumentException("illegal val2: " + val2);
        }
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        return this.getValueString(symbolTable, this.result) + " = binaryop(" + this.operator + ") " + this.getValueString(symbolTable, this.val1) + " , " + this.getValueString(symbolTable, this.val2);
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) throws NullPointerException {
        v.visitBinaryOp(this);
    }

    public IBinaryOpInstruction.IOperator getOperator() {
        return this.operator;
    }

    @Override
    public boolean isPEI() {
        return this.mayBeInteger && (this.operator == IBinaryOpInstruction.Operator.DIV || this.operator == IBinaryOpInstruction.Operator.REM);
    }

    @Override
    public boolean isFallThrough() {
        return true;
    }

    public boolean mayBeIntegerOp() {
        return this.mayBeInteger;
    }
}

