/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.cfg.AbstractCFG;
import com.ibm.wala.cfg.BytecodeCFG;
import com.ibm.wala.cfg.ControlFlowGraph;
import com.ibm.wala.cfg.IBasicBlock;
import com.ibm.wala.cfg.InducedCFG;
import com.ibm.wala.classLoader.IClass;
import com.ibm.wala.classLoader.IClassLoader;
import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.shrikeBT.ExceptionHandler;
import com.ibm.wala.shrikeBT.IInstruction;
import com.ibm.wala.ssa.ISSABasicBlock;
import com.ibm.wala.ssa.SSAGetCaughtExceptionInstruction;
import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAPhiInstruction;
import com.ibm.wala.ssa.SSAPiInstruction;
import com.ibm.wala.types.TypeReference;
import com.ibm.wala.util.collections.EmptyIterator;
import com.ibm.wala.util.collections.HashMapFactory;
import com.ibm.wala.util.collections.Iterator2Collection;
import com.ibm.wala.util.collections.MapIterator;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.debug.UnimplementedError;
import com.ibm.wala.util.functions.Function;
import com.ibm.wala.util.graph.NumberedNodeManager;
import com.ibm.wala.util.graph.impl.NumberedNodeIterator;
import com.ibm.wala.util.intset.BitVector;
import com.ibm.wala.util.intset.IntSet;
import com.ibm.wala.util.shrike.ShrikeUtil;
import com.ibm.wala.util.warnings.Warning;
import com.ibm.wala.util.warnings.Warnings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SSACFG
implements ControlFlowGraph<SSAInstruction, ISSABasicBlock> {
    private static final boolean DEBUG = false;
    private BasicBlock[] basicBlocks;
    protected final SSAInstruction[] instructions;
    protected final IMethod method;
    protected final AbstractCFG<IInstruction, IBasicBlock<IInstruction>> delegate;
    private BasicBlock exit;
    private final Map<RefPathKey, SSAPiInstruction> piInstructions = HashMapFactory.make((int)2);

    public SSACFG(IMethod method, AbstractCFG cfg, SSAInstruction[] instructions) {
        if (method == null) {
            throw new IllegalArgumentException("method is null");
        }
        this.delegate = cfg;
        this.method = method;
        assert (method.getDeclaringClass() != null) : "null declaring class for " + method;
        this.createBasicBlocks(cfg);
        if (cfg instanceof InducedCFG) {
            this.addPhisFromInducedCFG((InducedCFG)cfg);
            this.addPisFromInducedCFG((InducedCFG)cfg);
        }
        if (cfg instanceof BytecodeCFG) {
            this.recordExceptionTypes(((BytecodeCFG)((Object)cfg)).getExceptionHandlers(), method.getDeclaringClass().getClassLoader());
        }
        this.instructions = instructions;
    }

    private void addPisFromInducedCFG(InducedCFG cfg) {
        Iterator it = cfg.iterator();
        while (it.hasNext()) {
            InducedCFG.BasicBlock ib = (InducedCFG.BasicBlock)it.next();
            BasicBlock b = this.getBasicBlock(ib.getNumber());
            for (SSAPiInstruction pi : ib.getPis()) {
                BasicBlock path = this.getBasicBlock(pi.getSuccessor());
                b.addPiForRefAndPath(pi.getVal(), path, pi);
            }
        }
    }

    private void addPhisFromInducedCFG(InducedCFG cfg) {
        Iterator it = cfg.iterator();
        while (it.hasNext()) {
            InducedCFG.BasicBlock ib = (InducedCFG.BasicBlock)it.next();
            BasicBlock b = this.getBasicBlock(ib.getNumber());
            int local = 0;
            for (SSAPhiInstruction phi : ib.getPhis()) {
                b.addPhiForLocal(local++, phi);
            }
        }
    }

    public int hashCode() {
        return -3 * this.delegate.hashCode();
    }

    public boolean equals(Object o) {
        return o instanceof SSACFG && this.delegate.equals(((SSACFG)o).delegate);
    }

    private void recordExceptionTypes(Set<ExceptionHandler> set, IClassLoader loader) {
        for (ExceptionHandler handler : set) {
            TypeReference t = null;
            if (handler.getCatchClass() == null) {
                t = TypeReference.JavaLangThrowable;
            } else {
                TypeReference exceptionType = ShrikeUtil.makeTypeReference(loader.getReference(), handler.getCatchClass());
                IClass klass = null;
                klass = loader.lookupClass(exceptionType.getName());
                if (klass == null) {
                    Warnings.add(ExceptionLoadFailure.create(exceptionType, this.method));
                    t = exceptionType;
                } else {
                    t = klass.getReference();
                }
            }
            int instructionIndex = handler.getHandler();
            BasicBlock b = this.getBlockForInstruction(instructionIndex);
            if (!(b instanceof ExceptionHandlerBasicBlock)) assert (b instanceof ExceptionHandlerBasicBlock) : "not exception handler " + b + " index " + instructionIndex;
            ExceptionHandlerBasicBlock bb = (ExceptionHandlerBasicBlock)this.getBlockForInstruction(instructionIndex);
            bb.addCaughtExceptionType(t);
        }
    }

    private void createBasicBlocks(AbstractCFG G) {
        this.basicBlocks = new BasicBlock[G.getNumberOfNodes()];
        for (int i = 0; i <= G.getMaxNumber(); ++i) {
            this.basicBlocks[i] = G.getCatchBlocks().get(i) ? new ExceptionHandlerBasicBlock(i) : new BasicBlock(i);
        }
        this.exit = this.basicBlocks[this.delegate.getNumber(this.delegate.exit())];
    }

    @Override
    public BasicBlock getBlockForInstruction(int instructionIndex) {
        Object N = this.delegate.getBlockForInstruction(instructionIndex);
        int number = this.delegate.getNumber((IBasicBlock<IInstruction>)N);
        return this.basicBlocks[number];
    }

    public SSAInstruction[] getInstructions() {
        return this.instructions;
    }

    public String toString() {
        StringBuffer s = new StringBuffer("");
        for (int i = 0; i <= this.getNumber(this.exit()); ++i) {
            BasicBlock bb = this.getNode(i);
            s.append("BB").append(i).append("[").append(bb.getFirstInstructionIndex()).append("..").append(bb.getLastInstructionIndex()).append("]\n");
            Iterator<ISSABasicBlock> succNodes = this.getSuccNodes(bb);
            while (succNodes.hasNext()) {
                s.append("    -> BB").append(((BasicBlock)succNodes.next()).getNumber()).append("\n");
            }
        }
        return s.toString();
    }

    @Override
    public BitVector getCatchBlocks() {
        return this.delegate.getCatchBlocks();
    }

    public boolean isCatchBlock(int i) {
        return this.delegate.isCatchBlock(i);
    }

    @Override
    public BasicBlock entry() {
        return this.basicBlocks[0];
    }

    @Override
    public BasicBlock exit() {
        return this.exit;
    }

    public int getNumber(ISSABasicBlock b) throws IllegalArgumentException {
        if (b == null) {
            throw new IllegalArgumentException("N == null");
        }
        return b.getNumber();
    }

    public BasicBlock getNode(int number) {
        return this.basicBlocks[number];
    }

    public int getMaxNumber() {
        return this.basicBlocks.length - 1;
    }

    public Iterator<ISSABasicBlock> iterator() {
        ArrayList<BasicBlock> list = new ArrayList<BasicBlock>();
        for (BasicBlock b : this.basicBlocks) {
            list.add(b);
        }
        return list.iterator();
    }

    public int getNumberOfNodes() {
        return this.delegate.getNumberOfNodes();
    }

    public Iterator<ISSABasicBlock> getPredNodes(ISSABasicBlock b) throws IllegalArgumentException {
        if (b == null) {
            throw new IllegalArgumentException("b == null");
        }
        Object n = this.delegate.getNode(b.getNumber());
        final Iterator<IBasicBlock<IInstruction>> i = this.delegate.getPredNodes((IBasicBlock<IInstruction>)n);
        return new Iterator<ISSABasicBlock>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public BasicBlock next() {
                IBasicBlock n = (IBasicBlock)i.next();
                int number = n.getNumber();
                return SSACFG.this.basicBlocks[number];
            }

            @Override
            public void remove() {
                Assertions.UNREACHABLE();
            }
        };
    }

    public int getPredNodeCount(ISSABasicBlock b) throws IllegalArgumentException {
        if (b == null) {
            throw new IllegalArgumentException("b == null");
        }
        Object n = this.delegate.getNode(b.getNumber());
        return this.delegate.getPredNodeCount((IBasicBlock<IInstruction>)n);
    }

    public Iterator<ISSABasicBlock> getSuccNodes(ISSABasicBlock b) throws IllegalArgumentException {
        if (b == null) {
            throw new IllegalArgumentException("b == null");
        }
        Object n = this.delegate.getNode(b.getNumber());
        final Iterator<IBasicBlock<IInstruction>> i = this.delegate.getSuccNodes((IBasicBlock<IInstruction>)n);
        return new Iterator<ISSABasicBlock>(){

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public ISSABasicBlock next() {
                IBasicBlock n = (IBasicBlock)i.next();
                int number = n.getNumber();
                return SSACFG.this.basicBlocks[number];
            }

            @Override
            public void remove() {
                Assertions.UNREACHABLE();
            }
        };
    }

    public int getSuccNodeCount(ISSABasicBlock b) throws IllegalArgumentException {
        if (b == null) {
            throw new IllegalArgumentException("b == null");
        }
        Object n = this.delegate.getNode(b.getNumber());
        return this.delegate.getSuccNodeCount((IBasicBlock<IInstruction>)n);
    }

    public void addNode(ISSABasicBlock n) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void addEdge(ISSABasicBlock src, ISSABasicBlock dst) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void removeEdge(ISSABasicBlock src, ISSABasicBlock dst) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void removeAllIncidentEdges(ISSABasicBlock node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void removeNodeAndEdges(ISSABasicBlock N) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void removeNode(ISSABasicBlock n) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getProgramCounter(int index) {
        return this.delegate.getProgramCounter(index);
    }

    public boolean containsNode(ISSABasicBlock N) {
        if (N instanceof BasicBlock) {
            return this.basicBlocks[this.getNumber(N)] == N;
        }
        return false;
    }

    @Override
    public IMethod getMethod() {
        return this.method;
    }

    @Override
    public List<ISSABasicBlock> getExceptionalSuccessors(ISSABasicBlock b) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        Object n = this.delegate.getNode(b.getNumber());
        Iterator<IBasicBlock<IInstruction>> i = this.delegate.getExceptionalSuccessors((IBasicBlock<IInstruction>)n).iterator();
        ArrayList<ISSABasicBlock> c = new ArrayList<ISSABasicBlock>(this.getSuccNodeCount(b));
        while (i.hasNext()) {
            IBasicBlock<IInstruction> s = i.next();
            c.add(this.basicBlocks[this.delegate.getNumber(s)]);
        }
        return c;
    }

    @Override
    public Collection<ISSABasicBlock> getExceptionalPredecessors(ISSABasicBlock b) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        Object n = this.delegate.getNode(b.getNumber());
        Function<IBasicBlock<IInstruction>, ISSABasicBlock> f = new Function<IBasicBlock<IInstruction>, ISSABasicBlock>(){

            public ISSABasicBlock apply(IBasicBlock<IInstruction> object) {
                return SSACFG.this.basicBlocks[SSACFG.this.delegate.getNumber(object)];
            }
        };
        return Iterator2Collection.toSet((Iterator)new MapIterator(this.delegate.getExceptionalPredecessors((IBasicBlock<IInstruction>)n).iterator(), (Function)f));
    }

    private IBasicBlock<IInstruction> getUnderlyingBlock(BasicBlock block) {
        return this.delegate.getNode(this.getNumber(block));
    }

    public boolean hasExceptionalEdge(BasicBlock src, BasicBlock dest) {
        if (dest == null) {
            throw new IllegalArgumentException("dest is null");
        }
        if (dest.isExitBlock()) {
            int srcNum = this.getNumber(src);
            return this.delegate.getExceptionalToExit().get(srcNum);
        }
        return this.delegate.hasExceptionalEdge(this.getUnderlyingBlock(src), this.getUnderlyingBlock(dest));
    }

    public boolean hasNormalEdge(BasicBlock src, BasicBlock dest) {
        if (dest == null) {
            throw new IllegalArgumentException("dest is null");
        }
        if (dest.isExitBlock()) {
            int srcNum = this.getNumber(src);
            return this.delegate.getNormalToExit().get(srcNum);
        }
        return this.delegate.hasNormalEdge(this.getUnderlyingBlock(src), this.getUnderlyingBlock(dest));
    }

    @Override
    public Collection<ISSABasicBlock> getNormalSuccessors(ISSABasicBlock b) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        Object n = this.delegate.getNode(b.getNumber());
        Iterator<IBasicBlock<IInstruction>> i = this.delegate.getNormalSuccessors((IBasicBlock<IInstruction>)n).iterator();
        ArrayList<ISSABasicBlock> c = new ArrayList<ISSABasicBlock>(this.getSuccNodeCount(b));
        while (i.hasNext()) {
            IBasicBlock<IInstruction> s = i.next();
            c.add(this.basicBlocks[this.delegate.getNumber(s)]);
        }
        return c;
    }

    @Override
    public Collection<ISSABasicBlock> getNormalPredecessors(ISSABasicBlock b) {
        if (b == null) {
            throw new IllegalArgumentException("b is null");
        }
        Object n = this.delegate.getNode(b.getNumber());
        Iterator<IBasicBlock<IInstruction>> i = this.delegate.getNormalPredecessors((IBasicBlock<IInstruction>)n).iterator();
        ArrayList<ISSABasicBlock> c = new ArrayList<ISSABasicBlock>(this.getPredNodeCount(b));
        while (i.hasNext()) {
            IBasicBlock<IInstruction> s = i.next();
            c.add(this.basicBlocks[this.delegate.getNumber(s)]);
        }
        return c;
    }

    public Iterator<ISSABasicBlock> iterateNodes(IntSet s) {
        return new NumberedNodeIterator(s, (NumberedNodeManager)this);
    }

    public void removeIncomingEdges(ISSABasicBlock node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public void removeOutgoingEdges(ISSABasicBlock node) throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public boolean hasEdge(ISSABasicBlock src, ISSABasicBlock dst) throws UnimplementedError {
        return this.getSuccNodeNumbers(src).contains(this.getNumber(dst));
    }

    public IntSet getSuccNodeNumbers(ISSABasicBlock b) throws IllegalArgumentException {
        if (b == null) {
            throw new IllegalArgumentException("b == null");
        }
        Object n = this.delegate.getNode(b.getNumber());
        return this.delegate.getSuccNodeNumbers((IBasicBlock<IInstruction>)n);
    }

    public IntSet getPredNodeNumbers(ISSABasicBlock node) throws UnimplementedError {
        Assertions.UNREACHABLE();
        return null;
    }

    public BasicBlock getBasicBlock(int bb) {
        return this.basicBlocks[bb];
    }

    private static class ExceptionLoadFailure
    extends Warning {
        final TypeReference type;
        final IMethod method;

        ExceptionLoadFailure(TypeReference type, IMethod method) {
            super((byte)1);
            this.type = type;
            this.method = method;
        }

        @Override
        public String getMsg() {
            return this.getClass().toString() + " : " + this.type + " " + this.method;
        }

        public static ExceptionLoadFailure create(TypeReference type, IMethod method) {
            return new ExceptionLoadFailure(type, method);
        }
    }

    public class ExceptionHandlerBasicBlock
    extends BasicBlock {
        private TypeReference[] exceptionTypes;
        private static final int initialCapacity = 3;
        private int nExceptionTypes;
        private SSAGetCaughtExceptionInstruction catchInstruction;

        public ExceptionHandlerBasicBlock(int number) {
            super(number);
            this.nExceptionTypes = 0;
        }

        public SSAGetCaughtExceptionInstruction getCatchInstruction() {
            return this.catchInstruction;
        }

        public void setCatchInstruction(SSAGetCaughtExceptionInstruction catchInstruction) {
            this.catchInstruction = catchInstruction;
        }

        @Override
        public Iterator<TypeReference> getCaughtExceptionTypes() {
            return new Iterator<TypeReference>(){
                int next = 0;

                @Override
                public boolean hasNext() {
                    return this.next < ExceptionHandlerBasicBlock.this.nExceptionTypes;
                }

                @Override
                public TypeReference next() {
                    return ExceptionHandlerBasicBlock.this.exceptionTypes[this.next++];
                }

                @Override
                public void remove() {
                    Assertions.UNREACHABLE();
                }
            };
        }

        @Override
        public String toString() {
            return "BB(Handler)[SSA]" + this.getNumber() + " - " + SSACFG.this.method.getSignature();
        }

        public void addCaughtExceptionType(TypeReference exceptionType) {
            if (this.exceptionTypes == null) {
                this.exceptionTypes = new TypeReference[3];
            }
            ++this.nExceptionTypes;
            if (this.nExceptionTypes > this.exceptionTypes.length) {
                TypeReference[] temp = this.exceptionTypes;
                this.exceptionTypes = new TypeReference[this.nExceptionTypes * 2];
                System.arraycopy(temp, 0, this.exceptionTypes, 0, temp.length);
            }
            this.exceptionTypes[this.nExceptionTypes - 1] = exceptionType;
        }

        @Override
        public List<SSAInstruction> getAllInstructions() {
            List<SSAInstruction> result = super.getAllInstructions();
            if (this.catchInstruction != null) {
                result.add(0, this.catchInstruction);
            }
            return result;
        }
    }

    public class BasicBlock
    implements ISSABasicBlock {
        private final int number;
        private SSAPhiInstruction[] stackSlotPhis;
        private SSAPhiInstruction[] localPhis;
        private static final int initialCapacity = 10;
        private final LinkedList<SSAPiInstruction> blockPiInstructions = new LinkedList();

        public BasicBlock(int number) {
            this.number = number;
        }

        @Override
        public int getNumber() {
            return this.number;
        }

        @Override
        public int getFirstInstructionIndex() {
            Object B = SSACFG.this.delegate.getNode(this.number);
            return B.getFirstInstructionIndex();
        }

        @Override
        public boolean isCatchBlock() {
            return SSACFG.this.delegate.getCatchBlocks().get(this.getNumber());
        }

        @Override
        public int getLastInstructionIndex() {
            Object B = SSACFG.this.delegate.getNode(this.number);
            return B.getLastInstructionIndex();
        }

        @Override
        public Iterator<SSAPhiInstruction> iteratePhis() {
            this.compressPhis();
            if (this.stackSlotPhis == null) {
                if (this.localPhis == null) {
                    return EmptyIterator.instance();
                }
                LinkedList<SSAPhiInstruction> result = new LinkedList<SSAPhiInstruction>();
                for (SSAPhiInstruction phi : this.localPhis) {
                    if (phi == null) continue;
                    result.add(phi);
                }
                return result.iterator();
            }
            LinkedList<SSAPhiInstruction> result = new LinkedList<SSAPhiInstruction>();
            for (SSAPhiInstruction phi : this.stackSlotPhis) {
                if (phi == null) continue;
                result.add(phi);
            }
            if (this.localPhis == null) {
                return result.iterator();
            }
            for (SSAPhiInstruction phi : this.localPhis) {
                if (phi == null) continue;
                result.add(phi);
            }
            return result.iterator();
        }

        public SSAPhiInstruction getPhiForStackSlot(int slot) {
            if (this.stackSlotPhis == null) {
                return null;
            }
            if (slot >= this.stackSlotPhis.length) {
                return null;
            }
            return this.stackSlotPhis[slot];
        }

        public SSAPhiInstruction getPhiForLocal(int n) {
            if (this.localPhis == null) {
                return null;
            }
            if (n >= this.localPhis.length) {
                return null;
            }
            return this.localPhis[n];
        }

        public void addPhiForStackSlot(int slot, SSAPhiInstruction phi) {
            if (this.stackSlotPhis == null) {
                this.stackSlotPhis = new SSAPhiInstruction[10];
            }
            if (slot >= this.stackSlotPhis.length) {
                SSAPhiInstruction[] temp = this.stackSlotPhis;
                this.stackSlotPhis = new SSAPhiInstruction[slot * 2];
                System.arraycopy(temp, 0, this.stackSlotPhis, 0, temp.length);
            }
            this.stackSlotPhis[slot] = phi;
        }

        public void addPhiForLocal(int n, SSAPhiInstruction phi) {
            if (this.localPhis == null) {
                this.localPhis = new SSAPhiInstruction[10];
            }
            if (n >= this.localPhis.length) {
                SSAPhiInstruction[] temp = this.localPhis;
                this.localPhis = new SSAPhiInstruction[n * 2];
                System.arraycopy(temp, 0, this.localPhis, 0, temp.length);
            }
            this.localPhis[n] = phi;
        }

        public void removePhis(Set<SSAPhiInstruction> toRemove) {
            int i;
            int j;
            SSAPhiInstruction[] old;
            int newLength;
            int i2;
            int nRemoved = 0;
            if (this.stackSlotPhis != null) {
                for (i2 = 0; i2 < this.stackSlotPhis.length; ++i2) {
                    if (!toRemove.contains(this.stackSlotPhis[i2])) continue;
                    this.stackSlotPhis[i2] = null;
                    ++nRemoved;
                }
            }
            if (nRemoved > 0) {
                newLength = this.stackSlotPhis.length - nRemoved;
                if (newLength == 0) {
                    this.stackSlotPhis = null;
                } else {
                    old = this.stackSlotPhis;
                    this.stackSlotPhis = new SSAPhiInstruction[newLength];
                    j = 0;
                    for (i = 0; i < old.length; ++i) {
                        if (old[i] == null) continue;
                        this.stackSlotPhis[j++] = old[i];
                    }
                }
            }
            nRemoved = 0;
            if (this.localPhis != null) {
                for (i2 = 0; i2 < this.localPhis.length; ++i2) {
                    if (!toRemove.contains(this.localPhis[i2])) continue;
                    this.localPhis[i2] = null;
                    ++nRemoved;
                }
            }
            if (nRemoved > 0) {
                newLength = this.localPhis.length - nRemoved;
                if (newLength == 0) {
                    this.localPhis = null;
                } else {
                    old = this.localPhis;
                    this.localPhis = new SSAPhiInstruction[newLength];
                    j = 0;
                    for (i = 0; i < old.length; ++i) {
                        if (old[i] == null) continue;
                        this.localPhis[j++] = old[i];
                    }
                }
            }
        }

        public SSAPiInstruction getPiForRefAndPath(int n, Object path) {
            return (SSAPiInstruction)SSACFG.this.piInstructions.get(new RefPathKey(n, this, path));
        }

        public void addPiForRefAndPath(int n, Object path, SSAPiInstruction pi) {
            SSACFG.this.piInstructions.put(new RefPathKey(n, this, path), pi);
            this.blockPiInstructions.add(pi);
        }

        @Override
        public Iterator<SSAPiInstruction> iteratePis() {
            return this.blockPiInstructions.iterator();
        }

        public Iterator<SSAInstruction> iterateNormalInstructions() {
            int lookup;
            final int end = this.getLastInstructionIndex();
            for (lookup = this.getFirstInstructionIndex(); lookup <= end && SSACFG.this.instructions[lookup] == null; ++lookup) {
            }
            final int dummy = lookup;
            return new Iterator<SSAInstruction>(){
                private int start;
                {
                    this.start = dummy;
                }

                @Override
                public boolean hasNext() {
                    return this.start <= end;
                }

                @Override
                public SSAInstruction next() {
                    SSAInstruction i = SSACFG.this.instructions[this.start];
                    ++this.start;
                    while (this.start <= end && SSACFG.this.instructions[this.start] == null) {
                        ++this.start;
                    }
                    return i;
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public List<SSAInstruction> getAllInstructions() {
            this.compressPhis();
            ArrayList<SSAInstruction> result = new ArrayList<SSAInstruction>();
            Iterator<SSAPhiInstruction> it = this.iteratePhis();
            while (it.hasNext()) {
                result.add(it.next());
            }
            for (int i = this.getFirstInstructionIndex(); i <= this.getLastInstructionIndex(); ++i) {
                SSAInstruction s = SSACFG.this.instructions[i];
                if (s == null) continue;
                result.add(s);
            }
            Iterator<SSAPiInstruction> it2 = this.iteratePis();
            while (it2.hasNext()) {
                result.add(it2.next());
            }
            return result;
        }

        private void compressPhis() {
            int i;
            int j;
            SSAPhiInstruction[] old;
            int size;
            if (this.stackSlotPhis != null && this.stackSlotPhis[this.stackSlotPhis.length - 1] == null) {
                size = this.countNonNull(this.stackSlotPhis);
                if (size == 0) {
                    this.stackSlotPhis = null;
                } else {
                    old = this.stackSlotPhis;
                    this.stackSlotPhis = new SSAPhiInstruction[size];
                    j = 0;
                    for (i = 0; i < old.length; ++i) {
                        if (old[i] == null) continue;
                        this.stackSlotPhis[j++] = old[i];
                    }
                }
            }
            if (this.localPhis != null && this.localPhis[this.localPhis.length - 1] == null) {
                size = this.countNonNull(this.localPhis);
                if (size == 0) {
                    this.localPhis = null;
                } else {
                    old = this.localPhis;
                    this.localPhis = new SSAPhiInstruction[size];
                    j = 0;
                    for (i = 0; i < old.length; ++i) {
                        if (old[i] == null) continue;
                        this.localPhis[j++] = old[i];
                    }
                }
            }
        }

        private int countNonNull(SSAPhiInstruction[] a) {
            int result = 0;
            for (int i = 0; i < a.length; ++i) {
                if (a[i] == null) continue;
                ++result;
            }
            return result;
        }

        @Override
        public Iterator<SSAInstruction> iterator() {
            return this.getAllInstructions().iterator();
        }

        public boolean hasPhi() {
            return this.stackSlotPhis != null || this.localPhis != null;
        }

        public int getGraphNodeId() {
            return this.number;
        }

        public void setGraphNodeId(int number) {
        }

        public String toString() {
            return "BB[SSA:" + this.getFirstInstructionIndex() + ".." + this.getLastInstructionIndex() + "]" + this.getNumber() + " - " + SSACFG.this.method.getSignature();
        }

        private SSACFG getGraph() {
            return SSACFG.this;
        }

        public boolean equals(Object arg0) {
            if (arg0 instanceof BasicBlock) {
                BasicBlock b = (BasicBlock)arg0;
                if (this.getNumber() == b.getNumber()) {
                    if (this.getMethod().equals(b.getMethod())) {
                        return this.getGraph().equals(b.getGraph());
                    }
                    return false;
                }
                return false;
            }
            return false;
        }

        @Override
        public IMethod getMethod() {
            return SSACFG.this.method;
        }

        public int hashCode() {
            return SSACFG.this.delegate.getNode(this.getNumber()).hashCode() * 6271;
        }

        @Override
        public boolean isExitBlock() {
            return this == SSACFG.this.exit();
        }

        @Override
        public boolean isEntryBlock() {
            return this == SSACFG.this.entry();
        }

        @Override
        public SSAInstruction getLastInstruction() {
            return SSACFG.this.instructions[this.getLastInstructionIndex()];
        }

        @Override
        public Iterator<TypeReference> getCaughtExceptionTypes() {
            return EmptyIterator.instance();
        }
    }

    private static class RefPathKey {
        private final int n;
        private final Object src;
        private final Object path;

        RefPathKey(int n, Object src, Object path) {
            this.n = n;
            this.src = src;
            this.path = path;
        }

        public int hashCode() {
            return this.n * this.path.hashCode();
        }

        public boolean equals(Object x) {
            return x instanceof RefPathKey && this.n == ((RefPathKey)x).n && this.src == ((RefPathKey)x).src && this.path == ((RefPathKey)x).path;
        }
    }
}

