/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.classLoader.IMethod;
import com.ibm.wala.ipa.callgraph.Context;
import com.ibm.wala.ipa.callgraph.impl.Everywhere;
import com.ibm.wala.ssa.AuxiliaryCache;
import com.ibm.wala.ssa.DefUse;
import com.ibm.wala.ssa.IR;
import com.ibm.wala.ssa.IRFactory;
import com.ibm.wala.ssa.SSAOptions;

public class SSACache {
    private static final boolean DISABLE = false;
    private final IRFactory<IMethod> factory;
    private final AuxiliaryCache irCache = new AuxiliaryCache();
    private final AuxiliaryCache duCache = new AuxiliaryCache();

    public SSACache(IRFactory<IMethod> factory) {
        this.factory = factory;
    }

    public synchronized IR findOrCreateIR(IMethod m, Context c, SSAOptions options) {
        IR ir;
        if (m == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (m.isAbstract() || m.isNative()) {
            return null;
        }
        if (this.factory.contextIsIrrelevant(m)) {
            c = Everywhere.EVERYWHERE;
        }
        if ((ir = (IR)this.irCache.find(m, c, options)) == null) {
            ir = this.factory.makeIR(m, c, options);
            this.irCache.cache(m, c, options, ir);
        }
        return ir;
    }

    public synchronized DefUse findOrCreateDU(IMethod m, Context c, SSAOptions options) {
        DefUse du;
        if (m == null) {
            throw new IllegalArgumentException("m is null");
        }
        if (m.isAbstract() || m.isNative()) {
            return null;
        }
        if (this.factory.contextIsIrrelevant(m)) {
            c = Everywhere.EVERYWHERE;
        }
        if ((du = (DefUse)this.duCache.find(m, c, options)) == null) {
            IR ir = this.findOrCreateIR(m, c, options);
            du = new DefUse(ir);
            this.duCache.cache(m, c, options, du);
        }
        return du;
    }

    public synchronized DefUse findOrCreateDU(IR ir, Context C) {
        if (ir == null) {
            throw new IllegalArgumentException("ir is null");
        }
        DefUse du = (DefUse)this.duCache.find(ir.getMethod(), C, ir.getOptions());
        if (du == null) {
            du = new DefUse(ir);
            this.duCache.cache(ir.getMethod(), C, ir.getOptions(), du);
        }
        return du;
    }

    public void wipe() {
        this.irCache.wipe();
        this.duCache.wipe();
    }

    public void invalidateIR(IMethod method, Context c) {
        this.irCache.invalidate(method, c);
    }

    public void invalidateDU(IMethod method, Context c) {
        this.duCache.invalidate(method, c);
    }

    public void invalidate(IMethod method, Context c) {
        this.invalidateIR(method, c);
        this.invalidateDU(method, c);
    }
}

