/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.ssa;

import com.ibm.wala.ssa.SSAInstruction;
import com.ibm.wala.ssa.SSAInstructionFactory;
import com.ibm.wala.ssa.SymbolTable;
import com.ibm.wala.types.TypeReference;

public class SSAInstanceofInstruction
extends SSAInstruction {
    private final int result;
    private final int ref;
    private final TypeReference checkedType;

    public SSAInstanceofInstruction(int iindex, int result, int ref, TypeReference checkedType) {
        super(iindex);
        this.result = result;
        this.ref = ref;
        this.checkedType = checkedType;
    }

    @Override
    public SSAInstruction copyForSSA(SSAInstructionFactory insts, int[] defs, int[] uses) {
        if (defs != null && defs.length == 0) {
            throw new IllegalArgumentException("defs.length == 0");
        }
        if (uses != null && uses.length == 0) {
            throw new IllegalArgumentException("uses.length == 0");
        }
        return insts.InstanceofInstruction(this.iindex, defs == null || defs.length == 0 ? this.result : defs[0], uses == null ? this.ref : uses[0], this.checkedType);
    }

    @Override
    public String toString(SymbolTable symbolTable) {
        return this.getValueString(symbolTable, this.result) + " = instanceof " + this.getValueString(symbolTable, this.ref) + " " + this.checkedType;
    }

    @Override
    public void visit(SSAInstruction.IVisitor v) throws NullPointerException {
        v.visitInstanceof(this);
    }

    @Override
    public boolean hasDef() {
        return true;
    }

    @Override
    public int getDef() {
        return this.result;
    }

    @Override
    public int getDef(int i) {
        assert (i == 0);
        return this.result;
    }

    public TypeReference getCheckedType() {
        return this.checkedType;
    }

    @Override
    public int getNumberOfDefs() {
        return 1;
    }

    @Override
    public int getNumberOfUses() {
        return 1;
    }

    @Override
    public int getUse(int j) {
        assert (j == 0);
        return this.ref;
    }

    @Override
    public int hashCode() {
        return this.ref * 677 ^ this.result * 3803;
    }

    @Override
    public boolean isFallThrough() {
        return true;
    }

    public int getRef() {
        return this.ref;
    }
}

