/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.common.eclipse.readers;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.eclipse.Messages;
import com.ibm.appscan.common.eclipse.handlers.JavaProjectHandler;
import com.ibm.appscan.common.eclipse.readers.AbstractReader;
import com.ibm.appscan.common.logging.Message;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.JavaModelException;

public class JavaProjectReader
extends AbstractReader {
    private JavaProjectHandler m_handler;

    public JavaProjectReader(String project) {
        this.m_handler = new JavaProjectHandler(project);
    }

    @Override
    public void read() {
        if (this.m_handler.projectExists()) {
            try {
                this.m_handler.openProject();
                this.setProperty("additional_classpath", this.m_handler.getClasspath());
                this.setProperty("output_dir", this.m_handler.getOutputDir());
                this.setProperty("web_content", this.m_handler.getWebContent());
                this.setProperty("jdk_path", this.m_handler.getJDK());
                this.setProperty("src_root", this.m_handler.getSourceRoots());
            }
            catch (JavaModelException e) {
                CommonCore.getLogManager().log(new Message(Messages.getMessage("read.project.error", new Object[0]), (Throwable)e));
            }
            catch (CoreException e) {
                CommonCore.getLogManager().log(new Message(Messages.getMessage("read.project.error", new Object[0]), (Throwable)e));
            }
        }
    }
}

