/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.thirdpartylib.dependency.golang;

import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GoDependency {
    private static final String REGEX = "v([0-9]+)\\.([0-9]+)\\.([0-9]+)(-[0-9]+)?(-[0-9a-zA-Z]+)?";
    private String m_name;
    private String m_latestVersion;
    private int m_latestMajor = 0;
    private int m_latestMinor = 0;
    private int m_latestPatch = 0;
    private long m_latestBuild = 0L;
    private Collection<String> m_versions;

    public GoDependency(String name, String version) {
        this.m_name = name;
        this.m_versions = new ArrayList<String>();
        this.m_latestVersion = version;
        this.addVersion(version);
    }

    public String getName() {
        return this.m_name;
    }

    public String getLatestVersion() {
        return this.m_latestVersion;
    }

    public boolean hasVersion(String version) {
        return this.m_versions.contains(version);
    }

    public void addVersion(String version) {
        try {
            Pattern pattern = Pattern.compile(REGEX, 2);
            Matcher matcher = pattern.matcher(version);
            if (matcher.matches()) {
                long build;
                int major = Integer.parseInt(matcher.group(1));
                int minor = Integer.parseInt(matcher.group(2));
                int patch = Integer.parseInt(matcher.group(3));
                long l = build = matcher.group(4) == null ? 0L : Long.parseLong(matcher.group(4).substring(1));
                if (major < this.m_latestMajor) {
                    this.m_versions.add(version);
                    return;
                }
                if (major > this.m_latestMajor) {
                    this.updateLatest(version, major, minor, patch, build);
                } else {
                    if (minor < this.m_latestMinor) {
                        this.m_versions.add(version);
                        return;
                    }
                    if (minor > this.m_latestMinor) {
                        this.updateLatest(version, major, minor, patch, build);
                    } else {
                        if (patch < this.m_latestPatch) {
                            this.m_versions.add(version);
                            return;
                        }
                        if (patch > this.m_latestPatch) {
                            this.updateLatest(version, major, minor, patch, build);
                        } else {
                            if (build < this.m_latestBuild) {
                                this.m_versions.add(version);
                                return;
                            }
                            if (build > this.m_latestBuild) {
                                this.updateLatest(version, major, minor, patch, build);
                            }
                        }
                    }
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        this.m_versions.add(version);
    }

    private void updateLatest(String version, int major, int minor, int patch, long build) {
        this.m_latestVersion = version;
        this.m_latestMajor = major;
        this.m_latestMinor = minor;
        this.m_latestPatch = patch;
        this.m_latestBuild = build;
    }
}

