/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.thirdpartylib.dependency.golang;

import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.utils.IOUtil;
import com.ibm.appscan.discovery.thirdpartylib.Messages;
import com.ibm.appscan.discovery.thirdpartylib.dependency.IDependencyCollector;
import com.ibm.appscan.discovery.thirdpartylib.dependency.golang.GoDependency;
import com.ibm.appscan.discovery.thirdpartylib.dependency.golang.GoDependencyProcessor;
import com.ibm.appscan.discovery.thirdpartylib.dependency.golang.IGoConstants;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GoDependencyCollector
implements IDependencyCollector {
    private static Map<String, GoDependency> m_downloadedPackages = new HashMap<String, GoDependency>();
    private File m_goMod;
    private ILogManager m_log;

    public GoDependencyCollector(File goMod, ILogManager logManager) {
        this.m_goMod = goMod;
        this.m_log = logManager;
    }

    @Override
    public String getExecutableName() {
        return "Go".toLowerCase();
    }

    @Override
    public String getStagingDirectoryName() {
        return this.getExecutableName();
    }

    @Override
    public File getWorkingDirectory() {
        return this.m_goMod.getParentFile();
    }

    @Override
    public String getToolName() {
        return "Go";
    }

    @Override
    public Map<File, String> getDependencies(File location, String name) throws IOException {
        HashMap<File, String> files = new HashMap<File, String>();
        this.runCommand(Arrays.asList(IGoConstants.GO_CLEAN), null);
        File getUFile = new File(location, name + "_get_u.txt");
        this.runCommand(Arrays.asList(IGoConstants.GO_BUILD), getUFile);
        files.put(getUFile, this.m_goMod.getAbsolutePath());
        this.processDownloadedPackages(getUFile);
        File outputFile = new File(location, name + "_go.mod");
        this.runCommand(Arrays.asList(IGoConstants.GO_LIST), outputFile);
        files.put(outputFile, this.m_goMod.getAbsolutePath());
        GoDependencyProcessor processor = new GoDependencyProcessor(outputFile, location, this.m_log);
        files.putAll(processor.processDependencies());
        GoDependencyProcessor.clearProcessedPackages();
        m_downloadedPackages.clear();
        return files;
    }

    @Override
    public boolean isToolInstalled() {
        ArrayList<String> args = new ArrayList<String>();
        args.add("Version".toLowerCase());
        try {
            return this.run(args, null) == 0;
        }
        catch (IOException e) {
            this.m_log.log((Exception)e);
            return false;
        }
    }

    @Override
    public boolean shouldProcessDependencies() {
        for (File parent = this.m_goMod.getParentFile(); parent != null; parent = parent.getParentFile()) {
            if (!parent.getName().equalsIgnoreCase("pkg")) continue;
            return false;
        }
        return true;
    }

    public static Map<String, GoDependency> getDownloadedPackages() {
        return m_downloadedPackages;
    }

    private void runCommand(List<String> args, File out) throws IOException {
        if (this.run(args, out) != 0) {
            throw new IOException(Messages.getMessage("err.run.command", this.getExecutableName() + " " + args.get(0)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processDownloadedPackages(File getUFile) throws IOException {
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(getUFile));
            String line = reader.readLine();
            while (line != null) {
                String[] parts = line.split(" ");
                if (parts.length == 4) {
                    String path = parts[2].trim();
                    String version = parts[3].trim();
                    if (m_downloadedPackages.containsKey(path)) {
                        m_downloadedPackages.get(path).addVersion(version);
                    } else {
                        m_downloadedPackages.put(path, new GoDependency(path, version));
                    }
                }
                line = reader.readLine();
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(reader);
            throw throwable;
        }
        IOUtil.close((Closeable)reader);
    }
}

