/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.appscan.discovery.thirdpartylib.utils;

import com.ibm.appscan.common.CommonCore;
import com.ibm.appscan.common.logging.ILogManager;
import com.ibm.appscan.common.logging.Message;
import com.ibm.appscan.common.utils.FileUtil;
import com.ibm.appscan.discovery.thirdpartylib.Messages;
import com.ibm.appscan.discovery.thirdpartylib.utils.ProcessUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ThirdPartyLibUtils {
    private static final String[] supportedBinaryExtensions = new String[]{"jar", "war", "ear", "aar", "dll", "exe", "targz", "egg", "whl", "rpm", "drpm", "tarbz2", "tgz", "deb", "udeb", "gzip", "gem", "swf", "swc", "so", "ko", "a", "ar", "dmg", "msi", "air", "apk"};
    private static final String[] supportedSourceExtensions = new String[]{"c", "cc", "css", "cp", "cpp", "cxx", "c++", "go", "goc", "h", "hh", "json", "pch", "h++", "hpp", "hxx", "m", "md", "mm", "scss", "ts", "c#", "cs", "csharp", "js", "php", "py", "pyd", "rb", "swift", "clj", "cljx", "cljs"};
    private static final String[] compressionZipExtensions = new String[]{"war", "ear", "jar"};
    private static final String[] configFiles = new String[]{"pom.xml", "build.gradle", "build.gradle.kts", "package.json", "composer.json", "go.mod", "requirements.txt", "setup.py", "pyproject.toml", "conanfile.txt", "conanfile.py"};
    private static final String[] configFilesExtensions = new String[]{"sln", "csproj", "vbproj", "vcxproj"};

    public static final boolean isZipCompressionExtension(String path) {
        return Arrays.asList(compressionZipExtensions).contains(FileUtil.getFileExtension((String)path));
    }

    public static boolean isSupportedExtension(String path) {
        return ThirdPartyLibUtils.isSupportedBinaryExtension(path) || ThirdPartyLibUtils.isSupportedSourceExtension(path);
    }

    public static boolean isSupportedBinaryExtension(String path) {
        return Arrays.asList(supportedBinaryExtensions).contains(FileUtil.getFileExtension((String)path));
    }

    public static boolean isSupportedSourceExtension(String path) {
        return Arrays.asList(supportedSourceExtensions).contains(FileUtil.getFileExtension((String)path));
    }

    public static boolean isSupportedConfigFile(File file) {
        return Arrays.asList(configFiles).contains(file.getName().toLowerCase()) || Arrays.asList(configFilesExtensions).contains(FileUtil.getFileExtension((File)file));
    }

    public static void deleteDir(File dir) {
        File[] allFiles = dir.listFiles();
        if (allFiles != null) {
            for (File file : allFiles) {
                ThirdPartyLibUtils.deleteDir(file);
            }
        }
        dir.delete();
    }

    public static void restoreAllConfigFiles(List<File> configList, String backupConfigFile) throws IOException {
        for (File file : configList) {
            backupConfigFile = file + ".APPSCAN_BAK";
            if (!new File(backupConfigFile).isFile()) continue;
            Files.delete(Paths.get(file.toString(), new String[0]));
            Files.move(Paths.get(backupConfigFile, new String[0]), Paths.get(file.toString(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
        }
    }

    public static List<File> findAllConfigFiles(File dir, List<File> configList, String configFile) {
        File[] files = null;
        List<File> configFilesList = configList;
        if (dir.isDirectory()) {
            files = dir.listFiles();
        }
        if (files == null) {
            return configFilesList;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                configFilesList = ThirdPartyLibUtils.findAllConfigFiles(file, configFilesList, configFile);
                continue;
            }
            if (!file.isFile() || !file.getName().toLowerCase().equals(configFile)) continue;
            configFilesList.add(file);
        }
        return configFilesList;
    }

    public static void createTrivyStagingDir(File location, ILogManager log) throws IOException {
        if (!location.isDirectory() && !location.mkdirs()) {
            log.log(new Message(1, Messages.getMessage("staging.creation.error", new Object[0])));
            throw new IOException(Messages.getMessage("staging.creation.error", new Object[0]));
        }
    }

    public static Map<File, String> runTrivyAndCollectOutputFile(File location, String outputFile, File configFile, boolean shouldRunTrivy, ILogManager log) {
        HashMap<File, String> files = new HashMap<File, String>();
        List<String> args = ThirdPartyLibUtils.getTrivyArgs(location, configFile, outputFile);
        if (shouldRunTrivy) {
            try {
                log.log(new Message(1, Messages.getMessage("executing.trivy.command", new Object[0])));
                ProcessUtils.run(ThirdPartyLibUtils.getTrivyExe(), args, null);
            }
            catch (IOException e) {
                log.log((Exception)e);
            }
            files.put(new File(location, outputFile), configFile.getAbsolutePath());
        } else {
            log.log(new Message(1, Messages.getMessage("skipping.trivy.command", new Object[0])));
        }
        return files;
    }

    public static List<String> getTrivyArgs(File location, File configFile, String outputFile) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("fs");
        args.add("--format");
        args.add("cyclonedx");
        args.add("--offline-scan");
        args.add("\"" + ThirdPartyLibUtils.getRootLocation(location) + "\"");
        args.add(">");
        args.add("\"" + new File(location, outputFile).toString() + "\"");
        return args;
    }

    public static List<String> getTrivyConfigArgs(File location, File configFile, String outputFile) {
        ArrayList<String> args = new ArrayList<String>();
        args.add("fs");
        args.add("--format");
        args.add("cyclonedx");
        args.add("--offline-scan");
        args.add("\"" + configFile.getAbsolutePath() + "\"");
        args.add(">");
        args.add("\"" + new File(location, outputFile).toString() + "\"");
        return args;
    }

    public static String getTrivyExe() {
        return new File(new File(CommonCore.getDirectoryLocator().getProductRoot(), "bin"), "trivy").toString();
    }

    public static File getRootLocation(File location) {
        File path = location;
        for (int i = 0; i < 4 && path != null; path = path.getParentFile(), ++i) {
        }
        return path;
    }
}

