/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton;

import com.ibm.wala.automaton.Counter;
import com.ibm.wala.util.MonitorUtil;
import com.ibm.wala.util.NullProgressMonitor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AUtil {
    public static String tmpDir = System.getProperty("com.ibm.wala.stringAnalysis.tmpDir", "C:/tmp");
    public static final boolean DEBUG = Boolean.getBoolean("com.ibm.wala.stringAnalysis.debug");
    private static IDebugPrinter debugPrinter = new DefaultDebugPrinter();
    public static final MonitorUtil.IProgressMonitor nullProgressMonitor = new NullProgressMonitor();
    public static String lineSeparator = System.getProperty("line.separator");

    public static void setDebugPrinter(IDebugPrinter printer) {
        debugPrinter = printer;
    }

    public static IDebugPrinter getDebugPrinter() {
        return debugPrinter;
    }

    public static void println(Object o) {
        if (DEBUG) {
            debugPrinter.println(o.toString());
        }
    }

    public static void print(Object o) {
        if (DEBUG) {
            debugPrinter.print(o.toString());
        }
    }

    public static <T> Collection<T> collection(Collection<T> c, T[] objs) throws InstantiationException, IllegalAccessException {
        for (int i = 0; i < objs.length; ++i) {
            c.add(objs[i]);
        }
        return c;
    }

    public static <T> Collection<T> collection(Collection<T> c, Iterator<T> iter) throws InstantiationException, IllegalAccessException {
        while (iter.hasNext()) {
            c.add(iter.next());
        }
        return c;
    }

    public static <T> List<T> list(T ... objs) {
        try {
            return (List)AUtil.collection(new ArrayList(), objs);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> List<T> list(Iterator<T> i) {
        try {
            return (List)AUtil.collection(new ArrayList(), i);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <T> Set<T> set(T ... objs) {
        try {
            return (Set)AUtil.collection(new HashSet(), objs);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
            return null;
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> Set<T> set(Iterator<T> i) {
        try {
            return (Set)AUtil.collection(new HashSet(), i);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static <K, V> Map<K, V> map(K[] keys, V[] vals) {
        HashMap<K, V> m = new HashMap<K, V>();
        for (int i = 0; i < keys.length; ++i) {
            if (i < vals.length) {
                m.put(keys[i], vals[i]);
                continue;
            }
            m.put(keys[i], null);
        }
        return m;
    }

    public static <T> Set<List<T>> allOrder(Set<T> s) {
        return AUtil.allOrder(new ArrayList<T>(s));
    }

    public static <T> Set<List<T>> allOrder(List<T> l) {
        if (l.isEmpty()) {
            return new HashSet<List<T>>();
        }
        T hd = l.get(0);
        l.remove(0);
        Set<List<T>> comb = AUtil.insertAll(hd, AUtil.allOrder(l));
        return comb;
    }

    public static <T> Set<List<T>> allSequence(List<T> l) {
        Set<List<T>> tmp = AUtil.allOrder(l);
        HashSet<List<T>> result = new HashSet<List<T>>();
        for (List<T> t : tmp) {
            int size = t.size();
            for (int i = 0; i < size; ++i) {
                result.add(t.subList(0, i + 1));
            }
        }
        return result;
    }

    private static <T> Set<List<T>> insert(T o, List<T> l) {
        HashSet<List<T>> comb = new HashSet<List<T>>();
        int size = l.size();
        for (int i = 0; i <= size; ++i) {
            ArrayList<T> cl = new ArrayList<T>(l);
            cl.add(i, o);
            comb.add(cl);
        }
        return comb;
    }

    private static <T> Set<List<T>> insertAll(T o, Set<List<T>> s) {
        HashSet<List<T>> comb = new HashSet<List<T>>();
        if (s.isEmpty()) {
            comb.addAll(AUtil.insert(o, new ArrayList()));
        } else {
            for (List<T> l : s) {
                comb.addAll(AUtil.insert(o, l));
            }
        }
        return comb;
    }

    public static <T> List<T> sort(Collection<T> collection) {
        ArrayList<T> l = new ArrayList<T>(collection);
        Collections.sort(l, new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        return l;
    }

    public static <T1, T2> List<T2> collect(Collection<? extends T1> collection, IElementMapper<T1, T2> mapper) {
        ArrayList<T2> result = new ArrayList<T2>();
        for (T1 obj1 : collection) {
            T2 obj2 = mapper.map(obj1);
            result.add(obj2);
        }
        return result;
    }

    public static <T> List<T> select(Collection<? extends T> collection, IElementSelector<T> selector) {
        ArrayList<T> result = new ArrayList<T>();
        for (T obj : collection) {
            if (!selector.selected(obj)) continue;
            result.add(obj);
        }
        return result;
    }

    public static String createUniqueName(String prefix, Collection<String> names, Counter counter) {
        long i = counter.getCount();
        String name = (prefix == null ? "n" : prefix) + Long.toString(i);
        while (names.contains(name)) {
            i = counter.incr();
            name = (prefix == null ? "n" : prefix) + Long.toString(i);
        }
        names.add(name);
        return name;
    }

    public static String createUniqueName(String prefix, Collection<String> names) {
        return AUtil.createUniqueName(prefix, names, new Counter(1L));
    }

    public static Object deepCopy(Object obj) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(obj);
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bos.toByteArray()));
            return ois.readObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Collection<T> combination(Iterator<T> i, IConcatenation<T> concat) {
        if (i.hasNext()) {
            T hd = i.next();
            HashSet<T> s = new HashSet<T>();
            s.add(hd);
            for (T e : AUtil.combination(i, concat)) {
                s.add(concat.concat(hd, e));
            }
            return s;
        }
        return Collections.singleton(concat.empty());
    }

    public static <T> Collection<T> combination(Collection<T> c, IConcatenation<T> concat) {
        ArrayList<Collection<T>> lc = new ArrayList<Collection<T>>();
        for (int i = 0; i < c.size(); ++i) {
            lc.add(c);
        }
        Collection<List<T>> ll = AUtil.combination(lc);
        HashSet<T> result = new HashSet<T>();
        for (List<T> l : ll) {
            result.addAll(AUtil.combination(l.iterator(), concat));
        }
        return result;
    }

    public static <T> Collection<List<T>> combination(List<Collection<T>> l, Collection<List<T>> result) {
        if (l.isEmpty()) {
            return result;
        }
        if (result.isEmpty()) {
            Collection<T> elems = l.get(0);
            for (T elem : elems) {
                ArrayList<T> nl = new ArrayList<T>();
                nl.add(elem);
                result.add(nl);
            }
            AUtil.combination(l.subList(1, l.size()), result);
        } else {
            Collection<T> elems = l.get(0);
            HashSet<ArrayList<T>> tmp = new HashSet<ArrayList<T>>();
            for (T elem : elems) {
                for (List<T> nl : result) {
                    ArrayList<T> nl2 = new ArrayList<T>(nl);
                    nl2.add(elem);
                    tmp.add(nl2);
                }
            }
            if (!tmp.isEmpty()) {
                result.clear();
                result.addAll(tmp);
            }
            AUtil.combination(l.subList(1, l.size()), result);
        }
        return result;
    }

    public static <T> Collection<List<T>> combination(List<Collection<T>> l) {
        return AUtil.combination(l, new HashSet<List<T>>());
    }

    public static <T> Collection<List<T>> combination1(List<Collection<T>> l) {
        HashSet<List<T>> h = new HashSet<List<T>>();
        h.add(new ArrayList());
        return AUtil.combination(l, h);
    }

    public static interface IConcatenation<T> {
        public T concat(T var1, T var2);

        public T empty();
    }

    public static interface IElementSelector<T> {
        public boolean selected(T var1);
    }

    public static interface IElementMapper<T1, T2> {
        public T2 map(T1 var1);
    }

    public static class DefaultDebugPrinter
    implements IDebugPrinter {
        private PrintStream out = System.err;

        public DefaultDebugPrinter() {
            if (tmpDir != null) {
                File logFile = new File(tmpDir, "sa.log");
                try {
                    this.out = new PrintStream(new FileOutputStream(logFile));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
        }

        @Override
        public void println(String s) {
            this.out.println(s);
        }

        @Override
        public void print(String s) {
            this.out.println(s);
        }
    }

    public static interface IDebugPrinter {
        public void println(String var1);

        public void print(String var1);
    }
}

