/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.grammar.string;

import com.ibm.wala.automaton.grammar.string.Grammars;
import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.ProductionRule;
import com.ibm.wala.automaton.string.FreshVariableFactory;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolFactory;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.IVariableFactory;
import com.ibm.wala.automaton.string.SimpleVariableFactory;
import com.ibm.wala.automaton.string.Variable;
import com.ibm.wala.util.collections.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TRRegularApproximation {
    private static boolean DEBUG = false;

    public static void approximateToRegular(IContextFreeGrammar cfg) {
        FreshVariableFactory varFactory = new FreshVariableFactory((ISymbolFactory<IVariable>)SimpleVariableFactory.defaultFactory, cfg);
        TRRegularApproximation.approximateToRegular(cfg, varFactory);
    }

    public static void approximateToRegular(IContextFreeGrammar cfg, IVariableFactory<IVariable> varFactory) {
        Set<IVariable> mvars = Grammars.collectMutuallyRecursiveVariables(cfg);
        if (TRRegularApproximation.isLeftLinear(cfg, mvars) || TRRegularApproximation.isRightLinear(cfg, mvars)) {
            return;
        }
        HashSet<IProductionRule> rules = new HashSet<IProductionRule>();
        VarMap vmap = new VarMap(varFactory);
        for (IVariable A : mvars) {
            ProductionRule rule = new ProductionRule(vmap.getVarPrime(A), new ISymbol[0]);
            rules.add(rule);
        }
        for (IProductionRule rule : cfg.getRules()) {
            if (mvars.contains(rule.getLeft())) {
                Set<IProductionRule> rs = TRRegularApproximation.splitRule(rule, mvars, vmap);
                rules.addAll(rs);
                continue;
            }
            rules.add(rule);
        }
        cfg.getRules().clear();
        cfg.getRules().addAll(rules);
    }

    private static Set<IProductionRule> splitRule(IProductionRule rule, Set<IVariable> mvars, VarMap vmap) {
        HashSet<IProductionRule> result = new HashSet<IProductionRule>();
        List<List<ISymbol>> rhss = TRRegularApproximation.splitRight(rule.getRight(), mvars);
        int m = rhss.size() - 1;
        IVariable A = rule.getLeft();
        if (m == 0) {
            List<ISymbol> a0 = rhss.get(0);
            IVariable left = A;
            ArrayList<ISymbol> right = new ArrayList<ISymbol>(a0);
            right.add(vmap.getVarPrime(A));
            ProductionRule r = new ProductionRule(left, right);
            result.add(r);
        } else {
            IVariable BP = null;
            List<ISymbol> a0B = rhss.get(0);
            ArrayList<ISymbol> right = new ArrayList<ISymbol>(a0B);
            ProductionRule r = new ProductionRule(A, right);
            result.add(r);
            BP = vmap.getVarPrime((IVariable)a0B.get(a0B.size() - 1));
            for (int i = 1; i < m; ++i) {
                List<ISymbol> aiB = rhss.get(i);
                IVariable left = BP;
                ArrayList<ISymbol> right2 = new ArrayList<ISymbol>(aiB);
                ProductionRule r2 = new ProductionRule(left, right2);
                result.add(r2);
                BP = vmap.getVarPrime((IVariable)aiB.get(aiB.size() - 1));
            }
            List<ISymbol> am = rhss.get(m);
            IVariable left = BP;
            ArrayList<ISymbol> right3 = new ArrayList<ISymbol>(am);
            right3.add(vmap.getVarPrime(A));
            ProductionRule r3 = new ProductionRule(left, right3);
            result.add(r3);
        }
        return result;
    }

    private static List<List<ISymbol>> splitRight(List<ISymbol> right, Set<IVariable> mvars) {
        ArrayList<ISymbol> l = new ArrayList<ISymbol>();
        ArrayList<List<ISymbol>> result = new ArrayList<List<ISymbol>>();
        for (ISymbol s : right) {
            if (mvars.contains(s)) {
                l.add(s);
                result.add(l);
                l = new ArrayList();
                continue;
            }
            l.add(s);
        }
        result.add(l);
        return result;
    }

    private static boolean isLeftLinear(IContextFreeGrammar cfg, Set<IVariable> mvars) {
        for (IVariable v : mvars) {
            for (IProductionRule rule : cfg.getRules(v)) {
                ISymbol l0;
                List<ISymbol> l = rule.getRight();
                if (l.isEmpty() || mvars.contains(l0 = l.get(0))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isRightLinear(IContextFreeGrammar cfg, Set<IVariable> mvars) {
        for (IVariable v : mvars) {
            for (IProductionRule rule : cfg.getRules(v)) {
                ISymbol l0;
                List<ISymbol> l = rule.getRight();
                if (l.isEmpty() || mvars.contains(l0 = l.get(l.size() - 1))) continue;
                return false;
            }
        }
        return true;
    }

    private static class VarMap {
        private IVariableFactory<IVariable> varFactory;
        private Map<IVariable, IVariable> primeMap;

        public VarMap(IVariableFactory<IVariable> varFactory) {
            this.varFactory = varFactory;
            this.primeMap = new HashMap<IVariable, IVariable>();
        }

        public IVariable createVariable(String name, int idx) {
            if (DEBUG) {
                return new Variable("B" + idx);
            }
            return this.varFactory.createVariable(Grammars.variablePrefix);
        }

        protected IVariable getVar(Map<Pair<IVariable, IVariable>, IVariable> m, IVariable v, IVariable w) {
            Pair vw = Pair.make((Object)v, (Object)w);
            if (m.containsKey(vw)) {
                return m.get(vw);
            }
            IVariable x = this.varFactory.createVariable(Grammars.variablePrefix);
            m.put((Pair<IVariable, IVariable>)vw, x);
            return x;
        }

        public IVariable getVarPrime(IVariable v) {
            if (DEBUG) {
                return new Variable(v.getName() + "'");
            }
            if (this.primeMap.containsKey(v)) {
                return this.primeMap.get(v);
            }
            IVariable x = this.varFactory.createVariable(Grammars.variablePrefix);
            this.primeMap.put(v, x);
            return x;
        }
    }
}

