/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.grammar.tree;

import com.ibm.wala.automaton.AUtil;
import com.ibm.wala.automaton.DMap;
import com.ibm.wala.automaton.grammar.string.Grammars;
import com.ibm.wala.automaton.grammar.string.IGrammar;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.ProductionRule;
import com.ibm.wala.automaton.grammar.tree.IRTLTranslator;
import com.ibm.wala.automaton.grammar.tree.TreeGrammars;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.IStateTransitionSystem;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ITransition;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.tree.CompositeState;
import com.ibm.wala.automaton.tree.IBinaryTree;
import com.ibm.wala.automaton.tree.IBinaryTreeVariable;
import com.ibm.wala.automaton.tree.ITreeTransition;
import com.ibm.wala.automaton.tree.StateBinaryTree;
import com.ibm.wala.automaton.tree.TreeTransition;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public abstract class RTLAbstractTranslator
implements IRTLTranslator {
    private IStateTransitionSystem system;

    protected RTLAbstractTranslator(IStateTransitionSystem system) {
        this.system = system;
    }

    public IStateTransitionSystem getSystem() {
        return this.system;
    }

    protected Set<IProductionRule> translate(IBinaryTreeVariable v, IBinaryTree bt, StateVariable2Name sv2name) {
        Set<ITransition> transitions = this.system.getAcceptTransitions(TreeTransition.createCompositeState(bt), bt);
        HashSet<IProductionRule> rules = new HashSet<IProductionRule>();
        for (ITreeTransition iTreeTransition : transitions) {
            IBinaryTree bt2 = iTreeTransition.transit(bt);
            ProductionRule rule = new ProductionRule((IVariable)v, (ISymbol)bt2);
            rules.add(rule);
        }
        return rules;
    }

    protected Set<IState> getPrimitiveStates() {
        HashSet<IState> states = new HashSet<IState>();
        for (IState s : this.system.getStates()) {
            if (s instanceof CompositeState) {
                CompositeState cs = (CompositeState)s;
                states.addAll(AUtil.set(cs.getStates()));
                continue;
            }
            states.add(s);
        }
        return states;
    }

    protected static class StateVariable2Name
    extends DMap<StateBinaryTree, String> {
        private Collection<String> names;

        public StateVariable2Name(Collection<String> names) {
            this.names = new HashSet<String>(names);
        }

        public StateVariable2Name(IGrammar g) {
            this(Grammars.collectVariableNames(TreeGrammars.collectUsedVariables(g)));
        }

        public String get(StateBinaryTree t) {
            return (String)super.get(t);
        }

        public String get(IState state, IBinaryTreeVariable v) {
            return this.get(new StateBinaryTree(state, v));
        }

        @Override
        public String create(StateBinaryTree key) {
            String vname = AUtil.createUniqueName("N", this.names);
            return vname;
        }
    }
}

