/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.grammar.tree;

import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.ProductionRule;
import com.ibm.wala.automaton.grammar.string.SimpleGrammarCopier;
import com.ibm.wala.automaton.grammar.tree.ITreeGrammar;
import com.ibm.wala.automaton.grammar.tree.RTLAbstractTranslator;
import com.ibm.wala.automaton.grammar.tree.TreeGrammar;
import com.ibm.wala.automaton.grammar.tree.TreeGrammars;
import com.ibm.wala.automaton.string.DeepSymbolCopier;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.tree.BinaryTreeVariable;
import com.ibm.wala.automaton.tree.IBinaryTree;
import com.ibm.wala.automaton.tree.IBinaryTreeVariable;
import com.ibm.wala.automaton.tree.StateBinaryTree;
import com.ibm.wala.automaton.tree.TopDownTreeAutomaton;
import java.util.HashSet;
import java.util.Set;

public class RTLTopDownTranslator
extends RTLAbstractTranslator {
    public RTLTopDownTranslator(TopDownTreeAutomaton automaton) {
        super(automaton);
    }

    @Override
    public ITreeGrammar translate(ITreeGrammar g) {
        g = (ITreeGrammar)g.copy(SimpleGrammarCopier.defaultCopier);
        TreeGrammars.normalize(g);
        HashSet<IProductionRule> rules = new HashSet<IProductionRule>();
        final RTLAbstractTranslator.StateVariable2Name sv2name = new RTLAbstractTranslator.StateVariable2Name(g);
        for (IState state : this.getPrimitiveStates()) {
            for (IProductionRule rule : g.getRules()) {
                StateBinaryTree sv = new StateBinaryTree(state, (IBinaryTree)((Object)rule.getLeft()));
                String vname = sv2name.get(sv);
                if (vname == null) {
                    throw new AssertionError((Object)"should not be null.");
                }
                BinaryTreeVariable v = new BinaryTreeVariable(vname);
                StateBinaryTree bt = new StateBinaryTree(state, (IBinaryTree)rule.getRight(0));
                Set<IProductionRule> rs = this.translate(v, bt, sv2name);
                HashSet<ProductionRule> rs2 = new HashSet<ProductionRule>();
                for (IProductionRule r : rs) {
                    IBinaryTree bt2 = (IBinaryTree)r.getRight(0);
                    bt2 = (IBinaryTree)bt2.copy(new DeepSymbolCopier(){

                        @Override
                        public ISymbol copy(ISymbol s) {
                            if (s instanceof StateBinaryTree) {
                                String vname = sv2name.get((StateBinaryTree)s);
                                return new BinaryTreeVariable(vname);
                            }
                            return super.copy(s);
                        }
                    });
                    rs2.add(new ProductionRule(r.getLeft(), (ISymbol)bt2));
                }
                rules.addAll(rs2);
            }
        }
        IState initState = this.getSystem().getInitialState();
        for (IProductionRule rule : g.getRules()) {
            IBinaryTreeVariable v = (IBinaryTreeVariable)rule.getLeft();
            BinaryTreeVariable bt = new BinaryTreeVariable(sv2name.get(initState, v));
            ProductionRule r = new ProductionRule((IVariable)v, (ISymbol)bt);
            rules.add(r);
        }
        TreeGrammar result = new TreeGrammar((IBinaryTreeVariable)g.getStartSymbol(), rules);
        TreeGrammars.eliminateUselessRules(result);
        return result;
    }
}

