/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.grammar.tree;

import com.ibm.wala.automaton.grammar.string.CFGSymbol;
import com.ibm.wala.automaton.grammar.string.ContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.Grammars;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.IRuleVisitor;
import com.ibm.wala.automaton.grammar.string.ProductionRule;
import com.ibm.wala.automaton.grammar.string.SimpleGrammar;
import com.ibm.wala.automaton.grammar.tree.ITreeGrammar;
import com.ibm.wala.automaton.string.DeepSymbolCopier;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.IValueSymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.Symbol;
import com.ibm.wala.automaton.tree.BinaryTree;
import com.ibm.wala.automaton.tree.BinaryTreeVariable;
import com.ibm.wala.automaton.tree.IBinaryTree;
import com.ibm.wala.automaton.tree.IBinaryTreeVariable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class TreeGrammar
extends SimpleGrammar
implements ITreeGrammar {
    public static VariableReplacer variableReplacer = new VariableReplacer();

    public TreeGrammar(IBinaryTreeVariable startSymbol, IProductionRule[] rules) {
        super((IVariable)startSymbol, rules);
    }

    public TreeGrammar(IBinaryTreeVariable startSymbol, Set<IProductionRule> rules) {
        super((IVariable)startSymbol, rules);
    }

    public TreeGrammar(SimpleGrammar g) {
        this((IBinaryTreeVariable)TreeGrammar.translateVariable(g.getStartSymbol()), TreeGrammar.collectRules(g.getRules()));
    }

    private static ISymbol translateVariable(ISymbol s) {
        if (s instanceof IBinaryTree) {
            return s;
        }
        if (s == null) {
            System.out.println("foo");
        }
        return s.copy(variableReplacer);
    }

    private static Set<IProductionRule> collectRules(Set<IProductionRule> rules) {
        HashSet<IProductionRule> rtgRules = new HashSet<IProductionRule>();
        HashSet<IProductionRule> cfgRules = new HashSet<IProductionRule>();
        for (IProductionRule rule : rules) {
            if (rule.getRight().size() == 1) {
                if (rule.getRight(0) instanceof IBinaryTree) {
                    if (rule.getLeft() instanceof IBinaryTreeVariable) {
                        rtgRules.add(rule);
                        continue;
                    }
                    ProductionRule r = new ProductionRule((IVariable)TreeGrammar.translateVariable(rule.getLeft()), rule.getRight());
                    rtgRules.add(r);
                    continue;
                }
                if (rule.getRight(0) instanceof IVariable) {
                    IVariable v = (IVariable)rule.getRight(0);
                    ProductionRule r = new ProductionRule((IVariable)TreeGrammar.translateVariable(rule.getLeft()), (ISymbol)new BinaryTreeVariable(v));
                    rtgRules.add(r);
                    continue;
                }
                if (rule.getRight(0) instanceof IValueSymbol) {
                    cfgRules.add(rule);
                    continue;
                }
                if (rule.getRight(0) instanceof Symbol) {
                    cfgRules.add(rule);
                    continue;
                }
                throw new RuntimeException("unsupported symbol: " + rule.getRight(0));
            }
            cfgRules.add(rule);
        }
        for (IProductionRule r : cfgRules) {
            ContextFreeGrammar cfg = new ContextFreeGrammar(r.getLeft(), (Collection<IProductionRule>)rules);
            Grammars.eliminateUselessRules(cfg);
            ProductionRule t = new ProductionRule((IVariable)TreeGrammar.translateVariable(r.getLeft()), (ISymbol)new BinaryTree(new CFGSymbol(cfg)));
            rtgRules.add(t);
        }
        return rtgRules;
    }

    @Override
    public SimpleGrammar toSimple() {
        SimpleGrammar g = super.toSimple();
        final HashSet newRules = new HashSet();
        g.traverseRules(new IRuleVisitor(){

            @Override
            public void onVisit(IProductionRule rule) {
                if (rule.getLeft() instanceof IBinaryTreeVariable) {
                    IBinaryTreeVariable btv = (IBinaryTreeVariable)rule.getLeft();
                    newRules.add(new ProductionRule((IVariable)btv, btv.getLabel()));
                    newRules.add(new ProductionRule((IVariable)btv.getLabel(), rule.getRight()));
                } else {
                    newRules.add(rule);
                }
            }
        });
        IVariable startVar = g.getStartSymbol();
        if (startVar instanceof IBinaryTreeVariable) {
            startVar = (IVariable)((IBinaryTreeVariable)startVar).getLabel();
        }
        g = new SimpleGrammar(startVar, newRules);
        return g;
    }

    public static class VariableReplacer
    extends DeepSymbolCopier {
        @Override
        public ISymbol copy(ISymbol symbol) {
            if (symbol instanceof IVariable && !(symbol instanceof IBinaryTreeVariable)) {
                return new BinaryTreeVariable((IVariable)symbol);
            }
            return super.copy(symbol);
        }
    }
}

