/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.grammar.tree;

import com.ibm.wala.automaton.grammar.string.DeepGrammarCopier;
import com.ibm.wala.automaton.grammar.string.DeepRuleCopier;
import com.ibm.wala.automaton.grammar.string.Grammars;
import com.ibm.wala.automaton.grammar.string.IProductionRule;
import com.ibm.wala.automaton.grammar.string.ProductionRule;
import com.ibm.wala.automaton.grammar.string.SimpleRuleCopier;
import com.ibm.wala.automaton.grammar.tree.ITreeGrammar;
import com.ibm.wala.automaton.string.DeepSymbolCopier;
import com.ibm.wala.automaton.string.FreshVariableFactory;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolFactory;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.IVariableFactory;
import com.ibm.wala.automaton.string.SimpleVariableFactory;
import com.ibm.wala.automaton.tree.BinaryTree;
import com.ibm.wala.automaton.tree.BinaryTreeVariableFactory;
import com.ibm.wala.automaton.tree.IBinaryTree;
import com.ibm.wala.automaton.tree.IBinaryTreeVariable;
import com.ibm.wala.automaton.tree.IParentBinaryTree;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class TreeGrammars
extends Grammars {
    public static void normalize(ITreeGrammar g, IVariableFactory<IBinaryTreeVariable> varFactory) {
        ITreeGrammar tmp = (ITreeGrammar)g.copy(new DeepGrammarCopier(new DeepRuleCopier(DeepSymbolCopier.defaultCopier)));
        g.getRules().clear();
        g.getRules().addAll(tmp.getRules());
        TreeGrammars.eliminateUnitRules(g);
        if (varFactory == null) {
            varFactory = new BinaryTreeVariableFactory(new FreshVariableFactory((ISymbolFactory<IVariable>)SimpleVariableFactory.defaultFactory, g));
        }
        IBinaryTreeVariable leafVar = null;
        HashSet<ProductionRule> newRules = new HashSet<ProductionRule>();
        if (leafVar == null) {
            leafVar = (IBinaryTreeVariable)varFactory.createVariable("N");
            ProductionRule r = new ProductionRule((IVariable)leafVar, (ISymbol)BinaryTree.LEAF);
            g.getRules().add(r);
        }
        do {
            newRules.clear();
            for (IProductionRule rule : g.getRules()) {
                IBinaryTree bt = (IBinaryTree)rule.getRight(0);
                if (bt.equals(BinaryTree.LEAF)) continue;
                if (bt instanceof IParentBinaryTree) {
                    ProductionRule r;
                    IBinaryTreeVariable v;
                    IParentBinaryTree pbt = (IParentBinaryTree)bt;
                    if (!(pbt.getLeft() instanceof IBinaryTreeVariable)) {
                        if (pbt.getLeft().equals(BinaryTree.LEAF)) {
                            pbt.setLeft(leafVar);
                        } else {
                            v = (IBinaryTreeVariable)varFactory.createVariable("N");
                            r = new ProductionRule((IVariable)v, (ISymbol)pbt.getLeft());
                            pbt.setLeft(v);
                            newRules.add(r);
                        }
                    }
                    if (pbt.getRight() instanceof IBinaryTreeVariable) continue;
                    if (pbt.getRight().equals(BinaryTree.LEAF)) {
                        pbt.setRight(leafVar);
                        continue;
                    }
                    v = (IBinaryTreeVariable)varFactory.createVariable("N");
                    r = new ProductionRule((IVariable)v, (ISymbol)pbt.getRight());
                    pbt.setRight(v);
                    newRules.add(r);
                    continue;
                }
                throw new RuntimeException("unimplemented yet: " + bt.getClass());
            }
            g.getRules().addAll(newRules);
        } while (!newRules.isEmpty());
    }

    public static void normalize(ITreeGrammar g) {
        TreeGrammars.normalize(g, null);
    }

    public static void reduce(final ITreeGrammar g) {
        for (final IProductionRule rule : g.getRules()) {
            IBinaryTree bt = (IBinaryTree)rule.getRight(0);
            bt = (IBinaryTree)bt.copy(new DeepSymbolCopier(){
                private Set<IVariable> history = new HashSet<IVariable>();
                {
                    this.history.add(rule.getLeft());
                }

                @Override
                public ISymbol copy(ISymbol s) {
                    IProductionRule drule;
                    Set<IProductionRule> drules;
                    if (s instanceof IBinaryTreeVariable && (drules = g.getRules((IBinaryTreeVariable)s)).size() == 1 && !this.history.contains((drule = drules.iterator().next()).getLeft())) {
                        return drule.getRight(0).copy(this);
                    }
                    return super.copy(s);
                }
            });
            rule.getRight().clear();
            rule.getRight().add(bt);
        }
        TreeGrammars.eliminateUselessRules(g);
    }

    public static void append(ITreeGrammar g, IBinaryTree s) {
        TreeGrammars.append(g, s, new BinaryTreeVariableFactory(new FreshVariableFactory((ISymbolFactory<IVariable>)SimpleVariableFactory.defaultFactory, g)));
    }

    public static void append(ITreeGrammar g, IBinaryTree s, IVariableFactory<IBinaryTreeVariable> varFactory) {
        TreeGrammars.normalize(g, varFactory);
        TreeGrammars.appendInternal(g, s, varFactory);
        TreeGrammars.eliminateUselessRules(g);
    }

    protected static void appendInternal(ITreeGrammar g, IBinaryTree s, IVariableFactory<IBinaryTreeVariable> varFactory) {
        HashSet<IProductionRule> newRules = new HashSet<IProductionRule>();
        HashMap<IBinaryTreeVariable, IBinaryTreeVariable> varMap = new HashMap<IBinaryTreeVariable, IBinaryTreeVariable>();
        for (IProductionRule r : g.getRules()) {
            IBinaryTreeVariable v = (IBinaryTreeVariable)r.getLeft();
            IBinaryTreeVariable newVar = null;
            if (varMap.containsKey(v)) {
                newVar = (IBinaryTreeVariable)varMap.get(v);
            } else {
                newVar = varFactory.createVariable(variablePrefix);
                varMap.put(v, newVar);
            }
            final IBinaryTreeVariable newLeft = newVar;
            IProductionRule newRule = r.copy(new DeepRuleCopier(DeepSymbolCopier.defaultCopier){

                @Override
                public IVariable copyLeft(IVariable v) {
                    return newLeft;
                }
            });
            newRules.add(newRule);
        }
        HashSet<IProductionRule> rules = new HashSet<IProductionRule>();
        for (IProductionRule r : newRules) {
            if ((r = r.copy(SimpleRuleCopier.defaultCopier)).getRight(0) instanceof IParentBinaryTree) {
                IParentBinaryTree pbt = (IParentBinaryTree)r.getRight(0);
                IBinaryTreeVariable v = (IBinaryTreeVariable)pbt.getRight();
                if (varMap.containsKey(v)) {
                    pbt.setRight((IBinaryTree)varMap.get(v));
                }
                rules.add(r);
                continue;
            }
            if (r.getRight(0).equals(BinaryTree.LEAF)) {
                r.getRight().clear();
                r.getRight().add(s);
                rules.add(r);
                continue;
            }
            if (r.getRight(0) instanceof IBinaryTreeVariable) continue;
            throw new RuntimeException("unexpected symbol: " + r.getRight(0));
        }
        g.getRules().addAll(rules);
        g.setStartSymbol((IVariable)varMap.get(g.getStartSymbol()));
    }

    public static void append(IBinaryTree bt, IBinaryTree s) {
        if (bt instanceof IParentBinaryTree) {
            IParentBinaryTree pbt = (IParentBinaryTree)bt;
            if (pbt.getRight().equals(BinaryTree.LEAF)) {
                pbt.setRight(s);
            } else {
                TreeGrammars.append(pbt.getRight(), s);
            }
        } else {
            throw new RuntimeException("should not append the tree to the leaf");
        }
    }

    public static void appendChild(ITreeGrammar g, IBinaryTree s) {
        TreeGrammars.appendChild(g, s, new BinaryTreeVariableFactory(new FreshVariableFactory((ISymbolFactory<IVariable>)SimpleVariableFactory.defaultFactory, g)));
    }

    public static void appendChild(ITreeGrammar g, IBinaryTree s, IVariableFactory<IBinaryTreeVariable> varFactory) {
        TreeGrammars.normalize(g, varFactory);
        TreeGrammars.appendChildInternal(g, s, varFactory);
        TreeGrammars.eliminateUselessRules(g);
    }

    protected static void appendChildInternal(ITreeGrammar g, IBinaryTree s, IVariableFactory<IBinaryTreeVariable> varFactory) {
        HashSet<IProductionRule> rules = new HashSet<IProductionRule>();
        IBinaryTreeVariable origStart = (IBinaryTreeVariable)g.getStartSymbol();
        final IBinaryTreeVariable newStart = varFactory.createVariable(variablePrefix);
        for (IProductionRule r : g.getRules(origStart)) {
            IProductionRule newRule = r.copy(new DeepRuleCopier(DeepSymbolCopier.defaultCopier){

                @Override
                public IVariable copyLeft(IVariable v) {
                    return newStart;
                }
            });
            rules.add(newRule);
        }
        for (IProductionRule r : rules) {
            if (!(r.getRight(0) instanceof IParentBinaryTree)) continue;
            IParentBinaryTree pbt = (IParentBinaryTree)r.getRight(0);
            IBinaryTreeVariable v = (IBinaryTreeVariable)pbt.getLeft();
            g.setStartSymbol(v);
            TreeGrammars.appendInternal(g, s, varFactory);
            pbt.setLeft((IBinaryTreeVariable)g.getStartSymbol());
            g.setStartSymbol(origStart);
        }
        g.getRules().addAll(rules);
        g.setStartSymbol(newStart);
    }
}

