/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.regex.string;

import com.ibm.wala.automaton.regex.string.AbstractPattern;
import com.ibm.wala.automaton.regex.string.IPattern;
import com.ibm.wala.automaton.regex.string.IPatternCopier;
import com.ibm.wala.automaton.regex.string.IPatternVisitor;
import com.ibm.wala.automaton.regex.string.SymbolPattern;
import com.ibm.wala.automaton.string.CharSymbol;
import java.util.ArrayList;
import java.util.Collection;

public class UnionPattern
extends AbstractPattern
implements IPattern {
    private IPattern left;
    private IPattern right;

    public static IPattern make(IPattern left, IPattern right) {
        if (left.equals(right)) {
            return left;
        }
        return new UnionPattern(left, right);
    }

    public static IPattern make(Collection<? extends IPattern> patterns) {
        IPattern p = null;
        for (IPattern iPattern : patterns) {
            if (p == null) {
                p = iPattern;
                continue;
            }
            p = UnionPattern.make(p, iPattern);
        }
        return p;
    }

    public static IPattern make(char[] cs) {
        ArrayList<SymbolPattern> patterns = new ArrayList<SymbolPattern>();
        for (int i = 0; i < cs.length; ++i) {
            SymbolPattern p = new SymbolPattern(new CharSymbol(cs[i]));
            patterns.add(p);
        }
        return UnionPattern.make(patterns);
    }

    public UnionPattern(IPattern left, IPattern right) {
        this.left = left;
        this.right = right;
    }

    public IPattern getLeft() {
        return this.left;
    }

    public IPattern getRight() {
        return this.right;
    }

    public int hashCode() {
        return this.left.hashCode() + this.right.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        UnionPattern p = (UnionPattern)obj;
        return this.left.equals(p.getLeft()) && this.right.equals(p.getRight());
    }

    public String toString() {
        return "(" + this.left.toString() + "|" + this.right.toString() + ")";
    }

    @Override
    public void traverse(IPatternVisitor visitor) {
        visitor.onVisit(this);
        this.left.traverse(visitor);
        this.right.traverse(visitor);
        visitor.onLeave(this);
    }

    @Override
    public IPattern copy(IPatternCopier copier) {
        ArrayList<IPattern> l = new ArrayList<IPattern>();
        l.add(this.left.copy(copier));
        l.add(this.right.copy(copier));
        return copier.copy(this, l);
    }
}

