/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.string;

import com.ibm.wala.automaton.AUtil;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.ISTSCopier;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.IStateTransitionSystem;
import com.ibm.wala.automaton.string.IStateVisitor;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ITransition;
import com.ibm.wala.automaton.string.StateTransitionSystem;
import com.ibm.wala.automaton.string.TransitionSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class Automaton
extends StateTransitionSystem
implements IAutomaton {
    private Set<IState> finalStates;

    public Automaton(IState initialState, Collection<IState> finalStates, Collection<ITransition> transitions) {
        super(initialState, transitions);
        this.finalStates = new HashSet<IState>(finalStates);
    }

    public Automaton(IState initialState, IState[] finalStates, ITransition[] transitions) {
        super(initialState, transitions);
        this.finalStates = AUtil.set(finalStates);
    }

    public Automaton(IAutomaton automaton) {
        this(automaton.getInitialState(), automaton.getFinalStates(), automaton.getTransitions());
    }

    public Automaton() {
        this.finalStates = new HashSet<IState>();
    }

    @Override
    public Set<IState> getFinalStates() {
        return this.finalStates;
    }

    @Override
    public Set<IState> getStates() {
        Set<IState> states = super.getStates();
        states.addAll(this.finalStates);
        return states;
    }

    private boolean isFinalState(IState state) {
        return this.getFinalStates().contains(state);
    }

    @Override
    public List<List<ISymbol>> translate(List<? extends ISymbol> symbols) {
        return this.translate(this.getInitialState(), symbols);
    }

    @Override
    public boolean accept(List<? extends ISymbol> symbols) {
        return this.accept(this.getInitialState(), symbols);
    }

    public boolean accept(IState state, List<? extends ISymbol> symbols) {
        return !this.translate(state, symbols).isEmpty();
    }

    protected List<List<ISymbol>> translate(IState state, List<? extends ISymbol> symbols) {
        if (symbols.isEmpty() && this.isFinalState(state)) {
            ArrayList<List<ISymbol>> l = new ArrayList<List<ISymbol>>();
            l.add(new ArrayList());
            return l;
        }
        ArrayList<List<ISymbol>> output = new ArrayList<List<ISymbol>>();
        Set<ITransition> epsilons = this.getEpsilonTransitions(state);
        for (ITransition transition : epsilons) {
            List<List<ISymbol>> results;
            IState positionstate = transition.getPostState();
            if (positionstate.equals(state) || (results = this.translate(positionstate, symbols)) == null) continue;
            for (List<ISymbol> l : results) {
                l.addAll(0, transition.getOutputSymbols());
            }
            output.addAll(results);
        }
        if (symbols.isEmpty()) {
            if (output.isEmpty()) {
                return new ArrayList<List<ISymbol>>();
            }
            return output;
        }
        ArrayList<? extends ISymbol> tail = new ArrayList<ISymbol>(symbols);
        ISymbol symbol = (ISymbol)tail.get(0);
        tail.remove(0);
        Set<ITransition> transitions = this.getAcceptTransitions(state, symbol);
        for (ITransition transition : transitions) {
            List<List<ISymbol>> results = this.translate(transition.getPostState(), tail);
            if (results == null) continue;
            for (List<ISymbol> l : results) {
                l.addAll(0, transition.transit(symbol));
            }
            output.addAll(results);
        }
        return output;
    }

    @Override
    public void traverseStates(IStateVisitor visitor) {
        super.traverseStates(visitor);
        for (IState state : this.getFinalStates()) {
            visitor.onVisit(state);
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            Automaton a = (Automaton)obj;
            return this.finalStates.equals(a.finalStates);
        }
        return false;
    }

    @Override
    public IStateTransitionSystem copy(ISTSCopier copier) {
        Automaton a = (Automaton)super.copy(copier);
        a.finalStates = (Set)copier.copyStates(a.finalStates, new HashSet<IState>());
        return a;
    }

    @Override
    public String toString() {
        StringBuffer transitions = new StringBuffer();
        Iterator<ITransition> i = AUtil.sort(this.getTransitions()).iterator();
        while (i.hasNext()) {
            ITransition t = i.next();
            transitions.append("  ");
            transitions.append(t.toString());
            if (!i.hasNext()) continue;
            transitions.append(AUtil.lineSeparator);
        }
        StringBuffer finalStates = new StringBuffer();
        Iterator<IState> i2 = this.getFinalStates().iterator();
        while (i2.hasNext()) {
            IState state = i2.next();
            finalStates.append(state.toString());
            if (!i2.hasNext()) continue;
            finalStates.append("; ");
        }
        return "{init:" + this.getInitialState() + ", final:{" + finalStates + "}, transitions:{" + AUtil.lineSeparator + transitions + AUtil.lineSeparator + "}}";
    }

    @Override
    public IAutomaton dup() {
        Automaton a = (Automaton)this.clone();
        a.finalStates = new HashSet<IState>(this.finalStates);
        a.transitions = (TransitionSet)a.transitions.clone();
        return a;
    }
}

