/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.string;

import com.ibm.wala.automaton.string.IComparableSymbol;
import com.ibm.wala.automaton.string.IValueSymbol;
import com.ibm.wala.automaton.string.IntSymbol;
import com.ibm.wala.automaton.string.NumberSymbol;
import com.ibm.wala.automaton.string.RealSymbol;

public class BooleanSymbol
extends NumberSymbol
implements IValueSymbol,
IComparableSymbol {
    private final boolean val;

    @Override
    public String getIntegerName() {
        return this.val ? "1" : "0";
    }

    private static int boolToZeroOne(boolean b) {
        return b ? 1 : 0;
    }

    public BooleanSymbol(String bool) {
        this(Boolean.parseBoolean(bool));
    }

    public BooleanSymbol(boolean bool) {
        super(BooleanSymbol.boolToZeroOne(bool));
        this.val = bool;
    }

    @Override
    public Object value() {
        return this.booleanValue();
    }

    public boolean booleanValue() {
        return this.val;
    }

    @Override
    public String getName() {
        return Boolean.toString(this.val);
    }

    @Override
    public IComparableSymbol[] coerce(IComparableSymbol o) throws IComparableSymbol.NotComparableException {
        if (o instanceof IntSymbol) {
            return new IComparableSymbol[]{o, new IntSymbol(this.intValue())};
        }
        if (o instanceof RealSymbol) {
            RealSymbol r = (RealSymbol)o;
            return new IComparableSymbol[]{new IntSymbol(r.intValue()), new IntSymbol(this.intValue())};
        }
        if (o instanceof BooleanSymbol) {
            return new IComparableSymbol[]{o, this};
        }
        if (o instanceof NumberSymbol) {
            NumberSymbol n = (NumberSymbol)o;
            return new IComparableSymbol[]{new IntSymbol(n.intValue()), new IntSymbol(this.intValue())};
        }
        return super.coerce(o);
    }

    @Override
    public int compareTo(IComparableSymbol o) throws IComparableSymbol.NotComparableException {
        if (o instanceof BooleanSymbol) {
            BooleanSymbol b = (BooleanSymbol)o;
            Boolean bVal = (Boolean)b.value();
            Boolean val = (Boolean)this.value();
            return val.compareTo(bVal);
        }
        IComparableSymbol[] s = o.coerce(this);
        return s[0].compareTo(s[1]);
    }
}

