/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.string;

import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ITransition;
import com.ibm.wala.automaton.util.collections.HashMapSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class DoubleTransitionSet
implements Set<ITransition> {
    private HashMapSet<IState, ITransition> pre;
    private HashMapSet<IState, ITransition> post;

    public DoubleTransitionSet() {
        this(Collections.emptySet());
    }

    public DoubleTransitionSet(Collection<? extends ITransition> rules) {
        this.pre = new HashMapSet<IState, ITransition>(rules){

            @Override
            protected IState getKey(ITransition o) {
                return o.getPreState();
            }
        };
        this.post = new HashMapSet<IState, ITransition>(rules){

            @Override
            protected IState getKey(ITransition o) {
                return o.getPostState();
            }
        };
    }

    public Set<ITransition> getPreSet(IState preState) {
        return this.pre.getSet(preState);
    }

    public Set<ITransition> getPostSet(IState postState) {
        return this.post.getSet(postState);
    }

    @Override
    public boolean add(ITransition o) {
        if (this.pre.add(o)) {
            this.post.add(o);
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends ITransition> c) {
        boolean r = false;
        for (ITransition iTransition : c) {
            if (!this.add(iTransition)) continue;
            r = true;
        }
        return r;
    }

    @Override
    public void clear() {
        this.pre.clear();
        this.post.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.pre.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.pre.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.pre.isEmpty();
    }

    @Override
    public Iterator<ITransition> iterator() {
        final Iterator<ITransition> i = this.pre.iterator();
        return new Iterator<ITransition>(){
            ITransition t = null;

            @Override
            public boolean hasNext() {
                return i.hasNext();
            }

            @Override
            public ITransition next() {
                this.t = (ITransition)i.next();
                return this.t;
            }

            @Override
            public void remove() {
                i.remove();
                DoubleTransitionSet.this.post.remove(this.t);
            }
        };
    }

    @Override
    public boolean remove(Object o) {
        if (this.pre.remove(o)) {
            this.post.remove(o);
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean r = false;
        for (Object o : c) {
            if (!this.remove(o)) continue;
            r = true;
        }
        return r;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        if (this.pre.retainAll(c)) {
            this.post.retainAll(c);
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.pre.size();
    }

    @Override
    public Object[] toArray() {
        return this.pre.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.pre.toArray((U[])a);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.pre == null ? 0 : this.pre.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DoubleTransitionSet other = (DoubleTransitionSet)obj;
        return !(this.pre == null ? other.pre != null : !this.pre.equals(other.pre));
    }
}

