/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.string;

import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ITransition;
import com.ibm.wala.util.debug.Assertions;
import com.ibm.wala.util.graph.Graph;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class GraphAdapter
implements Graph<IState> {
    protected final IAutomaton automaton;
    private Map<IState, Integer> predCount = new HashMap<IState, Integer>();
    private Map<IState, Set<IState>> predStates = new HashMap<IState, Set<IState>>();
    private Map<IState, Integer> succCount = new HashMap<IState, Integer>();
    private Map<IState, Set<IState>> succStates = new HashMap<IState, Set<IState>>();

    public GraphAdapter(IAutomaton a) {
        this.automaton = a;
    }

    public void removeNodeAndEdges(IState N) {
        Assertions.UNREACHABLE();
    }

    public void addNode(IState n) {
        Assertions.UNREACHABLE();
    }

    public boolean containsNode(IState N) {
        return this.automaton.getStates().contains(N);
    }

    public int getNumberOfNodes() {
        return this.automaton.getStates().size();
    }

    public Iterator<IState> iterator() {
        return this.automaton.getStates().iterator();
    }

    public void removeNode(IState n) {
        Assertions.UNREACHABLE();
    }

    public void addEdge(IState src, IState dst) {
        Assertions.UNREACHABLE();
    }

    public int getPredNodeCount(IState N) {
        Integer ret = this.predCount.get(N);
        if (ret == null) {
            ret = this.automaton.getPredTransitions(N).size();
            this.predCount.put(N, ret);
        }
        return ret;
    }

    public Iterator<IState> getPredNodes(IState N) {
        Set<IState> s = this.predStates.get(N);
        if (s == null) {
            s = new HashSet<IState>();
            this.predStates.put(N, s);
            Set<ITransition> tr = this.automaton.getPredTransitions(N);
            for (ITransition t : tr) {
                s.add(t.getPreState());
            }
        }
        return s.iterator();
    }

    public int getSuccNodeCount(IState N) {
        Integer ret = this.succCount.get(N);
        if (ret == null) {
            ret = this.automaton.getTransitions(N).size();
            this.succCount.put(N, ret);
        }
        return ret;
    }

    public Iterator<IState> getSuccNodes(IState N) {
        Set<IState> s = this.succStates.get(N);
        if (s == null) {
            s = new HashSet<IState>();
            this.succStates.put(N, s);
            Set<ITransition> tr = this.automaton.getTransitions(N);
            for (ITransition t : tr) {
                s.add(t.getPostState());
            }
        }
        return s.iterator();
    }

    public boolean hasEdge(IState src, IState dst) {
        this.getSuccNodes(src);
        return this.succStates.get(src).contains(dst);
    }

    public void removeAllIncidentEdges(IState node) {
        Assertions.UNREACHABLE();
    }

    public void removeEdge(IState src, IState dst) {
        Assertions.UNREACHABLE();
    }

    public void removeIncomingEdges(IState node) {
        Assertions.UNREACHABLE();
    }

    public void removeOutgoingEdges(IState node) {
        Assertions.UNREACHABLE();
    }
}

