/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.string;

import com.ibm.wala.automaton.grammar.string.IContextFreeGrammar;
import com.ibm.wala.automaton.grammar.string.SingletonGrammar;
import com.ibm.wala.automaton.string.Automatons;
import com.ibm.wala.automaton.string.IAutomaton;
import com.ibm.wala.automaton.string.ICharValueSymbol;
import com.ibm.wala.automaton.string.IComparableSymbol;
import com.ibm.wala.automaton.string.IVariable;
import com.ibm.wala.automaton.string.RealSymbol;
import com.ibm.wala.automaton.string.StringSymbol;
import com.ibm.wala.automaton.string.Symbol;
import com.ibm.wala.automaton.string.Variable;
import java.util.Arrays;

public abstract class NumberSymbol
extends Symbol
implements ICharValueSymbol,
IComparableSymbol {
    protected NumberSymbol(String num) {
        super(num);
    }

    protected NumberSymbol(int num) {
        super(Integer.toString(num));
    }

    protected NumberSymbol(Integer num) {
        super(num.toString());
    }

    protected NumberSymbol(long num) {
        super(Long.toString(num));
    }

    protected NumberSymbol(Long num) {
        super(num.toString());
    }

    protected NumberSymbol(float num) {
        super(Float.toString(num));
    }

    protected NumberSymbol(Float num) {
        super(num.toString());
    }

    protected NumberSymbol(double num) {
        super(Double.toString(num));
    }

    protected NumberSymbol(Double num) {
        super(num.toString());
    }

    public String getIntegerName() {
        String s = this.getName();
        int idx = s.indexOf(46);
        if (idx == 0) {
            return "0";
        }
        if (idx > 0) {
            return s.substring(0, idx);
        }
        return s;
    }

    @Override
    public Object value() {
        return this.doubleValue();
    }

    public int intValue() {
        return Integer.parseInt(this.getIntegerName());
    }

    public long longValue() {
        return Long.parseLong(this.getIntegerName());
    }

    public float floatValue() {
        return Float.parseFloat(this.getName());
    }

    public double doubleValue() {
        return Double.parseDouble(this.getName());
    }

    @Override
    public char charValue() {
        Integer intVal = Integer.parseInt(this.getIntegerName());
        return (char)intVal.intValue();
    }

    @Override
    public byte byteValue() {
        Integer intVal = Integer.parseInt(this.getIntegerName());
        return intVal.byteValue();
    }

    public short shortValue() {
        Integer intVal = Integer.parseInt(this.getIntegerName());
        return intVal.shortValue();
    }

    @Override
    public IComparableSymbol[] coerce(IComparableSymbol o) throws IComparableSymbol.NotComparableException {
        NumberSymbol n = (NumberSymbol)o;
        return new IComparableSymbol[]{new RealSymbol(n.doubleValue()), new RealSymbol(this.doubleValue())};
    }

    @Override
    public StringSymbol stringSymbolValue() {
        return new StringSymbol(this.getName());
    }

    @Override
    public boolean equals(Object obj) {
        if (obj != null && this.getClass().equals(obj.getClass())) {
            try {
                return this.compareTo((IComparableSymbol)obj) == 0;
            }
            catch (IComparableSymbol.NotComparableException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public IContextFreeGrammar getGrammar() {
        return new SingletonGrammar((IVariable)new Variable("NUMBER_SYM#" + this.hashCode()), this);
    }

    @Override
    public IAutomaton getAutomaton() {
        return Automatons.createAutomaton(Arrays.asList(this));
    }
}

