/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.string;

import com.ibm.wala.automaton.string.IMatchContext;
import com.ibm.wala.automaton.string.ISymbol;
import com.ibm.wala.automaton.string.ISymbolCopier;
import com.ibm.wala.automaton.string.ISymbolVisitor;

public class PairSymbol
implements ISymbol {
    public static String DEFAULT_SEPARATOR = ":";
    ISymbol fst;
    ISymbol snd;

    public PairSymbol(ISymbol fst, ISymbol snd) {
        this.fst = fst;
        this.snd = snd;
    }

    public String getSeparator() {
        return DEFAULT_SEPARATOR;
    }

    @Override
    public String getName() {
        return this.fst.getName() + this.getSeparator() + this.snd.getName();
    }

    public ISymbol getFirst() {
        return this.fst;
    }

    public ISymbol getSecond() {
        return this.snd;
    }

    @Override
    public boolean matches(ISymbol symbol, IMatchContext ctx) {
        if (!symbol.getClass().equals(this.getClass())) {
            return false;
        }
        PairSymbol psym = (PairSymbol)symbol;
        return this.fst.matches(psym.getFirst(), ctx) && this.snd.matches(psym.getSecond(), ctx);
    }

    @Override
    public boolean possiblyMatches(ISymbol symbol, IMatchContext ctx) {
        if (!symbol.getClass().equals(this.getClass())) {
            return false;
        }
        PairSymbol psym = (PairSymbol)symbol;
        return this.fst.possiblyMatches(psym.getFirst(), ctx) && this.snd.possiblyMatches(psym.getSecond(), ctx);
    }

    @Override
    public void traverse(ISymbolVisitor visitor) {
        visitor.onVisit(this);
        this.getFirst().traverse(visitor);
        this.getSecond().traverse(visitor);
        visitor.onLeave(this);
    }

    @Override
    public ISymbol copy(ISymbolCopier copier) {
        ISymbol s = copier.copy(this);
        if (s instanceof PairSymbol) {
            PairSymbol ps = (PairSymbol)s;
            ps.snd = copier.copySymbolReference(ps, ps.snd);
            ps.fst = copier.copySymbolReference(ps, ps.fst);
        }
        return s;
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int size() {
        return 0;
    }

    public int hashCode() {
        return (this.fst == null ? 0 : this.fst.hashCode()) + (this.snd == null ? 0 : this.snd.hashCode());
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PairSymbol)) {
            return false;
        }
        PairSymbol psym = (PairSymbol)obj;
        return (this.fst == null ? psym.getFirst() == null : this.fst.equals(psym.getFirst())) && (this.snd == null ? psym.getSecond() == null : this.snd.equals(psym.getSecond()));
    }

    public String toString() {
        return "'" + this.getName() + "'";
    }
}

