/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.tree;

import com.ibm.wala.automaton.string.IState;
import com.ibm.wala.automaton.string.ITransition;
import com.ibm.wala.automaton.string.MatchContext;
import com.ibm.wala.automaton.string.StateTransitionSystem;
import com.ibm.wala.automaton.tree.IBinaryTree;
import com.ibm.wala.automaton.tree.IParentBinaryTree;
import com.ibm.wala.automaton.tree.ITreeAutomaton;
import com.ibm.wala.automaton.tree.ITreeTransition;
import com.ibm.wala.automaton.tree.StateBinaryTree;
import java.util.HashSet;
import java.util.Set;

public class TopDownTreeAutomaton
extends StateTransitionSystem
implements ITreeAutomaton {
    public TopDownTreeAutomaton(IState initState, ITransition[] transitions) {
        super(initState, transitions);
    }

    public TopDownTreeAutomaton(IState initState, Set<ITreeTransition> transitions) {
        super(initState, transitions);
    }

    private Set<IBinaryTree> translateRec(IBinaryTree tree) {
        if (tree instanceof StateBinaryTree) {
            return this.translateState(tree);
        }
        if (tree instanceof IParentBinaryTree) {
            IParentBinaryTree ptree = (IParentBinaryTree)tree;
            Set<IBinaryTree> rset = this.translateRec(ptree.getRight());
            Set<IBinaryTree> lset = this.translateRec(ptree.getLeft());
            HashSet<IBinaryTree> s = new HashSet<IBinaryTree>();
            for (IBinaryTree rbt : rset) {
                for (IBinaryTree lbt : lset) {
                    IParentBinaryTree bt = (IParentBinaryTree)tree.clone();
                    bt.setLeft(lbt);
                    bt.setRight(rbt);
                    s.add(bt);
                }
            }
            return s;
        }
        HashSet<IBinaryTree> s = new HashSet<IBinaryTree>();
        s.add(tree);
        return s;
    }

    private Set<IBinaryTree> translateState(IBinaryTree tree) {
        HashSet<IBinaryTree> s = new HashSet<IBinaryTree>();
        for (ITreeTransition iTreeTransition : this.getTransitions()) {
            MatchContext ctx;
            if (!iTreeTransition.accept(tree, ctx = new MatchContext())) continue;
            IBinaryTree bt = iTreeTransition.transit(tree);
            Set<IBinaryTree> bt2 = this.translateRec(bt);
            s.addAll(bt2);
        }
        return s;
    }

    public Set<IBinaryTree> translate(IBinaryTree tree, IState state) {
        StateBinaryTree sbt = new StateBinaryTree(tree, state);
        return this.translateState(sbt);
    }

    @Override
    public Set<IBinaryTree> translate(IBinaryTree tree) {
        return this.translate(tree, this.getInitialState());
    }

    @Override
    public boolean accept(IBinaryTree tree) {
        return !this.translate(tree).isEmpty();
    }
}

