/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.util.collections;

import com.ibm.wala.automaton.util.collections.AbstractUnremovalCollection;
import com.ibm.wala.util.collections.CompoundIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Bag<T>
extends AbstractUnremovalCollection<T> {
    private Set<T> elements;
    private Set<Collection<? extends T>> collections;

    public Bag() {
        this.elements = new HashSet<T>();
        this.collections = new HashSet<Collection<? extends T>>();
    }

    public Bag(Collection<? extends T> c) {
        this.addAll(c);
    }

    @Override
    public boolean add(T e) {
        return this.elements.add(e);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.collections.add(c);
    }

    @Override
    public void clear() {
        this.elements.clear();
        this.collections.clear();
    }

    @Override
    public boolean contains(Object o) {
        if (this.elements.contains(o)) {
            return true;
        }
        for (Collection<T> c : this.collections) {
            if (!c.contains(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isEmpty() {
        if (!this.elements.isEmpty()) {
            return false;
        }
        for (Collection<T> c : this.collections) {
            if (c.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<T> iterator() {
        CompoundIterator iter = this.elements.iterator();
        for (Collection<T> c : this.collections) {
            iter = new CompoundIterator(iter, c.iterator());
        }
        return iter;
    }

    @Override
    public int size() {
        int i = this.elements.size();
        for (Collection<T> c : this.collections) {
            i += c.size();
        }
        return i;
    }

    @Override
    public Object[] toArray() {
        ArrayList<? extends T> l = new ArrayList<T>(this.elements.size());
        for (Collection<? extends T> collection : this.collections) {
            l.addAll(collection);
        }
        return l.toArray();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        ArrayList<? extends T> l = new ArrayList<T>(this.elements.size());
        for (Collection<? extends T> collection : this.collections) {
            l.addAll(collection);
        }
        return l.toArray(a);
    }
}

