/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.util.collections;

import com.ibm.wala.automaton.util.collections.BinaryFunction;
import com.ibm.wala.automaton.util.collections.BooleanFunction;
import com.ibm.wala.automaton.util.collections.SnocList;
import com.ibm.wala.util.functions.Function;
import com.ibm.wala.util.functions.IntFunction;
import com.ibm.wala.util.intset.IntIterator;
import com.ibm.wala.util.intset.IntSet;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Stack;

public class CollectionUtil {
    public static <T, U> void map(Collection<? extends T> src, Function<? super T, ? extends U> f, Collection<? super U> dest) {
        for (T e : src) {
            dest.add(f.apply(e));
        }
    }

    public static <T, U> void map(SnocList<? extends T> src, Function<? super T, ? extends U> f, Collection<? super U> dest) {
        if (src == null) {
            return;
        }
        Stack<Object> stack = new Stack<Object>();
        SnocList<T> cell = src;
        int len = src.size();
        for (int i = len - 1; i >= 0; --i) {
            Object e = f.apply(cell.last);
            stack.push(e);
            cell = cell.init;
        }
        while (!stack.empty()) {
            dest.add(stack.pop());
        }
    }

    public static <T, U> U foldr(Collection<? extends T> src, BinaryFunction<? super T, ? super U, ? extends U> f, U seed) {
        if (src.isEmpty()) {
            return seed;
        }
        Iterator<T> it = src.iterator();
        Stack<T> stack = new Stack<T>();
        while (it.hasNext()) {
            stack.push(it.next());
        }
        U ret = seed;
        while (!stack.empty()) {
            Object e = stack.pop();
            ret = f.apply(e, ret);
        }
        return ret;
    }

    public static <T, U> U foldl(Collection<? extends T> src, BinaryFunction<? super U, ? super T, ? extends U> f, U seed) {
        if (src.isEmpty()) {
            return seed;
        }
        U ret = seed;
        for (T e : src) {
            ret = f.apply(ret, e);
        }
        return ret;
    }

    public static <T, U> U foldr(SnocList<? extends T> src, BinaryFunction<? super T, ? super U, ? extends U> f, U seed) {
        if (src == null) {
            return seed;
        }
        U ret = seed;
        SnocList<T> cell = src;
        int len = src.size();
        for (int i = len - 1; i >= 0; --i) {
            ret = f.apply(cell.last, ret);
            cell = cell.init;
        }
        return ret;
    }

    public static <T, U> U foldl(SnocList<? extends T> src, BinaryFunction<? super U, ? super T, ? extends U> f, U seed) {
        if (src == null) {
            return seed;
        }
        U ret = seed;
        Stack stack = new Stack();
        SnocList<T> cell = src;
        int len = src.size();
        for (int i = len - 1; i >= 0; --i) {
            stack.push(cell.last);
            cell = cell.init;
        }
        while (!stack.empty()) {
            Object e = stack.pop();
            ret = f.apply(ret, e);
        }
        return ret;
    }

    public static <T, U> U[] arrayMap(T[] src, Function<? super T, ? extends U> f) {
        Object[] arr = new Object[src.length];
        int i = 0;
        for (T e : src) {
            arr[i++] = f.apply(e);
        }
        Object[] ret = (Object[])Array.newInstance(arr[0].getClass(), arr.length);
        System.arraycopy(arr, 0, ret, 0, arr.length);
        return ret;
    }

    public static <U> void intSetMap(IntSet src, IntFunction<? extends U> f, Collection<? super U> dest) {
        IntIterator it = src.intIterator();
        while (it.hasNext()) {
            int e = it.next();
            dest.add(f.apply(e));
        }
    }

    public static <U> U[] intArrayMap(int[] src, IntFunction<? extends U> f) {
        Object[] arr = new Object[src.length];
        int i = 0;
        for (int e : src) {
            arr[i++] = f.apply(e);
        }
        Object[] ret = (Object[])Array.newInstance(arr[0].getClass(), arr.length);
        System.arraycopy(arr, 0, ret, 0, arr.length);
        return ret;
    }

    public static <T, R> R foldl(Collection<? extends T> c, R ini, BinaryFunction<? super R, ? super T, ? extends R> f) {
        R acc = ini;
        for (T elem : c) {
            acc = f.apply(acc, elem);
        }
        return acc;
    }

    public static <T, U> Collection<U> map(Collection<? extends T> c, Collection<U> r, Function<? super T, ? extends U> f) {
        for (T elem : c) {
            r.add(f.apply(elem));
        }
        return r;
    }

    public static <T, U, R> R mapFoldl(Collection<? extends T> c, R ini, Function<? super T, ? extends U> map, BinaryFunction<? super R, ? super U, ? extends R> foldl) {
        return CollectionUtil.foldl(CollectionUtil.map(c, new LinkedList(), map), ini, foldl);
    }

    public static <T> Collection<T> select(Collection<? extends T> c, Collection<T> r, BooleanFunction<T> f) {
        for (T elem : c) {
            if (!f.apply(elem)) continue;
            r.add(elem);
        }
        return r;
    }
}

