/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.wala.automaton.util.collections;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class LexicographicComparatorForList<T extends Comparable<T>>
implements Comparator<List<? extends T>> {
    private final Comparator<? super T> comp;

    public LexicographicComparatorForList() {
        this.comp = new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                return o1.compareTo(o2);
            }
        };
    }

    public LexicographicComparatorForList(Comparator<? super T> c) {
        this.comp = c;
    }

    @Override
    public int compare(List<? extends T> o1, List<? extends T> o2) {
        int x;
        Iterator<T> i1 = o1.iterator();
        Iterator<T> i2 = o2.iterator();
        do {
            Comparable e2;
            if (!i1.hasNext()) {
                if (!i2.hasNext()) {
                    return 0;
                }
                return -1;
            }
            if (!i2.hasNext()) {
                return 1;
            }
            Comparable e1 = (Comparable)i1.next();
            x = this.comp.compare(e1, e2 = (Comparable)i2.next());
            if (x >= 0) continue;
            return -1;
        } while (x <= 0);
        return 1;
    }
}

